/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.entity;

import java.util.EnumSet;
import net.hiccupslegacy.ai.HurtByTargetDragonGoal;
import net.hiccupslegacy.ai.WaterAvoidingRandomDragonStrollGoal;
import net.hiccupslegacy.entity.FlyingDragonEntity;
import net.hiccupslegacy.entity.eggs.AgeableEgg;
import net.hiccupslegacy.init.HiccupsLegacyModEntities;
import net.hiccupslegacy.init.HiccupsLegacyModParticleTypes;
import net.hiccupslegacy.procedures.DragonAttackOtherEntitiesConditionProcedure;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class FlightmareFlyEntity
extends FlyingDragonEntity {
    public static final Ingredient TAME_FOOD = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151079_, Items.f_151056_, Items.f_151025_});
    private int lastSmokeTick = 0;

    public FlightmareFlyEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<FlightmareFlyEntity>)((EntityType)HiccupsLegacyModEntities.FLIGHTMARE_FLY.get()), world);
    }

    public FlightmareFlyEntity(EntityType<FlightmareFlyEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 20;
        this.m_21557_(false);
        this.m_21530_();
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new Goal(){
            {
                this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean m_8036_() {
                return FlightmareFlyEntity.this.m_5448_() != null && !FlightmareFlyEntity.this.m_21566_().m_24995_();
            }

            public boolean m_8045_() {
                return FlightmareFlyEntity.this.m_21566_().m_24995_() && FlightmareFlyEntity.this.m_5448_() != null && FlightmareFlyEntity.this.m_5448_().m_6084_();
            }

            public void m_8056_() {
                LivingEntity livingentity = FlightmareFlyEntity.this.m_5448_();
                Vec3 vec3d = livingentity.m_20299_(1.0f);
                FlightmareFlyEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
            }

            public void m_8037_() {
                LivingEntity livingentity = FlightmareFlyEntity.this.m_5448_();
                if (FlightmareFlyEntity.this.m_20191_().m_82381_(livingentity.m_20191_())) {
                    FlightmareFlyEntity.this.m_7327_((Entity)livingentity);
                } else {
                    double d0 = FlightmareFlyEntity.this.m_20280_((Entity)livingentity);
                    if (d0 < 16.0) {
                        Vec3 vec3d = livingentity.m_20299_(1.0f);
                        FlightmareFlyEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
                    }
                }
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, TAME_FOOD, false));
        this.f_21346_.m_25352_(6, (Goal)new HurtByTargetDragonGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomDragonStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(9, (Goal)new NearestAttackableTargetGoal<Pillager>((Mob)this, Pillager.class, false, false){

            public boolean m_8036_() {
                FlightmareFlyEntity entity = FlightmareFlyEntity.this;
                return super.m_8036_() && DragonAttackOtherEntitiesConditionProcedure.execute((Entity)entity);
            }
        });
    }

    @Override
    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    @Override
    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)Items.f_42696_));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    @Override
    protected void dragonTypeTickProcedure() {
        Level level;
        super.dragonTypeTickProcedure();
        int smokeDifference = this.f_19797_ - this.lastSmokeTick;
        if (smokeDifference >= 300) {
            this.lastSmokeTick = this.f_19797_;
        } else if (smokeDifference >= 200 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)level;
            _level.m_8767_((ParticleOptions)((SimpleParticleType)HiccupsLegacyModParticleTypes.NF_SMOKE_1.get()), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 5, 1.0, 0.5, 1.0, 0.0);
        }
    }

    public AgeableEgg getBreedOffspring(ServerLevel serverLevel, AgeableMob parent) {
        return (AgeableEgg)((EntityType)HiccupsLegacyModEntities.FLIGHTMARE_EGG.get()).m_20615_((Level)serverLevel);
    }

    public boolean m_6898_(ItemStack stack) {
        return TAME_FOOD.test(stack);
    }

    @Override
    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.m_20242_(true);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.8);
        builder = builder.m_22268_(Attributes.f_22276_, 70.0);
        builder = builder.m_22268_(Attributes.f_22284_, 1.0);
        builder = builder.m_22268_(Attributes.f_22281_, 10.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.7);
        builder = builder.m_22268_(Attributes.f_22280_, 0.8);
        return builder;
    }

    @Override
    public int getVariantAmount() {
        return 4;
    }
}

