/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.entity;

import java.util.Comparator;
import java.util.List;
import net.hiccupslegacy.entity.LargeDragonProjectileEntity;
import net.hiccupslegacy.init.HiccupsLegacyModEntities;
import net.hiccupslegacy.init.HiccupsLegacyModMobEffects;
import net.hiccupslegacy.init.HiccupsLegacyModSounds;
import net.hiccupslegacy.procedures.RedDeathKilledProcedure;
import net.hiccupslegacy.procedures.RedDeathOnTickUpdateProcedure;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;

public class RedDeathEntity
extends Monster
implements RangedAttackMob {
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_6);
    private static final EntityDataAccessor<Integer> OPEN_MOUTH_TICKS = SynchedEntityData.m_135353_(RedDeathEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float lastJawAngle = 0.0f;

    public RedDeathEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<RedDeathEntity>)((EntityType)HiccupsLegacyModEntities.RED_DEATH.get()), world);
    }

    public RedDeathEntity(EntityType<RedDeathEntity> type, Level world) {
        super(type, world);
        this.m_274367_(2.0f);
        this.f_21364_ = 3200;
        this.m_21530_();
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new MoveControl((Mob)this){

            public void m_8126_() {
                if (RedDeathEntity.this.m_20069_()) {
                    RedDeathEntity.this.m_20256_(RedDeathEntity.this.m_20184_().m_82520_(0.0, 0.005, 0.0));
                }
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !RedDeathEntity.this.m_21573_().m_26571_()) {
                    double dx = this.f_24975_ - RedDeathEntity.this.m_20185_();
                    double dy = this.f_24976_ - RedDeathEntity.this.m_20186_();
                    double dz = this.f_24977_ - RedDeathEntity.this.m_20189_();
                    float f = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.f_24978_ * RedDeathEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                    RedDeathEntity.this.m_146922_(this.m_24991_(RedDeathEntity.this.m_146908_(), f, 10.0f));
                    RedDeathEntity.this.f_20883_ = RedDeathEntity.this.m_146908_();
                    RedDeathEntity.this.f_20885_ = RedDeathEntity.this.m_146908_();
                    if (RedDeathEntity.this.m_20069_()) {
                        RedDeathEntity.this.m_7910_((float)RedDeathEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                        float f2 = -((float)(Mth.m_14136_((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.m_14036_((float)Mth.m_14177_((float)f2), (float)-85.0f, (float)85.0f);
                        RedDeathEntity.this.m_146926_(this.m_24991_(RedDeathEntity.this.m_146909_(), f2, 5.0f));
                        float f3 = Mth.m_14089_((float)(RedDeathEntity.this.m_146909_() * ((float)Math.PI / 180)));
                        RedDeathEntity.this.m_21564_(f3 * f1);
                        RedDeathEntity.this.m_21567_((float)((double)f1 * dy));
                    } else {
                        RedDeathEntity.this.m_7910_(f1 * 0.05f);
                    }
                } else {
                    RedDeathEntity.this.m_7910_(0.0f);
                    RedDeathEntity.this.m_21567_(0.0f);
                    RedDeathEntity.this.m_21564_(0.0f);
                }
            }
        };
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OPEN_MOUTH_TICKS, (Object)0);
    }

    public int getOpenMouthTicks() {
        return (Integer)this.f_19804_.m_135370_(OPEN_MOUTH_TICKS);
    }

    public void setOpenMouthTicks(int openMouthTicks) {
        this.f_19804_.m_135381_(OPEN_MOUTH_TICKS, (Object)openMouthTicks);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal(this, 1.25, 80, 10.0f){

            public boolean m_8045_() {
                return this.m_8036_();
            }
        });
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)HiccupsLegacyModSounds.RED_DEATH_IDLE.get();
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return SoundEvents.f_11915_;
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)HiccupsLegacyModSounds.RED_DEATH_IDLE.get();
    }

    public void m_8032_() {
        super.m_8032_();
        Vec3 _center = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        List<Entity> _entfound = this.m_9236_().m_6443_(Entity.class, new AABB(_center, _center).m_82400_(25.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).toList();
        for (Entity entityiterator : _entfound) {
            ServerPlayer _entity;
            Player _entity2;
            if (entityiterator instanceof Player && !(_entity2 = (Player)entityiterator).m_9236_().m_5776_()) {
                _entity2.m_7292_(new MobEffectInstance((MobEffect)HiccupsLegacyModMobEffects.SCREEN_SHAKE.get(), 80, 5, false, false));
                continue;
            }
            if (!(entityiterator instanceof ServerPlayer) || (_entity = (ServerPlayer)entityiterator).m_9236_().m_5776_()) continue;
            _entity.m_7292_(new MobEffectInstance((MobEffect)HiccupsLegacyModMobEffects.SCREEN_SHAKE.get(), 80, 5, false, false));
        }
    }

    protected float m_6121_() {
        return 4.0f;
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (damagesource.m_7640_() instanceof ThrownPotion || damagesource.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268526_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        if (damagesource.m_7640_() instanceof SpectralArrow || damagesource.m_7640_() instanceof Arrow) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public int m_21529_() {
        return 4;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        RedDeathKilledProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), source.m_7639_());
    }

    public boolean m_5825_() {
        return true;
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.getOpenMouthTicks() > 0) {
            this.setOpenMouthTicks(this.getOpenMouthTicks() - 1);
        }
        RedDeathOnTickUpdateProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this);
    }

    public void m_6504_(LivingEntity target, float flval) {
        Level projectileLevel = this.m_9236_();
        this.setOpenMouthTicks(40);
        if (!projectileLevel.m_5776_()) {
            LargeDragonProjectileEntity entityarrow = new LargeDragonProjectileEntity((EntityType<? extends LargeDragonProjectileEntity>)((EntityType)HiccupsLegacyModEntities.LARGE_DRAGON_PROJECTILE.get()), (LivingEntity)this, projectileLevel);
            double dx = target.m_20185_() - this.m_20185_();
            double dy = target.m_20186_() + (double)target.m_20192_() - 3.1;
            double dz = target.m_20189_() - this.m_20189_();
            entityarrow.m_5602_((Entity)this);
            entityarrow.m_6034_(this.m_20185_(), this.m_20188_() + 13.0, this.m_20189_());
            entityarrow.m_6686_(dx, dy - entityarrow.m_20186_(), dz, 6.0f, 1.0f);
            entityarrow.m_20225_(true);
            entityarrow.m_36781_(3.0);
            entityarrow.m_36735_(3);
            entityarrow.m_36762_(false);
            entityarrow.m_20254_(100);
            entityarrow.m_20242_(true);
            projectileLevel.m_7967_((Entity)entityarrow);
        }
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.15);
        builder = builder.m_22268_(Attributes.f_22276_, 500.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        builder = builder.m_22268_(Attributes.f_22281_, 30.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        builder = builder.m_22268_(Attributes.f_22278_, 2.0);
        builder = builder.m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.15);
        return builder;
    }
}

