/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.entity;

import net.hiccupslegacy.init.HiccupsLegacyModEntities;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class SpikeProjectileEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)Items.f_42412_);
    public SpikeType spikeType = SpikeType.NADDER;

    public SpikeProjectileEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)HiccupsLegacyModEntities.SPIKE_PROJECTILE.get(), world);
    }

    public SpikeProjectileEntity(EntityType<? extends SpikeProjectileEntity> type, Level world) {
        super(type, world);
    }

    public SpikeProjectileEntity(EntityType<? extends SpikeProjectileEntity> type, Level world, SpikeType spikeType) {
        super(type, world);
        this.spikeType = spikeType;
    }

    public SpikeProjectileEntity(EntityType<? extends SpikeProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public SpikeProjectileEntity(EntityType<? extends SpikeProjectileEntity> type, double x, double y, double z, Level world, SpikeType spikeType) {
        super(type, x, y, z, world);
        this.spikeType = spikeType;
    }

    public SpikeProjectileEntity(EntityType<? extends SpikeProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public SpikeProjectileEntity(EntityType<? extends SpikeProjectileEntity> type, LivingEntity entity, Level world, SpikeType spikeType) {
        super(type, entity, world);
        this.spikeType = spikeType;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public ItemStack m_7846_() {
        return PROJECTILE_ITEM;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return PROJECTILE_ITEM;
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 80, 0, false, true, true));
    }

    protected void m_5790_(EntityHitResult hitEntity) {
        super.m_5790_(hitEntity);
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public static SpikeProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return SpikeProjectileEntity.shoot(world, entity, source, 1.0f, 2.0, 0);
    }

    public static SpikeProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return SpikeProjectileEntity.shoot(world, entity, source, pullingPower, 2.0, 0);
    }

    public static SpikeProjectileEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        SpikeProjectileEntity entityarrow = new SpikeProjectileEntity((EntityType<? extends SpikeProjectileEntity>)((EntityType)HiccupsLegacyModEntities.SPIKE_PROJECTILE.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static SpikeProjectileEntity shoot(LivingEntity entity, LivingEntity target) {
        SpikeProjectileEntity entityarrow = new SpikeProjectileEntity((EntityType<? extends SpikeProjectileEntity>)((EntityType)HiccupsLegacyModEntities.SPIKE_PROJECTILE.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(2.0);
        entityarrow.m_36735_(0);
        entityarrow.m_36762_(false);
        entity.m_9236_().m_7967_((Entity)entityarrow);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f));
        return entityarrow;
    }

    public static enum SpikeType {
        NADDER(0),
        WHISPERING_DEATH(1);

        final int type;

        private SpikeType(int i) {
            this.type = i;
        }

        public int getType() {
            return this.type;
        }
    }
}

