/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.procedures;

import java.util.ArrayList;
import java.util.UUID;
import net.hiccupslegacy.entity.DragonEntity;
import net.hiccupslegacy.entity.FlyingDragonEntity;
import net.hiccupslegacy.procedures.DragonMapperProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class ReplaceDragonProcedure {
    public static void replaceWithFlyingCounterpart(LevelAccessor world, double x, double y, double z, LivingEntity currentDragon, Entity playerPassenger) {
        if (currentDragon == null) {
            return;
        }
        EntityType<?> flyingType = DragonMapperProcedure.getFlyingDragon(currentDragon.m_6095_());
        if (flyingType == null) {
            return;
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            LivingEntity entityToSpawn = (LivingEntity)flyingType.m_20615_((Level)serverLevel);
            ReplaceDragonProcedure.replaceDragon(serverLevel, currentDragon, entityToSpawn, playerPassenger);
        }
    }

    public static void replaceWithWalkingCounterpart(LevelAccessor world, double x, double y, double z, LivingEntity currentDragon, Entity playerPassenger) {
        if (currentDragon == null) {
            return;
        }
        EntityType<?> walkingType = DragonMapperProcedure.getWalkingDragon(currentDragon.m_6095_());
        if (walkingType == null) {
            return;
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            LivingEntity entityToSpawn = (LivingEntity)walkingType.m_20615_((Level)serverLevel);
            ReplaceDragonProcedure.replaceDragon(serverLevel, currentDragon, entityToSpawn, playerPassenger);
        }
    }

    private static void replaceDragon(ServerLevel serverLevel, LivingEntity currentDragon, LivingEntity entityToSpawn, Entity playerPassenger) {
        if (entityToSpawn != null) {
            Component customName;
            DragonEntity dragon;
            float yaw = currentDragon.m_146908_();
            double health = currentDragon.m_21223_();
            DragonEntity dragonEntity = currentDragon instanceof DragonEntity ? (dragon = (DragonEntity)currentDragon) : null;
            int variant = dragonEntity == null ? 0 : dragonEntity.getVariantId();
            int tamingFoodAmount = dragonEntity == null ? 0 : dragonEntity.getTamingFoodAmount();
            ArrayList passengers = new ArrayList(currentDragon.m_20197_());
            if (entityToSpawn instanceof DragonEntity) {
                DragonEntity _dragon = (DragonEntity)entityToSpawn;
                _dragon.setVariantId(variant);
                _dragon.setTamingFoodAmount(tamingFoodAmount);
                _dragon.m_6710_(dragonEntity == null ? null : dragonEntity.m_5448_());
                if (currentDragon instanceof DragonEntity) {
                    int secondaryTick;
                    DragonEntity dragon2 = (DragonEntity)currentDragon;
                    if (dragon2.m_21532_()) {
                        _dragon.m_21530_();
                    }
                    if ((secondaryTick = dragon2.getSecondaryAttackTick()) != -1) {
                        int ticks = dragon2.f_19797_ - secondaryTick;
                        _dragon.setSecondaryAttackTick(_dragon.getSecondaryAttackTick() - ticks);
                    }
                }
                if (currentDragon instanceof FlyingDragonEntity) {
                    FlyingDragonEntity flyingDragonEntity = (FlyingDragonEntity)currentDragon;
                    if (flyingDragonEntity.getWasRidden()) {
                        _dragon.setMovementType(3);
                    }
                    _dragon.m_20256_(currentDragon.m_20184_());
                } else {
                    DragonEntity dragon3;
                    if (currentDragon instanceof DragonEntity && (dragon3 = (DragonEntity)currentDragon).getMovementType() == 3 && _dragon instanceof FlyingDragonEntity) {
                        FlyingDragonEntity flying = (FlyingDragonEntity)_dragon;
                        flying.setWasRidden(true);
                    }
                    _dragon.m_20334_(currentDragon.m_20184_().f_82479_, currentDragon.m_20184_().f_82480_ + 0.5, currentDragon.m_20184_().f_82481_);
                }
            } else if (entityToSpawn instanceof Monster) {
                Monster dragonMonster = (Monster)entityToSpawn;
                if (currentDragon instanceof Monster) {
                    Monster currentMonster = (Monster)currentDragon;
                    dragonMonster.m_6710_(currentMonster.m_5448_());
                }
            }
            if (entityToSpawn instanceof TamableAnimal) {
                TamableAnimal tamableDragon = (TamableAnimal)entityToSpawn;
                if (dragonEntity != null && dragonEntity.m_21824_()) {
                    tamableDragon.m_21816_(dragonEntity.m_21805_());
                    tamableDragon.m_7105_(true);
                }
            }
            if ((customName = currentDragon.m_7770_()) != null) {
                entityToSpawn.m_6593_(customName);
            }
            entityToSpawn.m_21153_((float)health);
            entityToSpawn.m_146922_(yaw);
            entityToSpawn.f_19859_ = yaw;
            entityToSpawn.m_5618_(yaw);
            entityToSpawn.m_5616_(yaw);
            entityToSpawn.m_146884_(new Vec3(currentDragon.m_20185_(), currentDragon.m_20186_(), currentDragon.m_20189_()));
            for (MobEffectInstance effect : currentDragon.m_21220_()) {
                entityToSpawn.m_7292_(effect);
            }
            if (!currentDragon.m_9236_().m_5776_()) {
                UUID currentDragonUUID = currentDragon.m_20148_();
                currentDragon.m_146870_();
                entityToSpawn.m_20084_(currentDragonUUID);
            }
            serverLevel.m_7967_((Entity)entityToSpawn);
            if (playerPassenger != null) {
                playerPassenger.m_20329_((Entity)entityToSpawn);
                if (!passengers.isEmpty()) {
                    for (Entity passenger : passengers) {
                        if (!(passenger instanceof LivingEntity)) continue;
                        LivingEntity livingPassenger = (LivingEntity)passenger;
                        livingPassenger.m_20329_((Entity)entityToSpawn);
                    }
                }
            }
        }
    }
}

