/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.BlockGoldPile;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.util.HomePosition;
import com.github.alexthe666.iceandfire.util.WorldUtil;
import com.github.alexthe666.iceandfire.world.IafWorldData;
import com.github.alexthe666.iceandfire.world.gen.TypedFeature;
import com.github.alexthe666.iceandfire.world.gen.WorldGenRoostArch;
import com.github.alexthe666.iceandfire.world.gen.WorldGenRoostBoulder;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.jetbrains.annotations.NotNull;

public abstract class WorldGenDragonRoosts
extends Feature<NoneFeatureConfiguration>
implements TypedFeature {
    protected static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    protected final Block treasureBlock;

    public WorldGenDragonRoosts(Codec<NoneFeatureConfiguration> configuration, Block treasureBlock) {
        super(configuration);
        this.treasureBlock = treasureBlock;
    }

    @Override
    public String getId() {
        return "dragon_roost";
    }

    @Override
    public IafWorldData.FeatureType getFeatureType() {
        return IafWorldData.FeatureType.SURFACE;
    }

    public boolean m_142674_(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> context) {
        if (!WorldUtil.canGenerate(IafConfig.generateDragonRoostChance, context.m_159774_(), context.m_225041_(), context.m_159777_(), this.getId(), true)) {
            return false;
        }
        boolean isMale = new Random().nextBoolean();
        int radius = 12 + context.m_225041_().m_188503_(8);
        this.spawnDragon(context, radius, isMale);
        this.generateSurface(context, radius);
        this.generateShell(context, radius);
        this.hollowOut(context, radius -= 2);
        this.generateDecoration(context, radius += 15, isMale);
        return true;
    }

    protected void generateRoostPile(WorldGenLevel level, RandomSource random, BlockPos position, Block block) {
        int radius = random.m_188503_(4);
        for (int i = 0; i < radius; ++i) {
            int layeredRadius = radius - i;
            double circularArea = this.getCircularArea(radius);
            BlockPos up = position.m_6630_(i);
            for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)up.m_7918_(-layeredRadius, 0, -layeredRadius), (BlockPos)up.m_7918_(layeredRadius, 0, layeredRadius)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                if (!(blockpos.m_123331_((Vec3i)position) <= circularArea)) continue;
                level.m_7731_(blockpos, block.m_49966_(), 2);
            }
        }
    }

    protected double getCircularArea(int radius, int height) {
        double area = (float)(radius + height + radius) * 0.333f + 0.5f;
        return Mth.m_14107_((double)(area * area));
    }

    protected double getCircularArea(int radius) {
        double area = (float)(radius + radius) * 0.333f + 0.5f;
        return Mth.m_14107_((double)(area * area));
    }

    protected BlockPos getSurfacePosition(WorldGenLevel level, BlockPos position) {
        return level.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, position);
    }

    protected BlockState transform(Block block) {
        return this.transform(block.m_49966_());
    }

    private void generateDecoration(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> context, int radius, boolean isMale) {
        int height = radius / 5;
        double circularArea = this.getCircularArea(radius, height);
        BlockPos.m_121990_((BlockPos)context.m_159777_().m_7918_(-radius, -height, -radius), (BlockPos)context.m_159777_().m_7918_(radius, height, radius)).map(BlockPos::m_7949_).forEach(position -> {
            if (position.m_123331_((Vec3i)context.m_159777_()) <= circularArea) {
                BlockState transformed;
                BlockState state;
                double distance = position.m_123331_((Vec3i)context.m_159777_()) / circularArea;
                if (!context.m_159774_().m_46859_(context.m_159777_()) && context.m_225041_().m_188500_() > distance * 0.5 && !((state = context.m_159774_().m_8055_(position)).m_60734_() instanceof BaseEntityBlock) && state.m_60800_((BlockGetter)context.m_159774_(), position) >= 0.0f && (transformed = this.transform(state)) != state) {
                    context.m_159774_().m_7731_(position, transformed, 2);
                }
                this.handleCustomGeneration(context, (BlockPos)position, distance);
                if (distance > 0.5 && context.m_225041_().m_188503_(1000) == 0) {
                    new WorldGenRoostBoulder(this.transform(Blocks.f_50652_).m_60734_(), context.m_225041_().m_188503_(3), true).generate((LevelAccessor)context.m_159774_(), context.m_225041_(), this.getSurfacePosition(context.m_159774_(), (BlockPos)position));
                }
                if (distance < 0.3 && context.m_225041_().m_188503_(isMale ? 200 : 300) == 0) {
                    this.generateTreasurePile(context.m_159774_(), context.m_225041_(), (BlockPos)position);
                }
                if (distance < 0.3 && context.m_225041_().m_188503_(isMale ? 500 : 700) == 0) {
                    BlockEntity blockEntity;
                    BlockPos surfacePosition = context.m_159774_().m_5452_(Heightmap.Types.WORLD_SURFACE, position);
                    boolean wasPlaced = context.m_159774_().m_7731_(surfacePosition, (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)HORIZONTALS[new Random().nextInt(3)]), 2);
                    if (wasPlaced && (blockEntity = context.m_159774_().m_7702_(surfacePosition)) instanceof ChestBlockEntity) {
                        ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                        chest.m_59626_(this.getRoostLootTable(), context.m_225041_().m_188505_());
                    }
                }
                if (context.m_225041_().m_188503_(5000) == 0) {
                    new WorldGenRoostArch(this.transform(Blocks.f_50652_).m_60734_()).generate((LevelAccessor)context.m_159774_(), context.m_225041_(), this.getSurfacePosition(context.m_159774_(), (BlockPos)position));
                }
            }
        });
    }

    private void hollowOut(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> context, int radius) {
        int height = 2;
        double circularArea = this.getCircularArea(radius, height);
        BlockPos up = context.m_159777_().m_6630_(height - 1);
        BlockPos.m_121990_((BlockPos)up.m_7918_(-radius, 0, -radius), (BlockPos)up.m_7918_(radius, height, radius)).map(BlockPos::m_7949_).forEach(position -> {
            if (position.m_123331_((Vec3i)context.m_159777_()) <= circularArea) {
                context.m_159774_().m_7731_(position, Blocks.f_50016_.m_49966_(), 2);
            }
        });
    }

    private void generateShell(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> context, int radius) {
        int height = radius / 5;
        double circularArea = this.getCircularArea(radius, height);
        BlockPos.m_121990_((BlockPos)context.m_159777_().m_7918_(-radius, -height, -radius), (BlockPos)context.m_159777_().m_7918_(radius, 1, radius)).map(BlockPos::m_7949_).forEach(position -> {
            if (position.m_123331_((Vec3i)context.m_159777_()) < circularArea) {
                context.m_159774_().m_7731_(position, context.m_225041_().m_188499_() ? this.transform(Blocks.f_49994_) : this.transform(Blocks.f_50493_), 2);
            } else if (position.m_123331_((Vec3i)context.m_159777_()) == circularArea) {
                context.m_159774_().m_7731_(position, this.transform(Blocks.f_50652_), 2);
            }
        });
    }

    private void generateSurface(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> context, int radius) {
        int height = 2;
        double circularArea = this.getCircularArea(radius, height);
        BlockPos.m_121990_((BlockPos)context.m_159777_().m_7918_(-radius, height, -radius), (BlockPos)context.m_159777_().m_7918_(radius, 0, radius)).map(BlockPos::m_7949_).forEach(position -> {
            int heightDifference = position.m_123342_() - context.m_159777_().m_123342_();
            if (position.m_123331_((Vec3i)context.m_159777_()) <= circularArea && heightDifference < 2 + context.m_225041_().m_188503_(height) && !context.m_159774_().m_46859_(position.m_7495_())) {
                if (context.m_159774_().m_46859_(position.m_7494_())) {
                    context.m_159774_().m_7731_(position, this.transform(Blocks.f_50034_), 2);
                } else {
                    context.m_159774_().m_7731_(position, this.transform(Blocks.f_50493_), 2);
                }
            }
        });
    }

    private void generateTreasurePile(WorldGenLevel level, RandomSource random, BlockPos origin) {
        int layers = random.m_188503_(3);
        for (int i = 0; i < layers; ++i) {
            int radius = layers - i;
            double circularArea = this.getCircularArea(radius);
            for (BlockPos position : BlockPos.m_121990_((BlockPos)origin.m_7918_(-radius, i, -radius), (BlockPos)origin.m_7918_(radius, i, radius)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                if (!(position.m_123331_((Vec3i)origin) <= circularArea)) continue;
                position = level.m_5452_(Heightmap.Types.WORLD_SURFACE, position);
                if (!(this.treasureBlock instanceof BlockGoldPile)) continue;
                BlockState state = level.m_8055_(position);
                boolean placed = false;
                if (state.m_60795_()) {
                    level.m_7731_(position, (BlockState)this.treasureBlock.m_49966_().m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + random.m_188503_(7))), 2);
                    placed = true;
                } else if (state.m_60734_() instanceof SnowLayerBlock) {
                    level.m_7731_(position.m_7495_(), (BlockState)this.treasureBlock.m_49966_().m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)((Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_))), 2);
                    placed = true;
                }
                if (!placed || !(level.m_8055_(position.m_7495_()).m_60734_() instanceof BlockGoldPile)) continue;
                level.m_7731_(position.m_7495_(), (BlockState)this.treasureBlock.m_49966_().m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(8)), 2);
            }
        }
    }

    private void spawnDragon(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> context, int ageOffset, boolean isMale) {
        EntityDragonBase dragon = (EntityDragonBase)this.getDragonType().m_20615_((Level)context.m_159774_().m_6018_());
        dragon.setGender(isMale);
        dragon.growDragon(40 + ageOffset);
        dragon.setAgingDisabled(true);
        dragon.m_21153_(dragon.m_21233_());
        dragon.setVariant(new Random().nextInt(4));
        dragon.m_19890_((double)context.m_159777_().m_123341_() + 0.5, (double)context.m_159774_().m_5452_(Heightmap.Types.WORLD_SURFACE_WG, context.m_159777_()).m_123342_() + 1.5, (double)context.m_159777_().m_123343_() + 0.5, context.m_225041_().m_188501_() * 360.0f, 0.0f);
        dragon.homePos = new HomePosition(context.m_159777_(), (Level)context.m_159774_().m_6018_());
        dragon.hasHomePosition = true;
        dragon.setHunger(50);
        context.m_159774_().m_7967_((Entity)dragon);
    }

    protected abstract EntityType<? extends EntityDragonBase> getDragonType();

    protected abstract ResourceLocation getRoostLootTable();

    protected abstract BlockState transform(BlockState var1);

    protected abstract void handleCustomGeneration(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> var1, BlockPos var2, double var3);
}

