/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsarmor.armor;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public enum LrArmorMaterial implements ArmorMaterial
{
    DEFAULT("dea", 50, new int[]{1, 2, 3, 1}, 15, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42454_}));

    private static final Map<String, LrArmorMaterial> byName;
    private static final int[] HEALTH_PER_SLOT;
    private final String name;
    private final int durabilityMultiplier;
    private final int[] slotProtections;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairIngredient;

    public static LrArmorMaterial getByName(String name) {
        return byName.get(name);
    }

    private LrArmorMaterial(String name, int durabilityMultiplier, int[] slotProtections, int enchantmentValue, SoundEvent equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredientSupplier) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.slotProtections = slotProtections;
        this.enchantmentValue = enchantmentValue;
        this.sound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = new LazyLoadedValue(repairIngredientSupplier);
    }

    public int m_266425_(ArmorItem.Type type) {
        return HEALTH_PER_SLOT[type.ordinal()] * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.slotProtections[type.ordinal()];
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    @NotNull
    public SoundEvent m_7344_() {
        return this.sound;
    }

    @NotNull
    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.m_13971_();
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        byName = new HashMap<String, LrArmorMaterial>();
        for (LrArmorMaterial material : LrArmorMaterial.values()) {
            byName.put(material.name, material);
        }
        HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
    }
}

