/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lesraisinsarmor.resource.data;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;

public class ArmorPartData {
    private ImmutableMultimap<Attribute, AttributeModifier> attributes;
    private Ingredient repairIngredient;
    private SoundEvent equipSound;
    private int enchantmentValue;
    private int maxDurability;
    private int defense = 0;
    private int toughness = 0;
    private int knockbackResistance = 0;

    public Multimap<Attribute, AttributeModifier> getAttributes() {
        return this.attributes;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient;
    }

    public SoundEvent getEquipSound() {
        return this.equipSound;
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    public int getMaxDurability() {
        return this.maxDurability;
    }

    public int getDefense() {
        return this.defense;
    }

    public int getToughness() {
        return this.toughness;
    }

    public int getKnockbackResistance() {
        return this.knockbackResistance;
    }

    public static ArmorPartData fromJson(UUID uuid, Struct rawData) {
        ArmorPartData data = new ArmorPartData();
        ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)rawData.defense, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)rawData.toughness, AttributeModifier.Operation.ADDITION));
        if (rawData.knockbackResistance > 0) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)rawData.knockbackResistance, AttributeModifier.Operation.ADDITION));
        }
        data.attributes = builder.build();
        try {
            data.repairIngredient = CraftingHelper.getIngredient((JsonElement)rawData.repairIngredient, (boolean)true);
        }
        catch (JsonParseException jsonParseException) {
            // empty catch block
        }
        data.equipSound = SoundEvent.m_262824_((ResourceLocation)rawData.sound);
        data.enchantmentValue = rawData.enchantmentValue;
        data.maxDurability = rawData.maxDurability;
        data.defense = rawData.defense;
        data.toughness = rawData.toughness;
        data.knockbackResistance = rawData.knockbackResistance;
        return data;
    }

    public static class Struct {
        private int defense = 0;
        private int toughness = 0;
        private int knockbackResistance = 0;
        private int enchantmentValue = 5;
        private int maxDurability = 128;
        private ResourceLocation sound = new ResourceLocation("item.armor.equip_leather");
        private JsonElement repairIngredient = null;
    }
}

