/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.tacz.guns.api.item.IAnimationItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import me.xjqsh.lrtactical.api.collision.ITargetFilter;
import me.xjqsh.lrtactical.api.item.IMeleeWeapon;
import me.xjqsh.lrtactical.api.melee.AttackResult;
import me.xjqsh.lrtactical.api.melee.MeleeAction;
import me.xjqsh.lrtactical.client.renderer.item.MeleeItemRenderer;
import me.xjqsh.lrtactical.config.CommonConfig;
import me.xjqsh.lrtactical.item.index.MeleeWeaponIndex;
import me.xjqsh.lrtactical.item.melee.CombatData;
import me.xjqsh.lrtactical.item.melee.MeleeWeaponData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;

public class MeleeItem
extends Item
implements IAnimationItem,
IMeleeWeapon {
    public MeleeItem() {
        super(new Item.Properties().m_41487_(1).setNoRepair());
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            return this.getMeleeIndex(stack).map(MeleeWeaponIndex::getDefaultModifiers).orElse((Multimap)ImmutableMultimap.of());
        }
        return ImmutableMultimap.of();
    }

    @Override
    public boolean isSame(ItemStack stack1, ItemStack stack2) {
        return IMeleeWeapon.super.isSame(stack1, stack2);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private MeleeItemRenderer renderer = null;

            public MeleeItemRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new MeleeItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public boolean m_8120_(@NotNull ItemStack pStack) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 5;
    }

    @NotNull
    public String m_5671_(@NotNull ItemStack stack) {
        return this.getMeleeIndex(stack).map(MeleeWeaponIndex::getDescriptionId).orElse(super.m_5671_(stack));
    }

    public Optional<TooltipComponent> m_142422_(ItemStack pStack) {
        return super.m_142422_(pStack);
    }

    @Override
    public int getAttackCoolDown(ItemStack stack, MeleeAction action) {
        return this.getMeleeIndex(stack).map(index -> ((MeleeWeaponData)index.getData()).getAttackInfo()).map(attackInfos -> attackInfos.getAttackInfo(action)).map(CombatData.MeleeAttackInfo::getCooldown).orElse(0);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getMeleeIndex(stack).map(MeleeWeaponIndex::getMaxDurability).orElse(0);
    }

    public boolean isDamageable(ItemStack stack) {
        return this.getMaxDamage(stack) > 0;
    }

    @Override
    public int getDrawTime(ItemStack stack) {
        return this.getMeleeIndex(stack).map(index -> ((MeleeWeaponData)index.getData()).getDrawTime()).orElse(0);
    }

    @Override
    public int getPutAwayTime(ItemStack stack) {
        return this.getMeleeIndex(stack).map(index -> ((MeleeWeaponData)index.getData()).getPutAwayTime()).orElse(0);
    }

    @Override
    public int getAttackDelay(Player attacker, ItemStack stack, MeleeAction action) {
        return this.getMeleeIndex(stack).map(index -> ((MeleeWeaponData)index.getData()).getAttackInfo()).map(attackInfos -> attackInfos.getAttackInfo(action)).map(CombatData.MeleeAttackInfo::getDelay).orElse(0);
    }

    @Override
    public CombatData.MeleeMovement getAttackMovement(Player entity, ItemStack stack, MeleeAction action) {
        return this.getMeleeIndex(stack).map(index -> ((MeleeWeaponData)index.getData()).getAttackInfo()).map(attackInfos -> attackInfos.getAttackInfo(action)).map(CombatData.MeleeAttackInfo::getMovement).orElse(null);
    }

    @Override
    public List<Entity> collectTargets(Player attacker, ItemStack stack, MeleeAction action, Vec3 origin, Vec3 direction) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        this.getMeleeIndex(stack).ifPresent(index -> {
            CombatData combatData = ((MeleeWeaponData)index.getData()).getAttackInfo();
            if (combatData == null) {
                return;
            }
            CombatData.MeleeAttackInfo attackInfo = combatData.getAttackInfo(action);
            if (attackInfo == null) {
                return;
            }
            ITargetFilter filter = attackInfo.getHitbox();
            entities.addAll(filter.filterTargets((LivingEntity)attacker, origin, direction));
        });
        return entities;
    }

    @Override
    public void attack(Player attacker, ItemStack stack, MeleeAction action, List<Entity> targets) {
        float base = (float)attacker.m_21133_(Attributes.f_22281_);
        this.getMeleeIndex(stack).ifPresent(index -> {
            CombatData combatData = ((MeleeWeaponData)index.getData()).getAttackInfo();
            if (combatData == null) {
                return;
            }
            CombatData.MeleeAttackInfo attackInfo = combatData.getAttackInfo(action);
            if (attackInfo == null) {
                return;
            }
            ITargetFilter filter = attackInfo.getHitbox();
            IMeleeWeapon.playMeleeSound(attacker, index.getId(), action.getId(), 2.0f, 1.0f, true);
            float damage = base * attackInfo.getFactor();
            float knockback = attackInfo.getKnockback();
            if (damage <= 0.0f) {
                return;
            }
            boolean hit = false;
            boolean crit = false;
            for (Entity livingentity : targets) {
                boolean inRange;
                ArmorStand armorStand;
                boolean flag = !(livingentity instanceof ArmorStand) || !(armorStand = (ArmorStand)livingentity).m_31677_();
                boolean bl = inRange = livingentity.m_20280_((Entity)attacker) <= filter.getMaxRange() * filter.getMaxRange();
                if (livingentity == attacker || !flag || !inRange) continue;
                AttackResult result = this.performAttack(attacker, livingentity, stack, damage, knockback);
                hit |= result.hit();
                crit |= result.crit();
            }
            if (hit) {
                if (((Boolean)CommonConfig.MELEE_ITEM_CONSUME_DURABILITY.get()).booleanValue()) {
                    stack.m_41622_(attackInfo.getDurabilityDamage(), (LivingEntity)attacker, player -> player.m_21166_(EquipmentSlot.MAINHAND));
                }
                IMeleeWeapon.playMeleeSound(attacker, index.getId(), (String)(crit ? "crit" : action.getId() + "_hit"), 2.0f, 1.0f);
            }
        });
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ == EnchantmentCategory.WEAPON;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction == ToolActions.SWORD_SWEEP;
    }
}

