/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.item.throwable.area;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import me.xjqsh.lrtactical.item.throwable.ThrowableData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class EffectCloudThrowableData
extends ThrowableData {
    @SerializedName(value="cloud")
    private CloudData explode = new CloudData();

    @NotNull
    public CloudData getCloudData() {
        return this.explode;
    }

    public static class CloudData {
        @SerializedName(value="area_cloud")
        private boolean areaCloud = true;
        @SerializedName(value="radius")
        private float radius = 5.5f;
        @SerializedName(value="radius_per_tick")
        private float radiusPerTick = 0.01f;
        @SerializedName(value="wait_time")
        private int waitTime = 20;
        @SerializedName(value="duration")
        private int duration = 200;
        @SerializedName(value="particles")
        private ParticleOptions particles = ParticleTypes.f_123806_;
        @SerializedName(value="ignite")
        private boolean ignite = false;
        @SerializedName(value="ignite_time")
        private int igniteTime = 2;
        @SerializedName(value="extinguish_by_smoke")
        private boolean extinguishBySmoke = false;
        @SerializedName(value="effects")
        private List<EffectData> effects = Lists.newArrayList();

        public CloudData() {
        }

        public CloudData(boolean areaCloud, float radius, float radiusPerTick, int waitTime, int duration, ParticleOptions particles, boolean ignite, int igniteTime, boolean extinguishBySmoke, List<EffectData> effects) {
            this.areaCloud = areaCloud;
            this.radius = radius;
            this.radiusPerTick = radiusPerTick;
            this.waitTime = waitTime;
            this.duration = duration;
            this.particles = particles;
            this.ignite = ignite;
            this.igniteTime = igniteTime;
            this.extinguishBySmoke = extinguishBySmoke;
            this.effects = effects;
        }

        public boolean isAreaCloud() {
            return this.areaCloud;
        }

        public float getRadius() {
            return this.radius;
        }

        public float getRadiusPerTick() {
            return this.radiusPerTick;
        }

        public int getWaitTime() {
            return this.waitTime;
        }

        public int getDuration() {
            return this.duration;
        }

        public ParticleOptions getParticles() {
            return this.particles;
        }

        public boolean isIgnite() {
            return this.ignite;
        }

        public int getIgniteTime() {
            return this.igniteTime;
        }

        public boolean isExtinguishBySmoke() {
            return this.extinguishBySmoke;
        }

        public List<EffectData> getEffects() {
            return this.effects;
        }

        public List<MobEffectInstance> getEffectInstances() {
            ArrayList instances = Lists.newArrayList();
            for (EffectData effect : this.effects) {
                instances.add(effect.toInstance());
            }
            return instances;
        }
    }

    public static class EffectDataDeSerializer
    implements JsonDeserializer<EffectData> {
        public EffectData deserialize(JsonElement ele, Type type, JsonDeserializationContext ctx) throws JsonParseException {
            if (ele.isJsonObject()) {
                JsonObject obj = ele.getAsJsonObject();
                ResourceLocation id = (ResourceLocation)ctx.deserialize(obj.get("type"), ResourceLocation.class);
                MobEffect type1 = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(id);
                if (type1 == null) {
                    throw new JsonParseException("Unknown effect type: " + id);
                }
                int duration = GsonHelper.m_13824_((JsonObject)obj, (String)"duration", (int)200);
                if (duration < 0) {
                    throw new JsonParseException("Duration must be non-negative: " + duration);
                }
                int amplifier = GsonHelper.m_13824_((JsonObject)obj, (String)"amplifier", (int)0);
                if (amplifier < 0) {
                    throw new JsonParseException("Amplifier must be non-negative: " + amplifier);
                }
                boolean visible = GsonHelper.m_13855_((JsonObject)obj, (String)"visible", (boolean)true);
                boolean showIcon = GsonHelper.m_13855_((JsonObject)obj, (String)"show_icon", (boolean)true);
                return new EffectData(type1, duration, amplifier, visible, showIcon);
            }
            throw new JsonParseException("Invalid EffectData JSON: " + ele);
        }
    }

    public record EffectData(MobEffect type, int duration, int amplifier, boolean visible, boolean showIcon) {
        public MobEffectInstance toInstance() {
            return new MobEffectInstance(this.type, this.duration, this.amplifier, false, this.visible, this.showIcon);
        }
    }
}

