/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.network.message;

import java.util.function.Supplier;
import me.xjqsh.lrtactical.api.melee.MeleeAction;
import me.xjqsh.lrtactical.capability.CombatPropertiesProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public record CPrepareMeleeAttack(MeleeAction action, Vec3 origin, Vec3 direction) {
    public static void encode(CPrepareMeleeAttack message, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)message.action);
        buf.writeDouble(message.origin.f_82479_);
        buf.writeDouble(message.origin.f_82480_);
        buf.writeDouble(message.origin.f_82481_);
        buf.writeDouble(message.direction.f_82479_);
        buf.writeDouble(message.direction.f_82480_);
        buf.writeDouble(message.direction.f_82481_);
    }

    public static CPrepareMeleeAttack decode(FriendlyByteBuf buf) {
        return new CPrepareMeleeAttack((MeleeAction)buf.m_130066_(MeleeAction.class), new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()));
    }

    public static void handle(CPrepareMeleeAttack message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                if (player == null) {
                    return;
                }
                player.getCapability(CombatPropertiesProvider.CAPABILITY).ifPresent(cap -> cap.preAttack(message.action, message.origin, message.direction));
            });
        }
        context.setPacketHandled(true);
    }
}

