/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.api.registry;

import com.legacy.lucent.api.data.objects.EmissiveBlockTexture;
import com.legacy.lucent.core.LucentConfig;
import com.legacy.lucent.core.LucentMod;
import com.legacy.lucent.core.LucentRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlockTextureLightingRegistry {
    private static final Map<ResourceLocation, Integer> REGISTRY = new HashMap<ResourceLocation, Integer>();

    public void register(EmissiveBlockTexture emissiveTexture) {
        ResourceLocation texture = emissiveTexture.texture();
        int light = emissiveTexture.light();
        if (light <= -1) {
            this.remove(texture);
        } else {
            REGISTRY.put(texture, light);
            if (((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
                LucentMod.LOGGER.info("  [" + LucentRegistry.sourceName + "] -> [" + texture + "] set to " + light, new Object[0]);
            }
        }
    }

    public void register(ResourceLocation texture, int lightLevel) {
        this.register(new EmissiveBlockTexture(texture, lightLevel));
    }

    public void register(String texture, int lightLevel) {
        if (ResourceLocation.m_135830_((String)texture)) {
            this.register(new ResourceLocation(texture), lightLevel);
        } else {
            LucentRegistry.logInvalidResourceLocation(texture);
        }
    }

    public void remove(ResourceLocation texture) {
        if (REGISTRY.remove(texture) != null && ((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
            LucentMod.LOGGER.info("  [" + LucentRegistry.sourceName + "] -> Removed [" + texture + "]", new Object[0]);
        }
    }

    public static int get(ResourceLocation texture) {
        Integer light = REGISTRY.get(texture);
        return light != null ? light : 0;
    }

    @Deprecated
    public static void clear() {
        REGISTRY.clear();
    }
}

