/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class PluginManager<P extends IBasePlugin>
implements Iterable<P> {
    private List<P> plugins = Collections.emptyList();
    private final Class<P> pluginClass;
    private final Class<?> annotationClass;
    private final Supplier<Logger> loggerGetter;
    private final Supplier<String> modIDGetter;

    public PluginManager(Class<P> pluginClass, Class<?> annotationClass, Supplier<Logger> logger, Supplier<String> modID) {
        this.pluginClass = pluginClass;
        this.annotationClass = annotationClass;
        this.loggerGetter = logger;
        this.modIDGetter = modID;
        try {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.HIGHEST, this::loadPlugins);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<P> get() {
        return this.plugins;
    }

    public boolean post(Predicate<P> predicate) {
        return this.plugins.stream().anyMatch(predicate);
    }

    @Override
    public Iterator<P> iterator() {
        return this.plugins.iterator();
    }

    public void loadPlugins(FMLCommonSetupEvent event) {
        Logger logger = this.loggerGetter.get();
        String modID = this.modIDGetter.get();
        Type modPlugin = Type.getType(this.annotationClass);
        List pluginClassNames = ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> modPlugin.equals((Object)a.annotationType())).map(ModFileScanData.AnnotationData::memberName).collect(Collectors.toList());
        ArrayList<IBasePlugin> plugins = new ArrayList<IBasePlugin>();
        for (String className : pluginClassNames) {
            try {
                Class<?> clazz = Class.forName(className);
                for (Class<?> i : clazz.getInterfaces()) {
                    if (!i.equals(this.pluginClass)) continue;
                    try {
                        IBasePlugin pluginInstance = (IBasePlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        if (!ModList.get().isLoaded(pluginInstance.ownerModID())) continue;
                        List<String> requiredMods = pluginInstance.requiredMods();
                        if (!requiredMods.isEmpty()) {
                            if (!requiredMods.stream().allMatch(arg_0 -> ((ModList)ModList.get()).isLoaded(arg_0))) continue;
                        }
                        if (!pluginInstance.isEnabled()) continue;
                        plugins.add(pluginInstance);
                        logger.info("[{}] Found and created plugin: {}", (Object)modID, (Object)className);
                    }
                    catch (Exception e) {
                        logger.error("[{}] Failed to find or create plugin: {} {}", (Object)modID, (Object)className, (Object)e);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                logger.error("[{}] Failed to locate class plugin: {} {}", (Object)modID, (Object)className, (Object)e);
            }
        }
        plugins.sort(this::compare);
        this.plugins = List.copyOf(plugins);
    }

    protected int compare(P pluginA, P pluginB) {
        int b;
        int a = pluginA.getPriority();
        return a == (b = pluginB.getPriority()) ? 0 : (a > b ? -1 : 1);
    }

    public String getPluginName(IBasePlugin plugin) {
        Object s = plugin.getClass().getSimpleName();
        if (plugin.isInternal()) {
            s = (String)s + " - Internal";
        }
        return s;
    }

    public static interface IBasePlugin {
        public String ownerModID();

        @Nullable
        default public List<String> requiredMods() {
            return Collections.emptyList();
        }

        default public int getPriority() {
            return this.isInternal() ? 1 : 0;
        }

        default public ResourceLocation locate(String path) throws NullPointerException {
            String ownerID = this.ownerModID();
            if (ownerID == null) {
                throw new NullPointerException(String.format("The owner mod ID is null for %s", this.getClass().getCanonicalName()));
            }
            return new ResourceLocation(ownerID, path);
        }

        default public boolean isEnabled() {
            return true;
        }

        @Deprecated
        default public boolean isInternal() {
            return false;
        }
    }
}

