/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.core.mixin;

import com.legacy.lucent.core.dynamic_lighting.DynamicLightingEngine;
import com.legacy.lucent.core.dynamic_lighting.LightData;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Inject(at={@At(value="RETURN")}, method={"getLightColor(Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)I"}, cancellable=true)
    private static void modifyBlockLight(BlockAndTintGetter level, BlockState state, BlockPos pos, CallbackInfoReturnable<Integer> callback) {
        int light;
        LightData lightData = DynamicLightingEngine.getLightSource(pos);
        if (lightData != null && (light = DynamicLightingEngine.calcLight(level, state, pos, lightData)) > (Integer)callback.getReturnValue()) {
            callback.setReturnValue((Object)light);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"allChanged()V"})
    private void onRenderAll(CallbackInfo callback) {
        DynamicLightingEngine.clearAllData();
    }
}

