/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.generator_extras.common.content.reactor;

import com.jerry.generator_extras.common.content.reactor.NaquadahReactorMultiblockData;
import com.jerry.generator_extras.common.genregistry.ExtraGenBlockTypes;
import com.jerry.generator_extras.common.tile.reactor.TileEntityNaquadahReactorController;
import java.util.EnumSet;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.lib.multiblock.StructureHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class NaquadahReactorValidator
extends CuboidStructureValidator<NaquadahReactorMultiblockData> {
    private static final VoxelCuboid BOUNDS = new VoxelCuboid(9, 9, 9);
    private static final byte[][] ALLOWED_GRID = new byte[][]{{0, 0, 0, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 2, 2, 2, 1, 1, 0}, {0, 1, 2, 2, 2, 2, 2, 1, 0}, {1, 2, 2, 2, 2, 2, 2, 2, 1}, {1, 2, 2, 2, 2, 2, 2, 2, 1}, {1, 2, 2, 2, 2, 2, 2, 2, 1}, {0, 1, 2, 2, 2, 2, 2, 1, 0}, {0, 1, 1, 2, 2, 2, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 0, 0, 0}};

    protected FormationProtocol.StructureRequirement getStructureRequirement(BlockPos pos) {
        VoxelCuboid.WallRelative relative = this.cuboid.getWallRelative(pos);
        if (relative.isWall()) {
            Structure.Axis axis = Structure.Axis.get((Direction)this.cuboid.getSide(pos));
            Structure.Axis h = axis.horizontal();
            Structure.Axis v = axis.vertical();
            pos = pos.m_121996_((Vec3i)this.cuboid.getMinPos());
            return FormationProtocol.StructureRequirement.REQUIREMENTS[ALLOWED_GRID[h.getCoord(pos)][v.getCoord(pos)]];
        }
        return super.getStructureRequirement(pos);
    }

    protected FormationProtocol.FormationResult validateFrame(FormationProtocol<NaquadahReactorMultiblockData> ctx, BlockPos pos, BlockState state, FormationProtocol.CasingType type, boolean needsFrame) {
        boolean isControllerPos = pos.m_123342_() == this.cuboid.getMaxPos().m_123342_() && pos.m_123341_() == this.cuboid.getMinPos().m_123341_() + 4 && pos.m_123343_() == this.cuboid.getMinPos().m_123343_() + 4;
        boolean controller = this.structure.getTile(pos) instanceof TileEntityNaquadahReactorController;
        if (isControllerPos && !controller) {
            return FormationProtocol.FormationResult.fail((ILangEntry)MekanismLang.MULTIBLOCK_INVALID_NO_CONTROLLER);
        }
        if (!isControllerPos && controller) {
            return FormationProtocol.FormationResult.fail((ILangEntry)MekanismLang.MULTIBLOCK_INVALID_CONTROLLER_CONFLICT, (boolean)true);
        }
        return super.validateFrame(ctx, pos, state, type, needsFrame);
    }

    protected FormationProtocol.CasingType getCasingType(BlockState state) {
        Block block = state.m_60734_();
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{ExtraGenBlockTypes.NAQUADAH_REACTOR_CASING})) {
            return FormationProtocol.CasingType.FRAME;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{ExtraGenBlockTypes.NAQUADAH_REACTOR_PORT})) {
            return FormationProtocol.CasingType.VALVE;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{ExtraGenBlockTypes.NAQUADAH_REACTOR_CONTROLLER, ExtraGenBlockTypes.NAQUADAH_REACTOR_LOGIC_ADAPTER, ExtraGenBlockTypes.LEAD_COATED_LASER_FOCUS_MATRIX})) {
            return FormationProtocol.CasingType.OTHER;
        }
        return FormationProtocol.CasingType.INVALID;
    }

    public boolean precheck() {
        this.cuboid = StructureHelper.fetchCuboid((Structure)this.structure, (VoxelCuboid)BOUNDS, (VoxelCuboid)BOUNDS, EnumSet.allOf(VoxelCuboid.CuboidSide.class), (int)120);
        return this.cuboid != null;
    }
}

