/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.client.events;

import com.google.common.collect.Table;
import com.jerry.mekanism_extras.client.gui.ExtraGuiChemicalTank;
import com.jerry.mekanism_extras.client.gui.ExtraGuiEnergyCube;
import com.jerry.mekanism_extras.client.gui.ExtraGuiFluidTank;
import com.jerry.mekanism_extras.client.gui.GuiReinforcedInductionMatrix;
import com.jerry.mekanism_extras.client.gui.GuiReinforcedMatrixStats;
import com.jerry.mekanism_extras.client.gui.machine.GuiAdvancedElectricPump;
import com.jerry.mekanism_extras.client.gui.machine.GuiAdvancedFactory;
import com.jerry.mekanism_extras.client.model.ExtraModelEnergyCore;
import com.jerry.mekanism_extras.client.model.energycube.ExtraEnergyCubeModelLoader;
import com.jerry.mekanism_extras.client.render.item.block.ExtraRenderEnergyCubeItem;
import com.jerry.mekanism_extras.client.render.tileentity.ExtraRenderBin;
import com.jerry.mekanism_extras.client.render.tileentity.ExtraRenderEnergyCube;
import com.jerry.mekanism_extras.client.render.tileentity.ExtraRenderFluidTank;
import com.jerry.mekanism_extras.client.render.transmitter.ExtraRenderLogisticalTransporter;
import com.jerry.mekanism_extras.client.render.transmitter.ExtraRenderMechanicalPipe;
import com.jerry.mekanism_extras.client.render.transmitter.ExtraRenderPressurizedTube;
import com.jerry.mekanism_extras.client.render.transmitter.ExtraRenderThermodynamicConductor;
import com.jerry.mekanism_extras.client.render.transmitter.ExtraRenderUniversalCable;
import com.jerry.mekanism_extras.common.block.attribute.ExtraAttribute;
import com.jerry.mekanism_extras.common.item.block.ExtraItemBlockEnergyCube;
import com.jerry.mekanism_extras.common.item.block.machine.ExtraItemBlockFluidTank;
import com.jerry.mekanism_extras.common.registry.ExtraBlock;
import com.jerry.mekanism_extras.common.registry.ExtraContainerTypes;
import com.jerry.mekanism_extras.common.registry.ExtraFluids;
import com.jerry.mekanism_extras.common.registry.ExtraTileEntityTypes;
import com.jerry.mekanism_extras.common.tier.ECTier;
import com.jerry.mekanism_extras.common.tier.FTTier;
import com.jerry.mekanism_extras.common.tier.TierColor;
import com.jerry.mekanism_extras.common.tile.transmitter.ExtraTileEntityLogisticalTransporter;
import java.util.Map;
import mekanism.api.SupportsColorMap;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.providers.IItemProvider;
import mekanism.api.text.EnumColor;
import mekanism.client.ClientRegistrationUtil;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.item.TransmitterTypeDecorator;
import mekanism.common.registration.impl.FluidDeferredRegister;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismItems;
import mekanism.common.resource.PrimaryResource;
import mekanism.common.util.WorldUtils;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterItemDecorationsEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(modid="mekanism_extras", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientRegistration {
    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ClientRegistrationUtil.bindTileEntityRenderer((EntityRenderersEvent.RegisterRenderers)event, ExtraRenderUniversalCable::new, (TileEntityTypeRegistryObject[])new TileEntityTypeRegistryObject[]{ExtraTileEntityTypes.ABSOLUTE_UNIVERSAL_CABLE, ExtraTileEntityTypes.SUPREME_UNIVERSAL_CABLE, ExtraTileEntityTypes.COSMIC_UNIVERSAL_CABLE, ExtraTileEntityTypes.INFINITE_UNIVERSAL_CABLE});
        ClientRegistrationUtil.bindTileEntityRenderer((EntityRenderersEvent.RegisterRenderers)event, ExtraRenderLogisticalTransporter::new, (TileEntityTypeRegistryObject[])new TileEntityTypeRegistryObject[]{ExtraTileEntityTypes.ABSOLUTE_LOGISTICAL_TRANSPORTER, ExtraTileEntityTypes.SUPREME_LOGISTICAL_TRANSPORTER, ExtraTileEntityTypes.COSMIC_LOGISTICAL_TRANSPORTER, ExtraTileEntityTypes.INFINITE_LOGISTICAL_TRANSPORTER});
        ClientRegistrationUtil.bindTileEntityRenderer((EntityRenderersEvent.RegisterRenderers)event, ExtraRenderMechanicalPipe::new, (TileEntityTypeRegistryObject[])new TileEntityTypeRegistryObject[]{ExtraTileEntityTypes.ABSOLUTE_MECHANICAL_PIPE, ExtraTileEntityTypes.SUPREME_MECHANICAL_PIPE, ExtraTileEntityTypes.COSMIC_MECHANICAL_PIPE, ExtraTileEntityTypes.INFINITE_MECHANICAL_PIPE});
        ClientRegistrationUtil.bindTileEntityRenderer((EntityRenderersEvent.RegisterRenderers)event, ExtraRenderPressurizedTube::new, (TileEntityTypeRegistryObject[])new TileEntityTypeRegistryObject[]{ExtraTileEntityTypes.ABSOLUTE_PRESSURIZED_TUBE, ExtraTileEntityTypes.SUPREME_PRESSURIZED_TUBE, ExtraTileEntityTypes.COSMIC_PRESSURIZED_TUBE, ExtraTileEntityTypes.INFINITE_PRESSURIZED_TUBE});
        ClientRegistrationUtil.bindTileEntityRenderer((EntityRenderersEvent.RegisterRenderers)event, ExtraRenderThermodynamicConductor::new, (TileEntityTypeRegistryObject[])new TileEntityTypeRegistryObject[]{ExtraTileEntityTypes.ABSOLUTE_THERMODYNAMIC_CONDUCTOR, ExtraTileEntityTypes.SUPREME_THERMODYNAMIC_CONDUCTOR, ExtraTileEntityTypes.COSMIC_THERMODYNAMIC_CONDUCTOR, ExtraTileEntityTypes.INFINITE_THERMODYNAMIC_CONDUCTOR});
        ClientRegistrationUtil.bindTileEntityRenderer((EntityRenderersEvent.RegisterRenderers)event, ExtraRenderBin::new, (TileEntityTypeRegistryObject[])new TileEntityTypeRegistryObject[]{ExtraTileEntityTypes.ABSOLUTE_BIN, ExtraTileEntityTypes.SUPREME_BIN, ExtraTileEntityTypes.COSMIC_BIN, ExtraTileEntityTypes.INFINITE_BIN});
        ClientRegistrationUtil.bindTileEntityRenderer((EntityRenderersEvent.RegisterRenderers)event, ExtraRenderFluidTank::new, (TileEntityTypeRegistryObject[])new TileEntityTypeRegistryObject[]{ExtraTileEntityTypes.ABSOLUTE_FLUID_TANK, ExtraTileEntityTypes.SUPREME_FLUID_TANK, ExtraTileEntityTypes.COSMIC_FLUID_TANK, ExtraTileEntityTypes.INFINITE_FLUID_TANK});
        ClientRegistrationUtil.bindTileEntityRenderer((EntityRenderersEvent.RegisterRenderers)event, ExtraRenderEnergyCube::new, (TileEntityTypeRegistryObject[])new TileEntityTypeRegistryObject[]{ExtraTileEntityTypes.ABSOLUTE_ENERGY_CUBE, ExtraTileEntityTypes.SUPREME_ENERGY_CUBE, ExtraTileEntityTypes.COSMIC_ENERGY_CUBE, ExtraTileEntityTypes.INFINITE_ENERGY_CUBE});
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Post event) {
        TextureAtlas map = event.getAtlas();
        ExtraRenderLogisticalTransporter.onStitch(map);
        ExtraRenderFluidTank.resetCachedModels();
        ExtraRenderMechanicalPipe.onStitch();
    }

    @SubscribeEvent
    public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
        ClientRegistrationUtil.registerClientReloadListeners((RegisterClientReloadListenersEvent)event, (PreparableReloadListener[])new PreparableReloadListener[]{ExtraRenderEnergyCubeItem.EXTRA_RENDERER});
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerContainers(RegisterEvent event) {
        event.register(Registries.f_256798_, helper -> {
            ClientRegistrationUtil.registerScreen(ExtraContainerTypes.FLUID_TANK, ExtraGuiFluidTank::new);
            ClientRegistrationUtil.registerScreen(ExtraContainerTypes.ENERGY_CUBE, ExtraGuiEnergyCube::new);
            ClientRegistrationUtil.registerScreen(ExtraContainerTypes.CHEMICAL_TANK, ExtraGuiChemicalTank::new);
            ClientRegistrationUtil.registerScreen(ExtraContainerTypes.ADVANCED_ELECTRIC_PUMP, GuiAdvancedElectricPump::new);
            ClientRegistrationUtil.registerScreen(ExtraContainerTypes.REINFORCED_INDUCTION_MATRIX, GuiReinforcedInductionMatrix::new);
            ClientRegistrationUtil.registerScreen(ExtraContainerTypes.MATRIX_STATS, GuiReinforcedMatrixStats::new);
            ClientRegistrationUtil.registerScreen(ExtraContainerTypes.FACTORY, GuiAdvancedFactory::new);
        });
    }

    @SubscribeEvent
    public static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("energy_cube", (IGeometryLoader)ExtraEnergyCubeModelLoader.INSTANCE);
    }

    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ExtraModelEnergyCore.CORE_LAYER, ExtraModelEnergyCore::createLayerDefinition);
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        ClientRegistrationUtil.registerBlockColorHandler((RegisterColorHandlersEvent.Block)event, (state, world, pos, tintIndex) -> {
            FTTier tier;
            if (tintIndex == 1 && (tier = ExtraAttribute.getTier(state.m_60734_(), FTTier.class)) != null) {
                float[] color = TierColor.getColor(tier);
                return MekanismRenderer.getColorARGB((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
            }
            return -1;
        }, (IBlockProvider[])new IBlockProvider[]{ExtraBlock.ABSOLUTE_FLUID_TANK, ExtraBlock.SUPREME_FLUID_TANK, ExtraBlock.COSMIC_FLUID_TANK, ExtraBlock.INFINITE_FLUID_TANK});
        ClientRegistrationUtil.registerBlockColorHandler((RegisterColorHandlersEvent.Block)event, (state, world, pos, index) -> {
            ECTier tier;
            if (index == 1 && (tier = ExtraAttribute.getTier(state.m_60734_(), ECTier.class)) != null) {
                float[] color = TierColor.getColor(tier);
                return MekanismRenderer.getColorARGB((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
            }
            return -1;
        }, (IBlockProvider[])new IBlockProvider[]{ExtraBlock.ABSOLUTE_ENERGY_CUBE, ExtraBlock.SUPREME_ENERGY_CUBE, ExtraBlock.COSMIC_ENERGY_CUBE, ExtraBlock.INFINITE_ENERGY_CUBE});
        ClientRegistrationUtil.registerBlockColorHandler((RegisterColorHandlersEvent.Block)event, (state, world, pos, tintIndex) -> {
            EnumColor renderColor;
            ExtraTileEntityLogisticalTransporter transporter;
            if (tintIndex == 1 && pos != null && (transporter = (ExtraTileEntityLogisticalTransporter)WorldUtils.getTileEntity(ExtraTileEntityLogisticalTransporter.class, (BlockGetter)world, (BlockPos)pos)) != null && (renderColor = transporter.getTransmitter().getColor()) != null) {
                return MekanismRenderer.getColorARGB((SupportsColorMap)renderColor, (float)1.0f);
            }
            return -1;
        }, (IBlockProvider[])new IBlockProvider[]{ExtraBlock.ABSOLUTE_LOGISTICAL_TRANSPORTER, ExtraBlock.SUPREME_LOGISTICAL_TRANSPORTER, ExtraBlock.COSMIC_LOGISTICAL_TRANSPORTER, ExtraBlock.INFINITE_LOGISTICAL_TRANSPORTER});
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        ClientRegistrationUtil.registerBucketColorHandler((RegisterColorHandlersEvent.Item)event, (FluidDeferredRegister)ExtraFluids.EXTRA_FLUIDS);
        ClientRegistrationUtil.registerItemColorHandler((RegisterColorHandlersEvent.Item)event, (stack, tintIndex) -> {
            Item item = stack.m_41720_();
            if (tintIndex == 1 && item instanceof ExtraItemBlockFluidTank) {
                ExtraItemBlockFluidTank tank = (ExtraItemBlockFluidTank)item;
                float[] color = TierColor.getColor(tank.getAdvanceTier());
                return MekanismRenderer.getColorARGB((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
            }
            return -1;
        }, (IItemProvider[])new IItemProvider[]{ExtraBlock.ABSOLUTE_FLUID_TANK, ExtraBlock.SUPREME_FLUID_TANK, ExtraBlock.COSMIC_FLUID_TANK, ExtraBlock.INFINITE_FLUID_TANK});
        ClientRegistrationUtil.registerItemColorHandler((RegisterColorHandlersEvent.Item)event, (stack, tintIndex) -> {
            Item item = stack.m_41720_();
            if (tintIndex == 1 && item instanceof ExtraItemBlockEnergyCube) {
                ExtraItemBlockEnergyCube cube = (ExtraItemBlockEnergyCube)item;
                float[] color = TierColor.getColor(cube.getAdvanceTier());
                return MekanismRenderer.getColorARGB((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
            }
            return -1;
        }, (IItemProvider[])new IItemProvider[]{ExtraBlock.ABSOLUTE_ENERGY_CUBE, ExtraBlock.SUPREME_ENERGY_CUBE, ExtraBlock.COSMIC_ENERGY_CUBE, ExtraBlock.INFINITE_ENERGY_CUBE});
        for (Table.Cell cell : MekanismItems.PROCESSED_RESOURCES.cellSet()) {
            int tint = ((PrimaryResource)cell.getColumnKey()).getTint();
            ClientRegistrationUtil.registerItemColorHandler((RegisterColorHandlersEvent.Item)event, (stack, index) -> index == 1 ? tint : -1, (IItemProvider[])new IItemProvider[]{(IItemProvider)cell.getValue()});
        }
        for (Map.Entry entry : MekanismBlocks.PROCESSED_RESOURCE_BLOCKS.entrySet()) {
            Object k = entry.getKey();
            if (!(k instanceof PrimaryResource)) continue;
            PrimaryResource primaryResource = (PrimaryResource)k;
            int tint = primaryResource.getTint();
            ClientRegistrationUtil.registerItemColorHandler((RegisterColorHandlersEvent.Item)event, (stack, index) -> index == 1 ? tint : -1, (IItemProvider[])new IItemProvider[]{(IItemProvider)entry.getValue()});
        }
    }

    @SubscribeEvent
    public static void registerItemDecorations(RegisterItemDecorationsEvent event) {
        TransmitterTypeDecorator.registerDecorators((RegisterItemDecorationsEvent)event, (IBlockProvider[])new IBlockProvider[]{ExtraBlock.ABSOLUTE_PRESSURIZED_TUBE, ExtraBlock.SUPREME_PRESSURIZED_TUBE, ExtraBlock.COSMIC_PRESSURIZED_TUBE, ExtraBlock.INFINITE_PRESSURIZED_TUBE, ExtraBlock.ABSOLUTE_THERMODYNAMIC_CONDUCTOR, ExtraBlock.SUPREME_THERMODYNAMIC_CONDUCTOR, ExtraBlock.COSMIC_THERMODYNAMIC_CONDUCTOR, ExtraBlock.INFINITE_THERMODYNAMIC_CONDUCTOR, ExtraBlock.ABSOLUTE_UNIVERSAL_CABLE, ExtraBlock.SUPREME_UNIVERSAL_CABLE, ExtraBlock.COSMIC_UNIVERSAL_CABLE, ExtraBlock.INFINITE_UNIVERSAL_CABLE});
    }
}

