/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.network.to_server;

import com.jerry.mekanism_extras.common.tile.factory.TileEntityExtraFactory;
import mekanism.api.functions.TriConsumer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ExtraPacketGuiInteract
implements IMekanismPacket {
    private final Type interactionType;
    private ExtraGuiInteraction interaction;
    private GuiInteractionItem itemInteraction;
    private GuiInteractionEntity entityInteraction;
    private BlockPos tilePosition;
    private ItemStack extraItem;
    private int entityID;
    private int extra;

    public ExtraPacketGuiInteract(GuiInteractionEntity interaction, Entity entity) {
        this(interaction, entity, 0);
    }

    public ExtraPacketGuiInteract(GuiInteractionEntity interaction, Entity entity, int extra) {
        this(interaction, entity.m_19879_(), extra);
    }

    public ExtraPacketGuiInteract(GuiInteractionEntity interaction, int entityID, int extra) {
        this.interactionType = Type.ENTITY;
        this.entityInteraction = interaction;
        this.entityID = entityID;
        this.extra = extra;
    }

    public ExtraPacketGuiInteract(ExtraGuiInteraction interaction, BlockEntity tile) {
        this(interaction, tile.m_58899_());
    }

    public ExtraPacketGuiInteract(ExtraGuiInteraction interaction, BlockEntity tile, int extra) {
        this(interaction, tile.m_58899_(), extra);
    }

    public ExtraPacketGuiInteract(ExtraGuiInteraction interaction, BlockPos tilePosition) {
        this(interaction, tilePosition, 0);
    }

    public ExtraPacketGuiInteract(ExtraGuiInteraction interaction, BlockPos tilePosition, int extra) {
        this.interactionType = Type.INT;
        this.interaction = interaction;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public ExtraPacketGuiInteract(GuiInteractionItem interaction, BlockEntity tile, ItemStack stack) {
        this(interaction, tile.m_58899_(), stack);
    }

    public ExtraPacketGuiInteract(GuiInteractionItem interaction, BlockPos tilePosition, ItemStack stack) {
        this.interactionType = Type.ITEM;
        this.itemInteraction = interaction;
        this.tilePosition = tilePosition;
        this.extraItem = stack;
    }

    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player != null) {
            if (this.interactionType == Type.ENTITY) {
                Entity entity = player.m_9236_().m_6815_(this.entityID);
                if (entity != null) {
                    this.entityInteraction.consume(entity, (Player)player, this.extra);
                }
            } else {
                TileEntityMekanism tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.m_9236_(), (BlockPos)this.tilePosition);
                if (tile != null) {
                    if (this.interactionType == Type.INT) {
                        this.interaction.consume(tile, (Player)player, this.extra);
                    } else if (this.interactionType == Type.ITEM) {
                        this.itemInteraction.consume(tile, (Player)player, this.extraItem);
                    }
                }
            }
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.interactionType);
        switch (this.interactionType) {
            case ENTITY: {
                buffer.m_130068_((Enum)this.entityInteraction);
                buffer.m_130130_(this.entityID);
                buffer.m_130130_(this.extra);
                break;
            }
            case INT: {
                buffer.m_130068_((Enum)this.interaction);
                buffer.m_130064_(this.tilePosition);
                buffer.m_130130_(this.extra);
                break;
            }
            case ITEM: {
                buffer.m_130068_((Enum)this.itemInteraction);
                buffer.m_130064_(this.tilePosition);
                buffer.m_130055_(this.extraItem);
            }
        }
    }

    public static ExtraPacketGuiInteract decode(FriendlyByteBuf buffer) {
        return switch ((Type)buffer.m_130066_(Type.class)) {
            default -> throw new IncompatibleClassChangeError();
            case Type.ENTITY -> new ExtraPacketGuiInteract((GuiInteractionEntity)buffer.m_130066_(GuiInteractionEntity.class), buffer.m_130242_(), buffer.m_130242_());
            case Type.INT -> new ExtraPacketGuiInteract((ExtraGuiInteraction)buffer.m_130066_(ExtraGuiInteraction.class), buffer.m_130135_(), buffer.m_130242_());
            case Type.ITEM -> new ExtraPacketGuiInteract((GuiInteractionItem)buffer.m_130066_(GuiInteractionItem.class), buffer.m_130135_(), buffer.m_130267_());
        };
    }

    public static final class GuiInteractionEntity
    extends Enum<GuiInteractionEntity> {
        private final TriConsumer<Entity, Player, Integer> consumerForEntity;
        private static final /* synthetic */ GuiInteractionEntity[] $VALUES;

        public static GuiInteractionEntity[] values() {
            return (GuiInteractionEntity[])$VALUES.clone();
        }

        public static GuiInteractionEntity valueOf(String name) {
            return Enum.valueOf(GuiInteractionEntity.class, name);
        }

        private GuiInteractionEntity(TriConsumer<Entity, Player, Integer> consumerForEntity) {
            this.consumerForEntity = consumerForEntity;
        }

        public void consume(Entity entity, Player player, int extra) {
            this.consumerForEntity.accept((Object)entity, (Object)player, (Object)extra);
        }

        private static /* synthetic */ GuiInteractionEntity[] $values() {
            return new GuiInteractionEntity[0];
        }

        static {
            $VALUES = GuiInteractionEntity.$values();
        }
    }

    private static enum Type {
        ENTITY,
        ITEM,
        INT;

    }

    public static enum ExtraGuiInteraction {
        AUTO_SORT_BUTTON((TriConsumer<TileEntityMekanism, Player, Integer>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityExtraFactory) {
                TileEntityExtraFactory factory = (TileEntityExtraFactory)((Object)tile);
                factory.toggleSorting();
            }
        }));

        private final TriConsumer<TileEntityMekanism, Player, Integer> consumerForTile;

        private ExtraGuiInteraction(TriConsumer<TileEntityMekanism, Player, Integer> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, Player player, int extra) {
            this.consumerForTile.accept((Object)tile, (Object)player, (Object)extra);
        }
    }

    public static final class GuiInteractionItem
    extends Enum<GuiInteractionItem> {
        private final TriConsumer<TileEntityMekanism, Player, ItemStack> consumerForTile;
        private static final /* synthetic */ GuiInteractionItem[] $VALUES;

        public static GuiInteractionItem[] values() {
            return (GuiInteractionItem[])$VALUES.clone();
        }

        public static GuiInteractionItem valueOf(String name) {
            return Enum.valueOf(GuiInteractionItem.class, name);
        }

        private GuiInteractionItem(TriConsumer<TileEntityMekanism, Player, ItemStack> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, Player player, ItemStack stack) {
            this.consumerForTile.accept((Object)tile, (Object)player, (Object)stack);
        }

        private static /* synthetic */ GuiInteractionItem[] $values() {
            return new GuiInteractionItem[0];
        }

        static {
            $VALUES = GuiInteractionItem.$values();
        }
    }
}

