/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.tile;

import com.jerry.mekanism_extras.common.block.attribute.ExtraAttribute;
import com.jerry.mekanism_extras.common.capabilities.energy.ExtraEnergyCubeEnergyContainer;
import com.jerry.mekanism_extras.common.tier.ECTier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import mekanism.common.upgrade.EnergyCubeUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;

public class ExtraTileEntityEnergyCube
extends TileEntityConfigurableMachine {
    public static final ModelProperty<CubeSideState[]> SIDE_STATE_PROPERTY = new ModelProperty();
    private ECTier tier;
    private float prevScale;
    private ExtraEnergyCubeEnergyContainer energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getChargeItem"}, docPlaceholder="")
    EnergyInventorySlot chargeSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getDischargeItem"}, docPlaceholder="")
    EnergyInventorySlot dischargeSlot;

    public ExtraTileEntityEnergyCube(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.configComponent = new TileComponentConfig((TileEntityMekanism)this, new TransmissionType[]{TransmissionType.ENERGY, TransmissionType.ITEM});
        this.configComponent.setupIOConfig(TransmissionType.ITEM, (Object)this.chargeSlot, (Object)this.dischargeSlot, RelativeSide.FRONT, true).setCanEject(false);
        this.configComponent.setupIOConfig(TransmissionType.ENERGY, (Object)this.energyContainer, RelativeSide.FRONT).setEjecting(true);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this, () -> this.tier.getOutput());
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ENERGY}).setCanEject(type -> MekanismUtils.canFunction((TileEntityMekanism)this));
    }

    protected void presetVariables() {
        super.presetVariables();
        this.tier = ExtraAttribute.getTier(this.getBlockType(), ECTier.class);
    }

    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(() -> ((ExtraTileEntityEnergyCube)this).getDirection(), () -> ((ExtraTileEntityEnergyCube)this).getConfig());
        this.energyContainer = ExtraEnergyCubeEnergyContainer.create(this.tier, listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @Nonnull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(() -> ((ExtraTileEntityEnergyCube)this).getDirection(), () -> ((ExtraTileEntityEnergyCube)this).getConfig());
        this.dischargeSlot = EnergyInventorySlot.fillOrConvert((IEnergyContainer)this.energyContainer, () -> ((ExtraTileEntityEnergyCube)this).m_58904_(), (IContentsListener)listener, (int)17, (int)35);
        builder.addSlot((IInventorySlot)this.dischargeSlot);
        this.chargeSlot = EnergyInventorySlot.drain((IEnergyContainer)this.energyContainer, (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.chargeSlot);
        this.dischargeSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.chargeSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    public ECTier getTier() {
        return this.tier;
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        this.chargeSlot.drainContainer();
        this.dischargeSlot.fillContainerOrConvert();
        float newScale = MekanismUtils.getScale((float)this.prevScale, (IEnergyContainer)this.energyContainer);
        if (newScale != this.prevScale) {
            this.prevScale = newScale;
            this.sendUpdatePacket();
        }
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((FloatingLong)this.energyContainer.getEnergy(), (FloatingLong)this.energyContainer.getMaxEnergy());
    }

    protected boolean makesComparatorDirty(@Nullable SubstanceType type) {
        return type == SubstanceType.ENERGY;
    }

    public void parseUpgradeData(@Nonnull IUpgradeData upgradeData) {
        if (upgradeData instanceof EnergyCubeUpgradeData) {
            EnergyCubeUpgradeData data = (EnergyCubeUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.chargeSlot.setStack(data.chargeSlot.getStack());
            this.dischargeSlot.deserializeNBT(data.dischargeSlot.serializeNBT());
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components);
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }

    public ExtraEnergyCubeEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    @Nonnull
    public EnergyCubeUpgradeData getUpgradeData() {
        return new EnergyCubeUpgradeData(this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.chargeSlot, this.dischargeSlot, this.getComponents());
    }

    public float getEnergyScale() {
        return this.prevScale;
    }

    @Nonnull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        updateTag.m_128350_("scale", this.prevScale);
        return updateTag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag) {
        ConfigInfo config = this.getConfig().getConfig(TransmissionType.ENERGY);
        DataType[] currentConfig = new DataType[EnumUtils.SIDES.length];
        if (config != null) {
            for (RelativeSide side : EnumUtils.SIDES) {
                currentConfig[side.ordinal()] = config.getDataType(side);
            }
        }
        super.handleUpdateTag(tag);
        NBTUtils.setFloatIfPresent((CompoundTag)tag, (String)"scale", scale -> {
            this.prevScale = scale;
        });
        if (config != null) {
            for (RelativeSide side : EnumUtils.SIDES) {
                if (currentConfig[side.ordinal()] == config.getDataType(side)) continue;
                this.updateModelData();
                break;
            }
        }
    }

    @NotNull
    public ModelData getModelData() {
        ConfigInfo config = this.getConfig().getConfig(TransmissionType.ENERGY);
        if (config == null) {
            return super.getModelData();
        }
        CubeSideState[] sideStates = new CubeSideState[EnumUtils.SIDES.length];
        for (RelativeSide side : EnumUtils.SIDES) {
            CubeSideState state = CubeSideState.INACTIVE;
            ISlotInfo slotInfo = config.getSlotInfo(side);
            if (slotInfo != null) {
                if (slotInfo.canOutput()) {
                    state = CubeSideState.ACTIVE_LIT;
                } else if (slotInfo.canInput()) {
                    state = CubeSideState.ACTIVE_UNLIT;
                }
            }
            sideStates[side.ordinal()] = state;
        }
        return ModelData.builder().with(SIDE_STATE_PROPERTY, (Object)sideStates).build();
    }

    public static enum CubeSideState {
        ACTIVE_LIT,
        ACTIVE_UNLIT,
        INACTIVE;

    }
}

