/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.tile;

import com.jerry.mekanism_extras.common.capabilities.chemical.ExtraStackedWasteBarrel;
import com.jerry.mekanism_extras.common.config.LoadConfig;
import com.jerry.mekanism_extras.common.registry.ExtraBlock;
import java.util.Collections;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraTileEntityRadioactiveWasteBarrel
extends TileEntityMekanism
implements IConfigurable {
    private long lastProcessTick;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getStored", "getCapacity", "getNeeded", "getFilledPercentage"}, docPlaceholder="barrel")
    ExtraStackedWasteBarrel gasTank;
    private float prevScale;
    private int processTicks;

    public ExtraTileEntityRadioactiveWasteBarrel(BlockPos pos, BlockState state) {
        super(ExtraBlock.EXPAND_RADIOACTIVE_WASTE_BARREL, pos, state);
        this.addCapabilityResolver((ICapabilityResolver)BasicCapabilityResolver.constant((Capability)Capabilities.CONFIGURABLE, (Object)((Object)this)));
    }

    @NotNull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSide(() -> ((ExtraTileEntityRadioactiveWasteBarrel)this).getDirection());
        this.gasTank = ExtraStackedWasteBarrel.create(this, listener);
        builder.addTank((IChemicalTank)this.gasTank, new RelativeSide[]{RelativeSide.TOP, RelativeSide.BOTTOM});
        return builder.build();
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.f_58857_.m_46467_() > this.lastProcessTick) {
            this.lastProcessTick = this.f_58857_.m_46467_();
            if (LoadConfig.extraConfig.radioactiveWasteBarrelDecayAmount.get() > 0L && !this.gasTank.isEmpty() && !MekanismTags.Gases.WASTE_BARREL_DECAY_LOOKUP.contains((Object)((Gas)this.gasTank.getType())) && ++this.processTicks >= LoadConfig.extraConfig.radioactiveWasteBarrelProcessTicks.get()) {
                this.processTicks = 0;
                this.gasTank.shrinkStack(LoadConfig.extraConfig.radioactiveWasteBarrelDecayAmount.get(), Action.EXECUTE);
            }
            if (this.getActive()) {
                ChemicalUtil.emit(Collections.singleton(Direction.DOWN), (IChemicalTank)this.gasTank, (BlockEntity)this);
            }
        }
    }

    public ExtraStackedWasteBarrel getGasTank() {
        return this.gasTank;
    }

    public double getGasScale() {
        return (double)this.gasTank.getStored() / (double)this.gasTank.getCapacity();
    }

    public GasStack getGas() {
        return (GasStack)this.gasTank.getStack();
    }

    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            this.setActive(!this.getActive());
            Level world = this.m_58904_();
            if (world != null) {
                world.m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (SoundEvent)SoundEvents.f_12490_.get(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onRightClick(Player player) {
        return InteractionResult.PASS;
    }

    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        updateTag.m_128365_("gas", (Tag)this.gasTank.serializeNBT());
        updateTag.m_128405_("progress", this.processTicks);
        return updateTag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setCompoundIfPresent((CompoundTag)tag, (String)"gas", nbt -> this.gasTank.deserializeNBT((CompoundTag)nbt));
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"progress", val -> {
            this.processTicks = val;
        });
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.gasTank.getStored(), (long)this.gasTank.getCapacity());
    }

    protected boolean makesComparatorDirty(@Nullable SubstanceType type) {
        return type == SubstanceType.GAS;
    }
}

