/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.tile.transmitter;

import com.jerry.mekanism_extras.api.IExtraAlloyInteraction;
import com.jerry.mekanism_extras.api.tier.AdvancedTier;
import com.jerry.mekanism_extras.api.tier.ExtraAlloyTier;
import com.jerry.mekanism_extras.common.capabilities.ExtraCapabilities;
import com.jerry.mekanism_extras.common.content.network.transmitter.IExtraUpgradeableTransmitter;
import com.jerry.mekanism_extras.common.tile.transmitter.ExtraTileEntityLogisticalTransporter;
import java.util.ArrayList;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.Mekanism;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.capabilities.proxy.ProxyConfigurable;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.content.network.transmitter.BufferedTransmitter;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class ExtraTileEntityTransmitter
extends TileEntityTransmitter
implements ProxyConfigurable.ISidedConfigurable,
IExtraAlloyInteraction {
    public ExtraTileEntityTransmitter(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.addCapabilityResolver((ICapabilityResolver)BasicCapabilityResolver.constant(ExtraCapabilities.EXTRA_ALLOY_INTERACTION, (Object)this));
    }

    public static void extraTickServer(Level level, BlockPos blockPos, BlockState blockState, ExtraTileEntityLogisticalTransporter extraTileEntityLogisticalTransporter) {
        extraTileEntityLogisticalTransporter.onUpdateServer();
    }

    @Override
    public void onExtraAlloyInteraction(Player player, ItemStack stack, @NotNull ExtraAlloyTier tier) {
        if (this.m_58904_() != null && this.getTransmitter().hasTransmitterNetwork()) {
            DynamicNetwork transmitterNetwork = this.getTransmitter().getTransmitterNetwork();
            ArrayList list = new ArrayList(transmitterNetwork.getTransmitters());
            list.sort((o1, o2) -> {
                if (o1 != null && o2 != null) {
                    return Double.compare(o1.getTilePos().m_123331_((Vec3i)this.f_58858_), o2.getTilePos().m_123331_((Vec3i)this.f_58858_));
                }
                return 0;
            });
            boolean sharesSet = false;
            int upgraded = 0;
            for (Transmitter transmitter : list) {
                BlockState upgradeState;
                ExtraTileEntityTransmitter transmitterTile;
                BlockState state;
                IExtraUpgradeableTransmitter upgradeableTransmitter;
                if (!(transmitter instanceof IExtraUpgradeableTransmitter) || !(upgradeableTransmitter = (IExtraUpgradeableTransmitter)transmitter).canUpgrade(tier) || (state = (transmitterTile = (ExtraTileEntityTransmitter)transmitter.getTransmitterTile()).m_58900_()) == (upgradeState = transmitterTile.upgradeResult(state, tier.getAdvanceTier()))) continue;
                if (!sharesSet) {
                    if (transmitterNetwork instanceof DynamicBufferedNetwork) {
                        DynamicBufferedNetwork dynamicNetwork = (DynamicBufferedNetwork)transmitterNetwork;
                        dynamicNetwork.validateSaveShares((BufferedTransmitter)transmitter);
                    }
                    sharesSet = true;
                }
                transmitter.startUpgrading();
                Object upgradeData = upgradeableTransmitter.getUpgradeData();
                BlockPos transmitterPos = transmitter.getTilePos();
                Level transmitterWorld = transmitter.getTileWorld();
                if (upgradeData == null) {
                    Mekanism.logger.warn("Got no upgrade data for transmitter at position: {} in {} but it said it would be able to provide some.", (Object)transmitterPos, (Object)transmitterWorld);
                    continue;
                }
                transmitterWorld.m_46597_(transmitterPos, upgradeState);
                ExtraTileEntityTransmitter upgradedTile = (ExtraTileEntityTransmitter)WorldUtils.getTileEntity(ExtraTileEntityTransmitter.class, (BlockGetter)transmitterWorld, (BlockPos)transmitterPos);
                if (upgradedTile == null) {
                    Mekanism.logger.warn("Error upgrading transmitter at position: {} in {}.", (Object)transmitterPos, (Object)transmitterWorld);
                    continue;
                }
                Transmitter upgradedTransmitter = upgradedTile.getTransmitter();
                if (upgradedTransmitter instanceof IExtraUpgradeableTransmitter) {
                    this.transferUpgradeData((IExtraUpgradeableTransmitter)upgradedTransmitter, (TransmitterUpgradeData)upgradeData);
                } else {
                    Mekanism.logger.warn("Unhandled upgrade data.", (Throwable)new IllegalStateException());
                }
                if (++upgraded != 8) continue;
                break;
            }
            if (upgraded > 0) {
                transmitterNetwork.invalidate(null);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    MekanismCriteriaTriggers.ALLOY_UPGRADE.trigger(serverPlayer);
                }
            }
        }
    }

    private <DATA extends TransmitterUpgradeData> void transferUpgradeData(IExtraUpgradeableTransmitter<DATA> upgradeableTransmitter, TransmitterUpgradeData data) {
        if (upgradeableTransmitter.dataTypeMatches(data)) {
            upgradeableTransmitter.parseUpgradeData(data);
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", (Throwable)new IllegalStateException());
        }
    }

    @NotNull
    protected BlockState upgradeResult(@NotNull BlockState current, @NotNull AdvancedTier tier) {
        return current;
    }
}

