/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.block;

import dev.su5ed.mffs.MFFSMod;
import dev.su5ed.mffs.blockentity.BaseBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseEntityBlock
extends Block
implements EntityBlock {
    public static final ResourceLocation CONTENT_KEY = MFFSMod.location("content");
    public static final Property<Boolean> ACTIVE = BooleanProperty.m_61465_((String)"active");
    private final Supplier<? extends BlockEntityType<? extends BaseBlockEntity>> provider;

    public BaseEntityBlock(BlockBehaviour.Properties properties, Supplier<? extends BlockEntityType<? extends BaseBlockEntity>> provider) {
        super(properties);
        this.provider = provider;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.getBlockEntity((BlockGetter)level, pos).map(be -> be.use(player, hand, hit)).orElseGet(() -> super.m_6227_(state, level, pos, player, hand, hit));
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!(!state.m_155947_() || state.m_60713_(newState.m_60734_()) && newState.m_155947_())) {
            this.getBlockEntity((BlockGetter)level, pos).ifPresent(BaseBlockEntity::beforeBlockRemove);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)super.m_5573_(pContext).m_61124_(ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        BlockEntity be = (BlockEntity)params.m_287159_(LootContextParams.f_81462_);
        if (be instanceof BaseBlockEntity) {
            BaseBlockEntity base = (BaseBlockEntity)be;
            params.m_287145_(CONTENT_KEY, consumer -> {
                ArrayList drops = new ArrayList();
                base.provideAdditionalDrops(drops);
                drops.forEach(consumer);
            });
        }
        return super.m_49635_(state, params);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.provider.get().m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (lvl, pos, stt, te) -> {
            if (te instanceof BaseBlockEntity) {
                BaseBlockEntity machine = (BaseBlockEntity)te;
                if (lvl.m_5776_()) {
                    machine.tickClient();
                } else {
                    machine.tickServer();
                }
            }
        };
    }

    private Optional<? extends BaseBlockEntity> getBlockEntity(BlockGetter world, BlockPos pos) {
        Optional<Object> optional;
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof BaseBlockEntity) {
            BaseBlockEntity machineBe = (BaseBlockEntity)be;
            optional = Optional.of(machineBe);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }
}

