/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.block;

import dev.su5ed.mffs.api.ForceFieldBlock;
import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.api.module.Module;
import dev.su5ed.mffs.api.security.BiometricIdentifier;
import dev.su5ed.mffs.api.security.FieldPermission;
import dev.su5ed.mffs.blockentity.ForceFieldBlockEntity;
import dev.su5ed.mffs.compat.CreateTrainCompat;
import dev.su5ed.mffs.setup.ModObjects;
import dev.su5ed.mffs.util.ModUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ForceFieldBlockImpl
extends Block
implements ForceFieldBlock,
EntityBlock {
    private static final VoxelShape COLLIDABLE_BLOCK = Shapes.m_166049_((double)0.01, (double)0.01, (double)0.01, (double)0.99, (double)0.99, (double)0.99);

    public ForceFieldBlockImpl() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_155954_(-1.0f).m_60913_(-1.0f, 3600000.0f).m_222994_());
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamouflageBlock(level, pos).map(block -> block.m_60631_(level, pos)).orElse(true);
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamouflageBlock(level, pos).map(block -> Float.valueOf(block.m_60792_(level, pos))).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction side) {
        return this.getCamouflageBlock(level, pos).flatMap(block -> this.getCamouflageBlock(level, pos.m_121945_(side)).map(neighbor -> block.m_60719_(neighbor, side))).orElseGet(() -> neighborState.m_60713_((Block)this));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getCamouflageBlock(level, pos).map(block -> block.m_60808_(level, pos)).orElseGet(() -> super.m_5940_(state, level, pos, context));
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getCamouflageBlock(level, pos).map(block -> block.m_60771_(level, pos, context)).orElseGet(Shapes::m_83040_);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamouflageBlock(level, pos).map(block -> block.m_60768_(level, pos)).orElseGet(() -> super.m_7952_(state, level, pos));
    }

    @Override
    public Optional<Projector> getProjector(BlockGetter level, BlockPos pos) {
        Optional<Projector> optional;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof ForceFieldBlockEntity) {
            ForceFieldBlockEntity forceField = (ForceFieldBlockEntity)be;
            optional = forceField.getProjector();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    private Optional<BlockState> getCamouflageBlock(BlockGetter level, BlockPos pos) {
        return Optional.ofNullable(level.getExistingBlockEntity(pos)).map(be -> {
            BlockState blockState;
            if (be instanceof ForceFieldBlockEntity) {
                ForceFieldBlockEntity forceField = (ForceFieldBlockEntity)((Object)be);
                blockState = forceField.getCamouflage();
            } else {
                blockState = null;
            }
            return blockState;
        });
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return ItemStack.f_41583_;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return Optional.ofNullable(level.m_7702_(pos)).map(be -> {
            Integer n;
            if (be instanceof ForceFieldBlockEntity) {
                ForceFieldBlockEntity f = (ForceFieldBlockEntity)((Object)be);
                n = f.getClientBlockLight();
            } else {
                n = null;
            }
            return n;
        }).orElseGet(() -> super.getLightEmission(state, level, pos));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getProjector(level, pos).map(projector -> {
            EntityCollisionContext entityContext;
            Entity patt5004$temp;
            if (context instanceof EntityCollisionContext && (patt5004$temp = (entityContext = (EntityCollisionContext)context).m_193113_()) instanceof Player) {
                Player player = (Player)patt5004$temp;
                BiometricIdentifier bioIndentifier = projector.getBiometricIdentifier();
                if (player.m_6144_() && !context.m_6513_(COLLIDABLE_BLOCK, pos, true) && (player.m_7500_() || bioIndentifier != null && bioIndentifier.isAccessGranted(player, FieldPermission.WARP))) {
                    return Shapes.m_83040_();
                }
            }
            return null;
        }).orElse(COLLIDABLE_BLOCK);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.m_7892_(state, level, pos, entity);
        this.getProjector((BlockGetter)level, pos).ifPresent(projector -> {
            block6: {
                block7: {
                    Player player;
                    for (Module module : projector.getModuleInstances()) {
                        if (!module.onCollideWithForceField(level, pos, entity)) continue;
                        return;
                    }
                    if (entity.m_9236_().f_46443_) break block6;
                    Vec3 vec3 = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                    if (!(entity.m_20238_(vec3) < Mth.m_144952_((double)0.7))) break block6;
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        if (!(entity instanceof Player) || !(player = (Player)entity).m_7500_()) {
                            living.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 80, 3));
                            living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 1));
                        }
                    }
                    BiometricIdentifier identifier = projector.getBiometricIdentifier();
                    if (!(entity instanceof Player)) break block7;
                    player = (Player)entity;
                    if (this.isSneaking(entity) && (player.m_7500_() || identifier != null && identifier.isAccessGranted(player, FieldPermission.WARP))) break block6;
                }
                ModUtil.shockEntity(entity, Integer.MAX_VALUE);
            }
        });
    }

    private boolean isSneaking(Entity entity) {
        return entity.m_6144_() || CreateTrainCompat.isTrainPassenger(entity);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModObjects.FORCE_FIELD_BLOCK_ENTITY.get()).m_155264_(pos, state);
    }
}

