/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.item;

import dev.su5ed.mffs.util.CustomEnergyStorage;
import dev.su5ed.mffs.util.ModUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class BatteryItem
extends Item {
    private final int capacity;
    private final int maxTransfer;

    public BatteryItem() {
        this(100000, 1000);
    }

    public BatteryItem(int capacity, int maxTransfer) {
        super(new Item.Properties().m_41487_(1));
        this.capacity = capacity;
        this.maxTransfer = maxTransfer;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> tooltipComponents.add((Component)ModUtil.translate("info", "stored_energy", Component.m_237113_((String)String.valueOf(energy.getEnergyStored())).m_130940_(ChatFormatting.GRAY), Component.m_237113_((String)String.valueOf(energy.getMaxEnergyStored())).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY)));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new BatteryEnergyStorage(this.capacity, this.maxTransfer);
    }

    public boolean m_142522_(ItemStack stack) {
        return BatteryItem.getChargeLevel(stack) < 1.0f;
    }

    public int m_142158_(ItemStack stack) {
        float charge = BatteryItem.getChargeLevel(stack);
        return (int)Math.round((double)charge * 13.0);
    }

    public int m_142159_(ItemStack stack) {
        float charge = BatteryItem.getChargeLevel(stack);
        return Mth.m_14169_((float)(charge / 3.0f), (float)1.0f, (float)1.0f);
    }

    private static float getChargeLevel(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(energy -> Float.valueOf((float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored())).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private static class BatteryEnergyStorage
    implements ICapabilityProvider,
    INBTSerializable<Tag> {
        private final CustomEnergyStorage storage;
        private final LazyOptional<IEnergyStorage> optional;

        public BatteryEnergyStorage(int capacity, int maxTransfer) {
            this.storage = new CustomEnergyStorage(capacity, maxTransfer, () -> true, () -> {});
            this.optional = LazyOptional.of(() -> this.storage);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
            return ForgeCapabilities.ENERGY.orEmpty(cap, this.optional);
        }

        public Tag serializeNBT() {
            return this.storage.serializeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.storage.deserializeNBT(nbt);
        }
    }
}

