/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.item;

import dev.su5ed.mffs.MFFSConfig;
import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.api.module.ProjectorMode;
import dev.su5ed.mffs.item.BaseItem;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.setup.ModObjects;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.loot.FieldShapeTrigger;
import dev.su5ed.mffs.util.projector.CustomStructureSavedData;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.Nullable;

public class CustomProjectorModeItem
extends BaseItem {
    public static final String TAG_PATTERN_ID = "pattern_id";
    private static final String TAG_MODE = "mode";
    public static final String TAG_POINT_PRIMARY = "primary_point";
    public static final String TAG_POINT_SECONDARY = "secondary_point";
    private CustomStructureSavedData structureManager;

    public CustomProjectorModeItem() {
        super(new BaseItem.ExtendedItemProperties(new Item.Properties().m_41487_(1)));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemStack stack = player.m_21120_(usedHand);
                CompoundTag tag = stack.m_41784_();
                if (player.m_6144_()) {
                    CustomStructureSavedData data = this.getOrCreateData(serverLevel);
                    if (tag.m_128441_(TAG_POINT_PRIMARY) && tag.m_128441_(TAG_POINT_SECONDARY)) {
                        int distance;
                        BlockPos secondary;
                        BlockPos primary = CustomProjectorModeItem.getPos(tag, TAG_POINT_PRIMARY);
                        if (primary.m_123314_((Vec3i)(secondary = CustomProjectorModeItem.getPos(tag, TAG_POINT_SECONDARY)), (double)(distance = ((Integer)MFFSConfig.COMMON.maxCustomModeScale.get()).intValue()))) {
                            tag.m_128473_(TAG_POINT_PRIMARY);
                            tag.m_128473_(TAG_POINT_SECONDARY);
                            String id = this.getOrCreateId(tag);
                            data.join(id, level, serverPlayer, primary, secondary, this.getMode(tag) == Mode.ADDITIVE);
                            player.m_5661_((Component)ModUtil.translate("item", "custom_mode.data_saved", new Object[0]), true);
                            ((FieldShapeTrigger)((Object)ModObjects.FIELD_SHAPE_TRIGGER.get())).trigger(serverPlayer);
                        } else {
                            player.m_5661_((Component)ModUtil.translate("item", "custom_mode.too_far", distance), true);
                        }
                        return InteractionResultHolder.m_19090_((Object)stack);
                    }
                    if (tag.m_128441_(TAG_PATTERN_ID)) {
                        String id = tag.m_128461_(TAG_PATTERN_ID);
                        data.clear(level, serverPlayer, id);
                        tag.m_128473_(TAG_PATTERN_ID);
                        player.m_5661_((Component)ModUtil.translate("item", "custom_mode.clear", new Object[0]), true);
                        return InteractionResultHolder.m_19090_((Object)stack);
                    }
                } else if (tag.m_128441_(TAG_POINT_PRIMARY) && !tag.m_128441_(TAG_POINT_SECONDARY)) {
                    HitResult result = player.m_19907_(player.getBlockReach(), 0.0f, true);
                    if (result instanceof BlockHitResult) {
                        BlockHitResult blockHitResult = (BlockHitResult)result;
                        this.selectBlock(player, tag, blockHitResult.m_82425_(), TAG_POINT_SECONDARY, ChatFormatting.GOLD);
                        return InteractionResultHolder.m_19090_((Object)stack);
                    }
                } else {
                    Mode mode = this.setMode(tag, this.getMode(tag).next());
                    player.m_5661_((Component)ModUtil.translate("item", "custom_mode.changed_mode", mode.getName().m_130940_(ChatFormatting.GREEN)), true);
                    return InteractionResultHolder.m_19096_((Object)stack);
                }
            }
        }
        return super.m_7203_(level, player, usedHand);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        if (!level.f_46443_) {
            CompoundTag tag = stack.m_41784_();
            BlockPos pos = context.m_8083_();
            Player player = context.m_43723_();
            if (!tag.m_128441_(TAG_POINT_PRIMARY) || tag.m_128441_(TAG_POINT_SECONDARY)) {
                tag.m_128473_(TAG_POINT_SECONDARY);
                this.selectBlock(player, tag, pos, TAG_POINT_PRIMARY, ChatFormatting.GREEN);
            } else {
                this.selectBlock(player, tag, pos, TAG_POINT_SECONDARY, ChatFormatting.GOLD);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void selectBlock(Player player, CompoundTag tag, BlockPos pos, String key, ChatFormatting color) {
        tag.m_128365_(key, (Tag)NbtUtils.m_129224_((BlockPos)pos));
        MutableComponent component = ModUtil.translate("item", "custom_mode.set_" + key, new Object[0]).m_130940_(color);
        player.m_5661_((Component)component, true);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        CompoundTag tag = stack.m_41784_();
        Mode mode = this.getMode(tag);
        tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.mode", mode.getName().m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        String id = tag.m_128461_(TAG_PATTERN_ID);
        if (!id.isEmpty()) {
            tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.pattern_id", Component.m_237113_((String)id).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (tag.m_128441_(TAG_POINT_PRIMARY)) {
            BlockPos primary = CustomProjectorModeItem.getPos(tag, TAG_POINT_PRIMARY);
            tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.primary_point", Component.m_237113_((String)primary.m_123344_()).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
            if (tag.m_128441_(TAG_POINT_SECONDARY)) {
                BlockPos secondary = CustomProjectorModeItem.getPos(tag, TAG_POINT_SECONDARY);
                tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.secondary_point", Component.m_237113_((String)secondary.m_123344_()).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
                tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.set_secondary_point", new Object[0]).m_130940_(ChatFormatting.GOLD));
            } else {
                tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.set_primary_point", new Object[0]).m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new CustomProjectorModeCapability(stack);
    }

    public Mode getMode(CompoundTag tag) {
        return tag.m_128441_(TAG_MODE) ? Mode.valueOf(tag.m_128461_(TAG_MODE)) : Mode.ADDITIVE;
    }

    public Mode setMode(CompoundTag tag, Mode mode) {
        tag.m_128359_(TAG_MODE, mode.name());
        return mode;
    }

    public static BlockPos getPos(CompoundTag tag, String key) {
        return NbtUtils.m_129239_((CompoundTag)tag.m_128469_(key));
    }

    public String getOrCreateId(CompoundTag tag) {
        if (!tag.m_128441_(TAG_PATTERN_ID)) {
            String id = RandomStringUtils.randomAlphanumeric((int)8).toUpperCase(Locale.ROOT);
            tag.m_128359_(TAG_PATTERN_ID, id);
            return id;
        }
        return tag.m_128461_(TAG_PATTERN_ID);
    }

    public CustomStructureSavedData getOrCreateData(ServerLevel level) {
        if (this.structureManager == null) {
            this.structureManager = (CustomStructureSavedData)level.m_7654_().m_129783_().m_8895_().m_164861_(tag -> {
                CustomStructureSavedData data = new CustomStructureSavedData();
                data.load((CompoundTag)tag);
                return data;
            }, CustomStructureSavedData::new, "mffs:custom_structures");
        }
        return this.structureManager;
    }

    public Map<Vec3, BlockState> getFieldBlocks(Projector projector, ItemStack stack) {
        Level level = projector.be().m_58904_();
        if (level instanceof ServerLevel) {
            String id;
            ServerLevel serverLevel = (ServerLevel)level;
            CompoundTag tag = stack.m_41784_();
            CustomStructureSavedData data = this.getOrCreateData(serverLevel);
            CustomStructureSavedData.Structure structure = data.get(id = tag.m_128461_(TAG_PATTERN_ID));
            if (structure != null) {
                return structure.getRealBlocks();
            }
        }
        return Map.of();
    }

    private static enum Mode {
        ADDITIVE,
        SUBTRACTIVE;

        private static final Mode[] VALUES;

        public Mode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public MutableComponent getName() {
            return ModUtil.translate("item", "custom_mode.mode." + this.name().toLowerCase(Locale.ROOT), new Object[0]);
        }

        static {
            VALUES = Mode.values();
        }
    }

    private class CustomProjectorModeCapability
    implements ICapabilityProvider,
    ProjectorMode {
        private final LazyOptional<ProjectorMode> optional = LazyOptional.of(() -> this);
        private final ItemStack stack;

        public CustomProjectorModeCapability(ItemStack stack) {
            this.stack = stack;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
            return ModCapabilities.PROJECTOR_MODE.orEmpty(cap, this.optional);
        }

        @Override
        public Set<Vec3> getExteriorPoints(Projector projector) {
            return CustomProjectorModeItem.this.getFieldBlocks(projector, this.stack).keySet();
        }

        @Override
        public Set<Vec3> getInteriorPoints(Projector projector) {
            return this.getExteriorPoints(projector);
        }

        @Override
        public boolean isInField(Projector projector, Vec3 position) {
            return false;
        }
    }
}

