/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import forge.net.mca.Config;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.util.network.datasync.CDataManager;
import forge.net.mca.util.network.datasync.CDataParameter;
import forge.net.mca.util.network.datasync.CEnumParameter;
import forge.net.mca.util.network.datasync.CParameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;

public class Genetics
implements Iterable<Gene> {
    private static final Set<GeneType> GENOMES = new HashSet<GeneType>();
    public static final GeneType SIZE = new GeneType("gene_size");
    public static final GeneType WIDTH = new GeneType("gene_width");
    public static final GeneType BREAST = new GeneType("gene_breast");
    public static final GeneType MELANIN = new GeneType("gene_melanin");
    public static final GeneType HEMOGLOBIN = new GeneType("gene_hemoglobin");
    public static final GeneType EUMELANIN = new GeneType("gene_eumelanin");
    public static final GeneType PHEOMELANIN = new GeneType("gene_pheomelanin");
    public static final GeneType SKIN = new GeneType("gene_skin");
    public static final GeneType FACE = new GeneType("gene_face");
    public static final GeneType VOICE = new GeneType("gene_voice");
    public static final GeneType VOICE_TONE = new GeneType("gene_voice_tone");
    private static final CEnumParameter<Gender> GENDER = CParameter.create("gender", Gender.UNASSIGNED);
    private RandomSource random = RandomSource.m_216327_();
    private final Map<GeneType, Gene> genes = new HashMap<GeneType, Gene>();
    private final VillagerLike<?> entity;

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        GENOMES.forEach(g -> builder.addAll(g.getParam()));
        return builder.addAll(GENDER);
    }

    public Genetics(VillagerLike<?> entity) {
        this.entity = entity;
    }

    public float getVerticalScaleFactor() {
        return 0.75f + this.getGene(SIZE) / 2.0f;
    }

    public float getHorizontalScaleFactor() {
        return 0.75f + this.getGene(WIDTH) / 2.0f;
    }

    public void setGender(Gender gender) {
        this.entity.setTrackedValue(GENDER, gender);
    }

    public Gender getGender() {
        return (Gender)((Object)this.entity.getTrackedValue(GENDER));
    }

    public float getBreastSize() {
        return this.getGender() == Gender.FEMALE ? this.getGene(BREAST) : 0.0f;
    }

    @Override
    public Iterator<Gene> iterator() {
        return this.genes.values().iterator();
    }

    public void setGene(GeneType type, float value) {
        this.getGenome(type).set(value);
    }

    public float getGene(GeneType type) {
        return this.getGenome(type).get();
    }

    public Gene getGenome(GeneType type) {
        return this.genes.computeIfAbsent(type, x$0 -> new Gene((GeneType)x$0));
    }

    public void randomize() {
        for (GeneType type : GENOMES) {
            this.getGenome(type).randomize();
        }
        this.setGene(SIZE, this.centeredRandom());
        this.setGene(WIDTH, this.centeredRandom());
        float temp = ((Biome)this.entity.asEntity().m_9236_().m_204166_(this.entity.asEntity().m_20183_()).m_203334_()).m_47554_();
        if (this.random.m_188501_() < Config.getInstance().geneticImmigrantChance) {
            temp = this.random.m_188501_() * 2.0f - 0.5f;
        }
        float height = this.entity.asEntity().m_20183_().m_123342_();
        height -= (float)this.entity.asEntity().m_9236_().m_5736_();
        this.setGene(MELANIN, Mth.m_14036_((float)(this.temperatureBaseRandom(temp) - (height /= 128.0f) * 0.2f), (float)0.0f, (float)1.0f));
        this.setGene(HEMOGLOBIN, Mth.m_14036_((float)(this.temperatureBaseRandom(temp) * 0.5f + height * 0.5f), (float)0.0f, (float)1.0f));
        this.setGene(EUMELANIN, this.random.m_188501_());
        this.setGene(PHEOMELANIN, this.random.m_188501_());
    }

    private float centeredRandom() {
        return Math.min(1.0f, Math.max(0.0f, (this.random.m_188501_() - 0.5f) * (this.random.m_188501_() - 0.5f) + 0.5f));
    }

    private float temperatureBaseRandom(float temp) {
        return (this.random.m_188501_() - 0.5f) * 0.35f + temp * 0.4f + 0.1f;
    }

    public void combine(Genetics mother, Genetics father) {
        for (GeneType type : GENOMES) {
            this.getGenome(type).mutate(mother, father);
        }
    }

    public void combine(Genetics mother, Genetics father, long seed) {
        RandomSource old = this.random;
        this.random = RandomSource.m_216335_((long)seed);
        this.combine(mother, father);
        this.random = old;
    }

    public static class GeneType
    implements Comparable<GeneType> {
        private final String key;
        private final CDataParameter<Float> parameter;

        public GeneType(String key) {
            this.key = key;
            this.parameter = CParameter.create(key, 0.5f);
            GENOMES.add(this);
        }

        public String key() {
            return this.key;
        }

        public String getTranslationKey() {
            return this.key().replace("_", ".");
        }

        public CDataParameter<Float> getParam() {
            return this.parameter;
        }

        @Override
        public int compareTo(GeneType o) {
            return this.key().compareTo(o.key());
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object o) {
            GeneType geneType;
            return o instanceof GeneType && (geneType = (GeneType)o).key().equals(this.key());
        }
    }

    public class Gene {
        private final GeneType type;

        public Gene(GeneType type) {
            this.type = type;
        }

        public GeneType getType() {
            return this.type;
        }

        public float get() {
            return ((Float)Genetics.this.entity.getTrackedValue(this.type.parameter)).floatValue();
        }

        public void set(float value) {
            Genetics.this.entity.setTrackedValue(this.type.parameter, Float.valueOf(value));
        }

        public void randomize() {
            this.set(Genetics.this.random.m_188501_());
        }

        public void mutate(Genetics mother, Genetics father) {
            float m = mother.getGene(this.type);
            float f = father.getGene(this.type);
            float interpolation = Genetics.this.random.m_188501_();
            float mutation = (Genetics.this.random.m_188501_() - 0.5f) * 0.2f;
            float g = m * interpolation + f * (1.0f - interpolation) + mutation;
            this.set((float)Math.min(1.0, Math.max(0.0, (double)g)));
        }
    }
}

