/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client.jei;

import commoble.morered.MoreRed;
import commoble.morered.soldering.SolderingRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class SolderingCategory
implements IRecipeCategory<Recipe<CraftingContainer>> {
    public static final RecipeType<Recipe<CraftingContainer>> TYPE = RecipeType.create((String)"morered", (String)"soldering", SolderingRecipe.class);
    public static final ResourceLocation JEI_RECIPE_TEXTURE = new ResourceLocation("jei", "textures/jei/gui/gui_vanilla.png");
    public static final String TITLE = "gui.morered.category.soldering";
    private final IDrawable background;
    private final IDrawable icon;

    public SolderingCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MoreRed.get().solderingTableBlock.get()));
        this.background = guiHelper.createDrawable(JEI_RECIPE_TEXTURE, 0, 60, 116, 54);
    }

    public RecipeType<Recipe<CraftingContainer>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)TITLE);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, Recipe<CraftingContainer> recipe, IFocusGroup focuses) {
        recipeLayout.setShapeless();
        recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 95, 19).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
        NonNullList ingredients = recipe.m_7527_();
        int ingredientCount = ingredients.size();
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                int inputID = row * 3 + column;
                IRecipeSlotBuilder slot = recipeLayout.addSlot(RecipeIngredientRole.INPUT, column * 18 + 1, row * 18 + 1);
                if (inputID >= ingredientCount) continue;
                slot.addIngredients((Ingredient)ingredients.get(inputID));
            }
        }
    }
}

