/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab;

import com.wuest.prefab.Prefab;
import com.wuest.prefab.proxy.messages.TagMessage;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import io.netty.util.internal.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.text.WordUtils;

public class Utils {
    public static String[] WrapString(String value) {
        return Utils.WrapString(value, 50);
    }

    public static String[] WrapString(String value, int width) {
        String result = WordUtils.wrap((String)value, (int)width);
        String[] results = result.split("\n");
        String[] returnValue = new String[results.length];
        for (int i = 0; i < results.length; ++i) {
            returnValue[i] = results[i].trim();
        }
        return returnValue;
    }

    public static ArrayList<MutableComponent> WrapStringToLiterals(String value) {
        return Utils.WrapStringToLiterals(value, 50);
    }

    public static MutableComponent createTextComponent(String value) {
        return Component.m_237113_((String)value);
    }

    public static ArrayList<MutableComponent> WrapStringToLiterals(String value, int width) {
        String[] values = Utils.WrapString(value, width);
        ArrayList<MutableComponent> returnValue = new ArrayList<MutableComponent>();
        for (String stringValue : values) {
            returnValue.add(Utils.createTextComponent(stringValue));
        }
        return returnValue;
    }

    public static TagMessage createMessage(CompoundTag tag) {
        return new TagMessage(tag);
    }

    public static <T extends TagMessage> T createGenericMessage(CompoundTag tag, Class<T> tClass) {
        try {
            return (T)((TagMessage)tClass.getConstructor(CompoundTag.class).newInstance(tag));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static StructureTagMessage createStructureMessage(CompoundTag tag, StructureTagMessage.EnumStructureConfiguration structureConfiguration) {
        return new StructureTagMessage(tag, structureConfiguration);
    }

    public static Direction getDirectionByName(String name) {
        if (!StringUtil.isNullOrEmpty((String)name)) {
            for (Direction direction : Direction.values()) {
                if (!direction.m_7912_().equalsIgnoreCase(name)) continue;
                return direction;
            }
        }
        return Direction.NORTH;
    }

    public static ArrayList<Block> getBlocksWithTagLocation(ResourceLocation resourceLocation) {
        TagKey tags = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)resourceLocation);
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Holder blockHolder : BuiltInRegistries.f_256975_.m_206058_(tags)) {
            blocks.add((Block)blockHolder.m_203334_());
        }
        return blocks;
    }

    public static ArrayList<Block> getBlocksWithTagKey(TagKey<Block> tagKey) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Holder blockHolder : BuiltInRegistries.f_256975_.m_206058_(tagKey)) {
            blocks.add((Block)blockHolder.m_203334_());
        }
        return blocks;
    }

    public static boolean doesBlockHaveTag(Block block, ResourceLocation location) {
        ResourceLocation blockKey = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        TagKey tags = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)location);
        for (Holder blockHolder : BuiltInRegistries.f_256975_.m_206058_(tags)) {
            if (!blockHolder.m_203373_(blockKey)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesBlockStateHaveTag(BlockState blockState, ResourceLocation location) {
        for (TagKey tagKey : blockState.m_204343_().toList()) {
            if (!tagKey.f_203868_().toString().equalsIgnoreCase(location.toString())) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<ItemStack> getItemStacksWithTag(ResourceLocation resourceLocation) {
        TagKey tags = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)resourceLocation);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(tags)) {
            itemStacks.add(new ItemStack((ItemLike)holder.m_203334_()));
        }
        return itemStacks;
    }

    public static boolean doesItemHaveTag(Item item, ResourceLocation location) {
        ResourceLocation blockKey = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        TagKey tags = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)location);
        for (Holder blockHolder : BuiltInRegistries.f_257033_.m_206058_(tags)) {
            if (!blockHolder.m_203373_(blockKey)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesItemStackHaveTag(ItemStack itemStack, ResourceLocation location) {
        for (TagKey tagKey : itemStack.m_204131_().toList()) {
            if (!tagKey.f_203868_().toString().equalsIgnoreCase(location.toString())) continue;
            return true;
        }
        return false;
    }

    public static BlockState readBlockState(CompoundTag tag) {
        if (!tag.m_128425_("Name", 8)) {
            return Blocks.f_50016_.m_49966_();
        }
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(tag.m_128461_("Name")));
        BlockState blockState = block.m_49966_();
        if (tag.m_128425_("Properties", 10)) {
            CompoundTag compoundTag = tag.m_128469_("Properties");
            StateDefinition stateDefinition = block.m_49965_();
            for (String s : compoundTag.m_128431_()) {
                Property property = stateDefinition.m_61081_(s);
                if (property == null) continue;
                blockState = Utils.setValueHelper(blockState, property, s, compoundTag, tag);
            }
        }
        return blockState;
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S blockState, Property<T> property, String tagKey, CompoundTag compoundTag, CompoundTag originalTag) {
        Optional optional = property.m_6215_(compoundTag.m_128461_(tagKey));
        if (optional.isPresent()) {
            return (S)((StateHolder)blockState.m_61124_(property, (Comparable)optional.get()));
        }
        Prefab.LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", (Object)tagKey, (Object)compoundTag.m_128461_(tagKey), (Object)originalTag.toString());
        return blockState;
    }
}

