/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class ConditionedShapedRecipe
extends ShapedRecipe {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    final ResourceLocation resourceLocation;
    final int width;
    final int height;
    final CraftingBookCategory craftingBookCategory;
    final NonNullList<Ingredient> inputs;
    final String group;
    final String configName;
    final boolean recipeHasTags;
    ItemStack output;
    boolean reloadedTags;
    boolean showNotification;

    public ConditionedShapedRecipe(ResourceLocation resourceLocation, String group, CraftingBookCategory craftingBookCategory, int width, int height, NonNullList<Ingredient> ingredients, ItemStack output, String configName, boolean recipeHasTags, boolean showNotification) {
        super(resourceLocation, group, craftingBookCategory, width, height, ingredients, output, showNotification);
        this.resourceLocation = resourceLocation;
        this.group = group;
        this.craftingBookCategory = craftingBookCategory;
        this.width = width;
        this.height = height;
        this.inputs = ingredients;
        this.output = output;
        this.configName = configName;
        this.recipeHasTags = recipeHasTags;
        this.reloadedTags = false;
        this.showNotification = showNotification;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistry.ConditionedShapedRecipeSeriaizer.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public CraftingBookCategory m_245232_() {
        return this.craftingBookCategory;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public boolean m_271738_() {
        return this.showNotification;
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public boolean m_5818_(CraftingContainer craftingInventory, Level level) {
        if (this.recipeHasTags && !this.reloadedTags) {
            this.validateTagIngredients();
            this.reloadedTags = true;
        }
        for (int i = 0; i <= craftingInventory.m_39347_() - this.width; ++i) {
            for (int j = 0; j <= craftingInventory.m_39346_() - this.height; ++j) {
                if (this.m_44170_(craftingInventory, i, j, true)) {
                    return true;
                }
                if (!this.m_44170_(craftingInventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack m_5874_(CraftingContainer craftingContainer, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess).m_41777_();
    }

    public int m_44220_() {
        return this.width;
    }

    public int m_44221_() {
        return this.height;
    }

    private boolean m_44170_(CraftingContainer inv, int offsetX, int offsetY, boolean bl) {
        for (int i = 0; i < inv.m_39347_(); ++i) {
            for (int j = 0; j < inv.m_39346_(); ++j) {
                int k = i - offsetX;
                int l = j - offsetY;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = bl ? (Ingredient)this.inputs.get(this.width - k - 1 + l * this.width) : (Ingredient)this.inputs.get(k + l * this.width);
                }
                if (ingredient.test(inv.m_8020_(i + j * inv.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    private void validateTagIngredients() {
        boolean invalidRecipe = false;
        for (Ingredient ingredient : this.m_7527_()) {
            if (ingredient.m_43908_().length != 0) continue;
            ingredient.f_43903_ = (ItemStack[])Arrays.stream(ingredient.f_43902_).flatMap(value -> value.m_6223_().stream()).distinct().toArray(ItemStack[]::new);
            if (ingredient.f_43903_.length != 0) continue;
            invalidRecipe = true;
            break;
        }
        this.output = invalidRecipe ? ItemStack.f_41583_ : Serializer.validateRecipeOutput(this.output, this.configName);
    }

    static NonNullList<Ingredient> m_44202_(String[] p_44203_, Map<String, Ingredient> p_44204_, int p_44205_, int p_44206_) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)(p_44205_ * p_44206_), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(p_44204_.keySet());
        set.remove(" ");
        for (int i = 0; i < p_44203_.length; ++i) {
            for (int j = 0; j < p_44203_[i].length(); ++j) {
                String s = p_44203_[i].substring(j, j + 1);
                Ingredient ingredient = p_44204_.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + p_44205_ * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] m_44186_(String ... p_44187_) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < p_44187_.length; ++i1) {
            String s = p_44187_[i1];
            i = Math.min(i, ConditionedShapedRecipe.m_44184_(s));
            int j1 = ConditionedShapedRecipe.m_44200_(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (p_44187_.length == l) {
            return new String[0];
        }
        String[] astring = new String[p_44187_.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = p_44187_[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int m_44184_(String p_44185_) {
        int i;
        for (i = 0; i < p_44185_.length() && p_44185_.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int m_44200_(String p_44201_) {
        int i;
        for (i = p_44201_.length() - 1; i >= 0 && p_44201_.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static String[] m_44196_(JsonArray p_44197_) {
        String[] astring = new String[p_44197_.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)p_44197_.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    static Map<String, Ingredient> m_44210_(JsonObject p_44211_) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : p_44211_.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_288218_((JsonElement)((JsonElement)entry.getValue()), (boolean)false));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    public static class Serializer
    implements RecipeSerializer<ConditionedShapedRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("prefab", "crafting_shaped");

        public ConditionedShapedRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            String s = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)jsonObject, (String)"category", (String)null), (Enum)CraftingBookCategory.MISC);
            Map<String, Ingredient> map = ConditionedShapedRecipe.m_44210_(GsonHelper.m_13930_((JsonObject)jsonObject, (String)"key"));
            String[] astring = ConditionedShapedRecipe.m_44186_(ConditionedShapedRecipe.m_44196_(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList<Ingredient> nonnulllist = ConditionedShapedRecipe.m_44202_(astring, map, i, j);
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            String configName = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"configName");
            itemstack = Serializer.validateRecipeOutput(itemstack, configName);
            boolean recipeHasTags = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"recipe_has_tags", (boolean)false);
            boolean flag = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"show_notification", (boolean)true);
            return new ConditionedShapedRecipe(resourceLocation, s, craftingbookcategory, i, j, nonnulllist, itemstack, configName, recipeHasTags, flag);
        }

        public static ItemStack validateRecipeOutput(ItemStack originalOutput, String configName) {
            if (originalOutput == ItemStack.f_41583_) {
                return ItemStack.f_41583_;
            }
            if (!Strings.isNullOrEmpty((String)configName) && Prefab.proxy.getServerConfiguration().recipeConfiguration.containsKey(configName) && !Prefab.proxy.getServerConfiguration().recipeConfiguration.get(configName).booleanValue()) {
                return ItemStack.f_41583_;
            }
            return originalOutput;
        }

        public ConditionedShapedRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            int width = friendlyByteBuf.m_130242_();
            int height = friendlyByteBuf.m_130242_();
            String groupName = friendlyByteBuf.m_130277_();
            String configName = friendlyByteBuf.m_130277_();
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)friendlyByteBuf.m_130066_(CraftingBookCategory.class);
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf));
            ItemStack itemStack = Serializer.validateRecipeOutput(friendlyByteBuf.m_130267_(), configName);
            boolean recipeHasTags = friendlyByteBuf.readBoolean();
            boolean showNotification = friendlyByteBuf.readBoolean();
            return new ConditionedShapedRecipe(resourceLocation, groupName, craftingBookCategory, width, height, (NonNullList<Ingredient>)ingredients, itemStack, configName, recipeHasTags, showNotification);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, ConditionedShapedRecipe shapedRecipe) {
            friendlyByteBuf.m_130130_(shapedRecipe.width);
            friendlyByteBuf.m_130130_(shapedRecipe.height);
            friendlyByteBuf.m_130070_(shapedRecipe.group);
            friendlyByteBuf.m_130070_(shapedRecipe.configName);
            friendlyByteBuf.m_130068_((Enum)shapedRecipe.craftingBookCategory);
            for (Ingredient ingredient : shapedRecipe.inputs) {
                ingredient.m_43923_(friendlyByteBuf);
            }
            friendlyByteBuf.m_130055_(shapedRecipe.output);
            friendlyByteBuf.writeBoolean(shapedRecipe.recipeHasTags);
            friendlyByteBuf.writeBoolean(shapedRecipe.showNotification);
        }
    }
}

