/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.proxy;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.base.BaseConfig;
import com.wuest.prefab.blocks.BlockCustomWall;
import com.wuest.prefab.blocks.BlockGrassSlab;
import com.wuest.prefab.blocks.BlockGrassStairs;
import com.wuest.prefab.config.ServerModConfiguration;
import com.wuest.prefab.config.StructureScannerConfig;
import com.wuest.prefab.gui.GuiPrefab;
import com.wuest.prefab.gui.screens.GuiStructureScanner;
import com.wuest.prefab.proxy.CommonProxy;
import com.wuest.prefab.structures.gui.GuiStructure;
import com.wuest.prefab.structures.items.StructureItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;

public class ClientProxy
extends CommonProxy {
    public static HashMap<StructureItem, GuiStructure> ModGuis = new HashMap();
    public ServerModConfiguration serverConfiguration = null;
    public static final RenderType PREVIEW_LAYER = new PreviewLayer();

    public ClientProxy() {
        this.isClient = true;
    }

    public static void AddGuis() {
        for (Consumer<Object> consumer : ModRegistry.guiRegistrations) {
            consumer.accept(null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void RegisterBlockRenderer() {
        Minecraft.m_91087_().m_91298_().m_92589_((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)worldIn, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0), new Block[]{(Block)ModRegistry.GrassWall.get(), (Block)ModRegistry.GrassSlab.get(), (Block)ModRegistry.GrassStairs.get()});
        Minecraft.m_91087_().getItemColors().m_92689_((stack, tintIndex) -> {
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem itemBlock = (BlockItem)item;
                boolean paintBlock = false;
                if (itemBlock.m_40614_() instanceof BlockCustomWall) {
                    BlockCustomWall customWall = (BlockCustomWall)itemBlock.m_40614_();
                    if (customWall.BlockVariant == BlockCustomWall.EnumType.GRASS) {
                        paintBlock = true;
                    }
                } else if (itemBlock.m_40614_() instanceof BlockGrassSlab) {
                    paintBlock = true;
                } else if (itemBlock.m_40614_() instanceof BlockGrassStairs) {
                    paintBlock = true;
                }
                if (paintBlock) {
                    BlockPos pos = Minecraft.m_91087_().f_91074_.m_20183_();
                    ClientLevel world = Minecraft.m_91087_().f_91073_;
                    return BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos);
                }
            }
            return -1;
        }, (ItemLike[])new Block[]{(Block)ModRegistry.GrassWall.get(), (Block)ModRegistry.GrassSlab.get(), (Block)ModRegistry.GrassStairs.get()});
    }

    @Override
    public void preInit(ParallelDispatchEvent event) {
        ClientProxy.AddGuis();
    }

    @Override
    public void init(ParallelDispatchEvent event) {
        super.init(event);
        Prefab.proxy.registerRenderers();
        ClientProxy.RegisterBlockRenderer();
        ClientProxy.AddGuis();
    }

    @Override
    public void postinit(ParallelDispatchEvent event) {
        super.postinit(event);
    }

    @Override
    public void RegisterEventHandler() {
        Optional modContainer = ModList.get().getModContainerById("prefab");
        if (modContainer != null && modContainer.isPresent()) {
            ((ModContainer)modContainer.get()).registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> new GuiPrefab((Minecraft)minecraft, (Screen)screen)));
        }
    }

    @Override
    public void registerRenderers() {
    }

    @Override
    public ServerModConfiguration getServerConfiguration() {
        if (this.serverConfiguration == null) {
            return CommonProxy.proxyConfiguration.serverConfiguration;
        }
        return this.serverConfiguration;
    }

    @Override
    public void openGuiForItem(UseOnContext itemUseContext) {
        for (Map.Entry<StructureItem, GuiStructure> entry : ModGuis.entrySet()) {
            if (entry.getKey() != itemUseContext.m_43722_().m_41720_()) continue;
            GuiStructure screen = entry.getValue();
            screen.pos = itemUseContext.m_8083_();
            Minecraft.m_91087_().m_91152_((Screen)screen);
        }
    }

    @Override
    public void openGuiForBlock(BlockPos blockPos, Level world, BaseConfig config) {
        GuiStructureScanner screen = null;
        if (config instanceof StructureScannerConfig) {
            screen = new GuiStructureScanner(blockPos, world, (StructureScannerConfig)config);
        }
        if (screen != null) {
            Minecraft.m_91087_().m_91152_(screen);
        }
    }

    @Override
    public void clientSetup(FMLClientSetupEvent clientSetupEvent) {
    }

    private static class PreviewLayer
    extends RenderType {
        public PreviewLayer() {
            super("prefab.preview", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, true, () -> {
                Sheets.m_110792_().m_110185_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            }, () -> {
                Sheets.m_110792_().m_110188_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            });
        }
    }
}

