/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.gui;

import com.wuest.prefab.Prefab;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.config.ServerModConfiguration;
import com.wuest.prefab.events.ClientEventHandler;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.ExtendedButton;
import com.wuest.prefab.gui.controls.GuiCheckBox;
import com.wuest.prefab.structures.config.HouseImprovedConfiguration;
import com.wuest.prefab.structures.gui.GuiStructure;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.predefined.StructureHouseImproved;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;

public class GuiHouseImproved
extends GuiStructure {
    protected HouseImprovedConfiguration specificConfiguration;
    protected ServerModConfiguration serverConfiguration;
    private ExtendedButton btnHouseStyle;
    private GuiCheckBox btnAddChest;
    private GuiCheckBox btnAddChestContents;
    private GuiCheckBox btnAddMineShaft;
    private ExtendedButton btnBedColor;
    private boolean allowItemsInChestAndFurnace = true;
    private ArrayList<HouseImprovedConfiguration.HouseStyle> availableHouseStyles;

    public GuiHouseImproved() {
        super("Moderate House");
        this.configurationEnum = StructureTagMessage.EnumStructureConfiguration.ModerateHouse;
    }

    public Component m_142562_() {
        return Component.m_237115_((String)GuiLangKeys.translateString("item.prefab.item_moderate_house"));
    }

    @Override
    protected void Initialize() {
        this.modifiedInitialXAxis = 215;
        this.modifiedInitialYAxis = 117;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
        if (!Minecraft.m_91087_().f_91074_.m_7500_()) {
            this.allowItemsInChestAndFurnace = !ClientEventHandler.playerConfig.builtStarterHouse;
        }
        this.serverConfiguration = Prefab.proxy.getServerConfiguration();
        this.specificConfiguration = ClientEventHandler.playerConfig.getClientConfig("Moderate Houses", HouseImprovedConfiguration.class);
        this.configuration = this.specificConfiguration;
        this.configuration.pos = this.pos;
        this.availableHouseStyles = new ArrayList();
        HashMap<String, Boolean> houseConfigurationSettings = this.serverConfiguration.structureOptions.get("item.prefab.item_house_improved");
        boolean selectedStyleInListOfAvailable = false;
        for (HouseImprovedConfiguration.HouseStyle style : HouseImprovedConfiguration.HouseStyle.values()) {
            if (!houseConfigurationSettings.containsKey(style.getTranslationKey()) || !houseConfigurationSettings.get(style.getTranslationKey()).booleanValue()) continue;
            this.availableHouseStyles.add(style);
            if (!this.specificConfiguration.houseStyle.getDisplayName().equals(style.getDisplayName())) continue;
            selectedStyleInListOfAvailable = true;
        }
        if (this.availableHouseStyles.size() == 0) {
            this.showNoOptionsScreen();
            return;
        }
        if (!selectedStyleInListOfAvailable) {
            this.specificConfiguration.houseStyle = this.availableHouseStyles.get(0);
        }
        this.selectedStructure = StructureHouseImproved.CreateInstance(this.specificConfiguration.houseStyle.getStructureLocation(), StructureHouseImproved.class);
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        int yOffset = 25;
        if (this.availableHouseStyles.size() > 1) {
            this.btnHouseStyle = this.createAndAddButton(grayBoxX + 8, grayBoxY + yOffset, 90, 20, this.specificConfiguration.houseStyle.getDisplayName(), false, GuiLangKeys.translateString("prefab.gui.house.style.label"));
            yOffset += 35;
        }
        this.btnBedColor = this.createAndAddDyeButton(grayBoxX + 8, grayBoxY + yOffset, 90, 20, this.specificConfiguration.bedColor, GuiLangKeys.translateString("prefab.gui.structure.bed_color"));
        this.btnAddChest = this.createAndAddCheckBox(grayBoxX + 8, grayBoxY + (yOffset += 60), "prefab.gui.house.addchest", this.specificConfiguration.addChests, this::buttonClicked);
        this.btnAddMineShaft = this.createAndAddCheckBox(grayBoxX + 8, grayBoxY + (yOffset += 17), "prefab.gui.house.buildmineshaft", this.specificConfiguration.addMineshaft, this::buttonClicked);
        this.btnAddChestContents = this.createAndAddCheckBox(grayBoxX + 8, grayBoxY + (yOffset += 17), "prefab.gui.house.addchestcontents", this.specificConfiguration.addChestContents, this::buttonClicked);
        this.btnVisualize = this.createAndAddCustomButton(grayBoxX + 24, grayBoxY + 177, 90, 20, "prefab.gui.button.preview");
        this.btnBuild = this.createAndAddCustomButton(grayBoxX + 310, grayBoxY + 177, 90, 20, "prefab.gui.button.build");
        this.btnCancel = this.createAndAddButton(grayBoxX + 154, grayBoxY + 177, 90, 20, "prefab.gui.button.cancel");
    }

    @Override
    protected void preButtonRender(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int imagePanelUpperLeft = x + 136;
        int imagePanelWidth = 285;
        int imagePanelMiddle = imagePanelWidth / 2;
        this.m_280273_(guiGraphics);
        this.drawControlLeftPanel(guiGraphics, x + 2, y + 10, 135, 190);
        this.drawControlRightPanel(guiGraphics, imagePanelUpperLeft, y + 10, imagePanelWidth, 190);
        int middleOfImage = this.shownImageWidth / 2;
        int imageLocation = imagePanelUpperLeft + (imagePanelMiddle - middleOfImage);
        GuiUtils.bindAndDrawScaledTexture(this.specificConfiguration.houseStyle.getHousePicture(), guiGraphics, imageLocation, y + 15, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight);
        this.btnAddChest.f_93624_ = this.serverConfiguration.addChests;
        this.btnAddChestContents.f_93624_ = this.allowItemsInChestAndFurnace && this.serverConfiguration.addChestContents;
        this.btnAddMineShaft.f_93624_ = this.serverConfiguration.addMineshaft;
    }

    @Override
    protected void postButtonRender(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int yOffSet = 15;
        if (this.availableHouseStyles.size() > 1) {
            this.drawString(guiGraphics, GuiLangKeys.translateString("prefab.gui.house.style.label"), x + 8, y + yOffSet, this.textColor);
            yOffSet += 35;
        }
        this.drawString(guiGraphics, GuiLangKeys.translateString("prefab.gui.structure.bed_color"), x + 8, y + yOffSet, this.textColor);
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.specificConfiguration.addChests = this.btnAddChest.f_93624_ && this.btnAddChest.isChecked();
        this.specificConfiguration.addChestContents = this.allowItemsInChestAndFurnace && this.btnAddChestContents.f_93624_ && this.btnAddChestContents.isChecked();
        this.specificConfiguration.addMineshaft = this.btnAddMineShaft.f_93624_ && this.btnAddMineShaft.isChecked();
        this.configuration.houseFacing = this.getMinecraft().f_91074_.m_6350_().m_122424_();
        this.performCancelOrBuildOrHouseFacing(button);
        if (button == this.btnHouseStyle) {
            for (int i = 0; i < this.availableHouseStyles.size(); ++i) {
                HouseImprovedConfiguration.HouseStyle option = this.availableHouseStyles.get(i);
                HouseImprovedConfiguration.HouseStyle chosenOption = null;
                if (this.specificConfiguration.houseStyle.getDisplayName().equals(option.getDisplayName())) {
                    chosenOption = i == this.availableHouseStyles.size() - 1 ? this.availableHouseStyles.get(0) : this.availableHouseStyles.get(i + 1);
                }
                if (chosenOption == null) continue;
                this.specificConfiguration.houseStyle = chosenOption;
                this.selectedStructure = StructureHouseImproved.CreateInstance(this.specificConfiguration.houseStyle.getStructureLocation(), StructureHouseImproved.class);
                GuiUtils.setButtonText(this.btnHouseStyle, this.specificConfiguration.houseStyle.getDisplayName());
                break;
            }
        } else if (button == this.btnVisualize) {
            this.performPreview();
        } else if (button == this.btnBedColor) {
            this.specificConfiguration.bedColor = DyeColor.m_41053_((int)(this.specificConfiguration.bedColor.m_41060_() + 1));
            GuiUtils.setButtonText(this.btnBedColor, GuiLangKeys.translateDye(this.specificConfiguration.bedColor));
        }
    }
}

