/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.commandscreen;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.client.gui.CommandScreen;
import com.talhanation.recruits.client.gui.commandscreen.ICommandCategory;
import com.talhanation.recruits.client.gui.group.RecruitsCommandButton;
import com.talhanation.recruits.client.gui.group.RecruitsGroup;
import com.talhanation.recruits.client.gui.team.TeamMainScreen;
import com.talhanation.recruits.network.MessageBackToMountEntity;
import com.talhanation.recruits.network.MessageClearUpkeep;
import com.talhanation.recruits.network.MessageDismount;
import com.talhanation.recruits.network.MessageMountEntity;
import com.talhanation.recruits.network.MessageMovement;
import com.talhanation.recruits.network.MessageProtectEntity;
import com.talhanation.recruits.network.MessageRest;
import com.talhanation.recruits.network.MessageUpkeepEntity;
import com.talhanation.recruits.network.MessageUpkeepPos;
import java.util.List;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class OtherCategory
implements ICommandCategory {
    private static final MutableComponent TOOLTIP_CLEAR_UPKEEP = Component.m_237115_((String)"gui.recruits.command.tooltip.clear_upkeep");
    private static final MutableComponent TEXT_CLEAR_UPKEEP = Component.m_237115_((String)"gui.recruits.command.text.clear_upkeep");
    private static final MutableComponent TEXT_BACK_TO_MOUNT = Component.m_237115_((String)"gui.recruits.command.text.backToMount");
    private static final MutableComponent TEXT_UPKEEP = Component.m_237115_((String)"gui.recruits.command.text.upkeep");
    private static final MutableComponent TEXT_REST = Component.m_237115_((String)"gui.recruits.command.text.rest");
    private static final MutableComponent TEXT_TEAM = Component.m_237115_((String)"gui.recruits.command.text.team");
    private static final MutableComponent TOOLTIP_BACK_TO_MOUNT = Component.m_237115_((String)"gui.recruits.command.tooltip.backToMount");
    private static final MutableComponent TOOLTIP_UPKEEP = Component.m_237115_((String)"gui.recruits.command.tooltip.upkeep");
    private static final MutableComponent TOOLTIP_REST = Component.m_237115_((String)"gui.recruits.command.tooltip.rest");
    private static final MutableComponent TOOLTIP_TEAM = Component.m_237115_((String)"gui.recruits.command.tooltip.team");
    private static final MutableComponent TEXT_DISMOUNT = Component.m_237115_((String)"gui.recruits.command.text.dismount");
    private static final MutableComponent TEXT_MOUNT = Component.m_237115_((String)"gui.recruits.command.text.mount");
    private static final MutableComponent TOOLTIP_DISMOUNT = Component.m_237115_((String)"gui.recruits.command.tooltip.dismount");
    private static final MutableComponent TOOLTIP_MOUNT = Component.m_237115_((String)"gui.recruits.command.tooltip.mount");
    private static final MutableComponent TOOLTIP_PROTECT = Component.m_237115_((String)"gui.recruits.command.tooltip.protect");
    private static final MutableComponent TEXT_PROTECT = Component.m_237115_((String)"gui.recruits.command.text.protect");
    private static final MutableComponent TOOLTIP_OTHER = Component.m_237115_((String)"gui.recruits.command.tooltip.other");

    @Override
    public Component getToolTipName() {
        return TOOLTIP_OTHER;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)Items.f_42009_);
    }

    @Override
    public void createButtons(CommandScreen screen, int x, int y, List<RecruitsGroup> groups, Player player) {
        boolean isOneGroupActive = groups.stream().anyMatch(g -> !g.isDisabled());
        RecruitsCommandButton protectButton = new RecruitsCommandButton(x, y - 25, (Component)TEXT_PROTECT, button -> {
            if (screen.rayEntity != null && !groups.isEmpty()) {
                for (RecruitsGroup group : groups) {
                    if (group.isDisabled()) continue;
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageProtectEntity(player.m_20148_(), screen.rayEntity.m_20148_(), group.getId()));
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMovement(player.m_20148_(), 5, CommandScreen.formation.getIndex(), group.getId()));
                }
                screen.sendCommandInChat(5);
            }
        });
        protectButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_PROTECT));
        protectButton.f_93623_ = isOneGroupActive && screen.rayEntity != null;
        screen.m_142416_(protectButton);
        RecruitsCommandButton mountButton = new RecruitsCommandButton(x, y + 25, (Component)TEXT_MOUNT, button -> {
            if (screen.rayEntity != null && !groups.isEmpty()) {
                for (RecruitsGroup group : groups) {
                    if (group.isDisabled()) continue;
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMountEntity(player.m_20148_(), screen.rayEntity.m_20148_(), group.getId()));
                }
                screen.sendCommandInChat(99);
            }
        });
        mountButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_MOUNT));
        mountButton.f_93623_ = isOneGroupActive && screen.rayEntity != null;
        screen.m_142416_(mountButton);
        RecruitsCommandButton factionButton = new RecruitsCommandButton(x - 60, y + 50, (Component)TEXT_TEAM, button -> screen.getMinecraft().m_91152_((Screen)new TeamMainScreen(player)));
        factionButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_TEAM));
        screen.m_142416_(factionButton);
        RecruitsCommandButton backToMountButton = new RecruitsCommandButton(x + 100, y + 25, (Component)TEXT_BACK_TO_MOUNT, button -> {
            if (!groups.isEmpty()) {
                for (RecruitsGroup group : groups) {
                    if (group.isDisabled()) continue;
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageBackToMountEntity(player.m_20148_(), group.getId()));
                }
                screen.sendCommandInChat(91);
            }
        });
        backToMountButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_BACK_TO_MOUNT));
        backToMountButton.f_93623_ = isOneGroupActive;
        screen.m_142416_(backToMountButton);
        RecruitsCommandButton dismountButton = new RecruitsCommandButton(x - 100, y + 25, (Component)TEXT_DISMOUNT, button -> {
            if (!groups.isEmpty()) {
                for (RecruitsGroup group : groups) {
                    if (group.isDisabled()) continue;
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDismount(player.m_20148_(), group.getId()));
                }
                screen.sendCommandInChat(98);
            }
        });
        dismountButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_DISMOUNT));
        dismountButton.f_93623_ = isOneGroupActive;
        screen.m_142416_(dismountButton);
        RecruitsCommandButton upkeepButton = new RecruitsCommandButton(x + 100, y, (Component)TEXT_UPKEEP, button -> {
            if (!groups.isEmpty()) {
                for (RecruitsGroup group : groups) {
                    if (!group.isDisabled() && screen.rayEntity != null) {
                        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageUpkeepEntity(player.m_20148_(), screen.rayEntity.m_20148_(), group.getId()));
                        continue;
                    }
                    if (group.isDisabled() || screen.rayBlockPos == null) continue;
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageUpkeepPos(player.m_20148_(), group.getId(), screen.rayBlockPos));
                }
                screen.sendCommandInChat(92);
            }
        });
        upkeepButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_UPKEEP));
        upkeepButton.f_93623_ = isOneGroupActive && (this.isUpkeepPosition(screen.rayBlockPos, player) || this.isUpkeepEntity(screen.rayEntity));
        screen.m_142416_(upkeepButton);
        RecruitsCommandButton clearUpkeepButton = new RecruitsCommandButton(x + 60, y + 50, (Component)TEXT_CLEAR_UPKEEP, button -> {
            if (!groups.isEmpty()) {
                for (RecruitsGroup group : groups) {
                    if (group.isDisabled()) continue;
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageClearUpkeep(player.m_20148_(), group.getId()));
                }
                screen.sendCommandInChat(93);
            }
        });
        clearUpkeepButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_CLEAR_UPKEEP));
        clearUpkeepButton.f_93623_ = isOneGroupActive;
        screen.m_142416_(clearUpkeepButton);
        RecruitsCommandButton restButton = new RecruitsCommandButton(x - 100, y, (Component)TEXT_REST, button -> {
            if (!groups.isEmpty()) {
                for (RecruitsGroup group : groups) {
                    if (group.isDisabled()) continue;
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageRest(player.m_20148_(), group.getId(), true));
                }
                screen.sendCommandInChat(88);
            }
        });
        restButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_REST));
        restButton.f_93623_ = isOneGroupActive;
        screen.m_142416_(restButton);
    }

    private boolean isUpkeepPosition(BlockPos rayBlockPos, Player player) {
        if (rayBlockPos == null) {
            return false;
        }
        BlockEntity entity = player.m_20193_().m_7702_(rayBlockPos);
        BlockState blockState = player.m_20193_().m_8055_(rayBlockPos);
        return entity instanceof Container || blockState.m_60734_() instanceof ChestBlock;
    }

    private boolean isUpkeepEntity(Entity rayEntity) {
        if (rayEntity == null) {
            return false;
        }
        return rayEntity instanceof Container || rayEntity instanceof InventoryCarrier || rayEntity instanceof AbstractHorse;
    }
}

