/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.team;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.TeamEvents;
import com.talhanation.recruits.client.gui.component.BannerRenderer;
import com.talhanation.recruits.client.gui.diplomacy.DiplomacyTeamListScreen;
import com.talhanation.recruits.client.gui.player.IPlayerSelection;
import com.talhanation.recruits.client.gui.player.PlayersList;
import com.talhanation.recruits.client.gui.player.RecruitsPlayerEntry;
import com.talhanation.recruits.client.gui.player.SelectPlayerScreen;
import com.talhanation.recruits.client.gui.team.TeamEditScreen;
import com.talhanation.recruits.client.gui.team.TeamMainScreen;
import com.talhanation.recruits.client.gui.team.TeamManageScreen;
import com.talhanation.recruits.client.gui.widgets.ListScreenBase;
import com.talhanation.recruits.client.gui.widgets.ListScreenListBase;
import com.talhanation.recruits.client.gui.widgets.SelectedPlayerWidget;
import com.talhanation.recruits.network.MessageLeaveTeam;
import com.talhanation.recruits.network.MessageSaveTeamSettings;
import com.talhanation.recruits.network.MessageToServerRequestUpdateTeamInspaction;
import com.talhanation.recruits.world.RecruitsPlayerInfo;
import com.talhanation.recruits.world.RecruitsTeam;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class TeamInspectionScreen
extends ListScreenBase
implements IPlayerSelection {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("recruits", "textures/gui/team/team_inspect.png");
    protected static final ResourceLocation LEADER_CROWN = new ResourceLocation("recruits", "textures/gui/image/leader_crown.png");
    private static final Component LEAVE_BUTTON = Component.m_237115_((String)"gui.recruits.team.leave");
    private static final Component DELETE_BUTTON = Component.m_237115_((String)"gui.recruits.team.delete_team");
    private static final Component DIPLOMACY_BUTTON = Component.m_237115_((String)"gui.recruits.team.diplomacy");
    private static final Component EDIT_BUTTON = Component.m_237115_((String)"gui.recruits.team.edit");
    private static final Component MANAGE_BUTTON = Component.m_237115_((String)"gui.recruits.team.manage");
    private static final Component BACK_BUTTON = Component.m_237115_((String)"gui.recruits.button.back");
    private static final Component MEMBERS_TEXT = Component.m_237115_((String)"gui.recruits.team.members");
    private static final Component PLAYERS_TEXT = Component.m_237115_((String)"gui.recruits.team.players");
    private static final Component NPCS_TEXT = Component.m_237115_((String)"gui.recruits.team.npcs");
    private static final Component LEADER_TEXT = Component.m_237115_((String)"gui.recruits.team.leader");
    private static final Component SELECT_LEADER = Component.m_237115_((String)"gui.recruits.team.select_leader");
    private static final Component SELECT_LEADER_TOOLTIP = Component.m_237115_((String)"gui.recruits.team.select_leader_tooltip_leaving");
    protected static final int HEADER_SIZE = 130;
    protected static final int FOOTER_SIZE = 32;
    protected static final int SEARCH_HEIGHT = 0;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 32;
    protected PlayersList playerList;
    protected int units;
    protected Screen parent;
    public RecruitsPlayerInfo selected;
    private Button backButton;
    private Button manageButton;
    private Button editButton;
    private Button diplomacyButton;
    private Button leaveButton;
    private final Player player;
    public static RecruitsTeam recruitsTeam;
    private BannerRenderer bannerRenderer;
    private SelectedPlayerWidget selectedPlayerWidget;
    private boolean postInit;
    private int gapBottom;
    private int gapTop;
    public static boolean isEditingAllowed;
    public static boolean isManagingAllowed;
    int x1 = 25;
    int y1 = 80;

    public TeamInspectionScreen(Screen parent, Player player) {
        super((Component)Component.m_237113_((String)"TeamInspection"), 236, 0);
        this.parent = parent;
        this.player = player;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.postInit = false;
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageToServerRequestUpdateTeamInspaction());
        this.gapTop = (int)((double)this.f_96544_ * 0.1);
        this.gapBottom = (int)((double)this.f_96544_ * 0.1);
        this.guiLeft += 2;
        this.guiTop = this.gapTop;
        int minUnits = Mth.m_14167_((float)2.0f);
        this.units = Math.max(minUnits, (this.f_96544_ - 130 - 32 - this.gapTop - this.gapBottom - 0) / 18);
        this.ySize = 130 + this.units * 18 + 32;
        if (this.playerList != null) {
            this.playerList.m_93437_(this.f_96543_, this.f_96544_, this.guiTop + 130 + 0, this.guiTop + 130 + this.units * 18);
        } else {
            this.playerList = new PlayersList(this.f_96543_, this.f_96544_, this.guiTop + 130 + 0, this.guiTop + 130 + this.units * 18, 32, this, PlayersList.FilterType.SAME_TEAM, this.player, true);
        }
        this.m_7787_((GuiEventListener)this.playerList);
        this.backButton = new ExtendedButton(this.guiLeft + 169, this.guiTop + 130 + 5 + this.units * 18, 60, 20, BACK_BUTTON, button -> this.f_96541_.m_91152_(this.parent));
        this.m_142416_((GuiEventListener)this.backButton);
    }

    public void postInit() {
        this.bannerRenderer = new BannerRenderer(recruitsTeam);
        int buttonY = this.guiTop + 130 + 5 + this.units * 18;
        this.selectedPlayerWidget = new SelectedPlayerWidget(this.f_96547_, this.guiLeft + 130, this.guiTop + 20, 100, 20, (Component)Component.m_237113_((String)""), () -> {});
        this.selectedPlayerWidget.setButtonActive(false);
        this.selectedPlayerWidget.setButtonVisible(false);
        this.selectedPlayerWidget.setPlayer(recruitsTeam.getTeamLeaderUUID(), recruitsTeam.getTeamLeaderName());
        this.m_142416_((GuiEventListener)this.selectedPlayerWidget);
        boolean isTeamLeader = recruitsTeam.getTeamLeaderUUID().equals(this.player.m_20148_());
        this.editButton = new ExtendedButton(this.guiLeft + 169, this.guiTop + 99, 60, 20, EDIT_BUTTON, button -> {
            TeamEditScreen.leaderInfo = null;
            TeamEvents.openTeamEditScreen(this.player);
        });
        this.editButton.f_93624_ = isTeamLeader && isEditingAllowed;
        this.m_142416_((GuiEventListener)this.editButton);
        this.diplomacyButton = new ExtendedButton(this.guiLeft + 87, this.guiTop + 99, 60, 20, DIPLOMACY_BUTTON, button -> this.f_96541_.m_91152_((Screen)new DiplomacyTeamListScreen(this, isTeamLeader)));
        this.m_142416_((GuiEventListener)this.diplomacyButton);
        this.manageButton = new ExtendedButton(this.guiLeft + 87, buttonY, 60, 20, MANAGE_BUTTON, button -> this.f_96541_.m_91152_((Screen)new TeamManageScreen(this, this.player, recruitsTeam)));
        this.manageButton.f_93624_ = isTeamLeader && isManagingAllowed;
        this.m_142416_((GuiEventListener)this.manageButton);
        boolean deleteActive = isTeamLeader && this.playerList != null && this.playerList.size() <= 1;
        this.leaveButton = new ExtendedButton(this.guiLeft + 7, buttonY, 60, 20, deleteActive ? DELETE_BUTTON : LEAVE_BUTTON, button -> {
            if (isTeamLeader) {
                if (deleteActive) {
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageLeaveTeam());
                    this.f_96541_.m_91152_((Screen)new TeamMainScreen(this.player));
                    return;
                }
                SelectPlayerScreen selectPlayerScreen = new SelectPlayerScreen(this, this.player, SELECT_LEADER, SelectPlayerScreen.BUTTON_SELECT, SELECT_LEADER_TOOLTIP, false, PlayersList.FilterType.SAME_TEAM, playerInfo -> {
                    RecruitsTeam team = playerInfo.getRecruitsTeam();
                    team.setTeamLeaderID(playerInfo.getUUID());
                    team.setTeamLeaderName(playerInfo.getName());
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageSaveTeamSettings(team, 0));
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageLeaveTeam());
                    this.m_7379_();
                });
                this.f_96541_.m_91152_((Screen)selectPlayerScreen);
            } else {
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageLeaveTeam());
                this.m_7379_();
            }
        });
        this.m_142416_((GuiEventListener)this.leaveButton);
        this.postInit = true;
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.playerList != null) {
            this.playerList.tick();
        }
        if (recruitsTeam != null && !this.postInit) {
            this.postInit();
        }
        Lighting.m_84931_();
    }

    public boolean m_7933_(int p_96552_, int p_96553_, int p_96554_) {
        boolean flag = super.m_7933_(p_96552_, p_96553_, p_96554_);
        this.selected = null;
        this.playerList.m_7522_(null);
        return flag;
    }

    public void m_7861_() {
        super.m_7861_();
        recruitsTeam = null;
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        if (this.bannerRenderer != null) {
            this.bannerRenderer.renderBanner(guiGraphics, this.guiLeft + this.x1, this.guiTop + this.y1, this.f_96543_, this.f_96544_, 60);
        }
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, 130);
        for (int i = 0; i < this.units; ++i) {
            guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop + 130 + 18 * i, 0, 130, this.xSize, 18);
        }
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop + 130 + 18 * this.units, 0, 148, this.xSize, 32);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft + 10, this.guiTop + 130 + 6 - 2, this.xSize, 0, 12, 12);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int textX = this.f_96543_ / 2 - 48;
        int textY = this.guiTop + 25;
        int crownX = this.f_96543_ / 2 - 6;
        int crownY = this.guiTop + 22;
        int numbersX = 65;
        if (!this.playerList.isEmpty()) {
            this.playerList.m_88315_(guiGraphics, mouseX, mouseY, delta);
        }
        if (recruitsTeam != null) {
            int members = TeamInspectionScreen.recruitsTeam.players + TeamInspectionScreen.recruitsTeam.npcs;
            String players = "" + TeamInspectionScreen.recruitsTeam.players;
            String npcs = "" + TeamInspectionScreen.recruitsTeam.npcs;
            if (TeamInspectionScreen.recruitsTeam.maxNPCs > 0) {
                npcs = npcs + "/" + TeamInspectionScreen.recruitsTeam.maxNPCs;
            }
            if (TeamInspectionScreen.recruitsTeam.maxPlayers > 0) {
                players = players + "/" + TeamInspectionScreen.recruitsTeam.maxPlayers;
            }
            guiGraphics.drawString(this.f_96547_, this.m_96636_().getString(), (float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.m_96636_()) / 2.0f, (float)(this.guiTop + 5), 0xFF000000 | ChatFormatting.m_126647_((int)recruitsTeam.getTeamColor()).m_126665_(), false);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)LEADER_CROWN);
            guiGraphics.m_280163_(LEADER_CROWN, crownX, crownY, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.m_280056_(this.f_96547_, LEADER_TEXT.getString(), textX, textY, 0x404040, false);
            guiGraphics.m_280056_(this.f_96547_, MEMBERS_TEXT.getString(), textX, textY + 25, 0x404040, false);
            guiGraphics.m_280056_(this.f_96547_, "" + members, textX + numbersX, textY + 25, 0x404040, false);
            guiGraphics.m_280056_(this.f_96547_, PLAYERS_TEXT.getString(), textX, textY + 40, 0x404040, false);
            guiGraphics.m_280056_(this.f_96547_, players, textX + numbersX, textY + 40, 0x404040, false);
            guiGraphics.m_280056_(this.f_96547_, NPCS_TEXT.getString(), textX, textY + 55, 0x404040, false);
            guiGraphics.m_280056_(this.f_96547_, npcs, textX + numbersX, textY + 55, 0x404040, false);
        }
    }

    @Override
    public RecruitsPlayerInfo getSelected() {
        return this.selected;
    }

    @Override
    public ListScreenListBase<RecruitsPlayerEntry> getPlayerList() {
        return this.playerList;
    }

    public Component m_96636_() {
        String name = "";
        if (recruitsTeam != null) {
            name = recruitsTeam.getTeamDisplayName();
        }
        return Component.m_237113_((String)name);
    }
}

