/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.widgets;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;

public class DropDownMenu<T>
extends AbstractWidget {
    private int bgFill = FastColor.ARGB32.m_13660_((int)255, (int)60, (int)60, (int)60);
    private int bgFillHovered = FastColor.ARGB32.m_13660_((int)255, (int)100, (int)100, (int)100);
    private int bgFillSelected = FastColor.ARGB32.m_13660_((int)255, (int)10, (int)10, (int)10);
    private int displayColor = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    private int optionTextColor = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    private final List<T> options;
    private final Consumer<T> onSelect;
    private final Function<T, String> optionTextGetter;
    private T selectedOption;
    private boolean isOpen;
    private final int optionHeight;

    public DropDownMenu(T selectedOption, int x, int y, int width, int height, List<T> options, Function<T, String> optionTextGetter, Consumer<T> onSelect) {
        super(x, y, width, height, (Component)Component.m_237113_((String)""));
        this.selectedOption = selectedOption;
        this.options = options;
        this.onSelect = onSelect;
        this.optionTextGetter = optionTextGetter;
        this.optionHeight = height;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.isMouseOverDisplay(mouseX, mouseY)) {
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, this.bgFillHovered);
        } else {
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, this.bgFillSelected);
        }
        guiGraphics.m_280137_(Minecraft.m_91087_().f_91062_, this.getSelectedText(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, this.displayColor);
        if (this.isOpen) {
            for (int i = 0; i < this.options.size(); ++i) {
                int optionY = this.m_252907_() + this.f_93619_ + i * this.optionHeight;
                T option = this.options.get(i);
                if (this.isMouseOverOption(mouseX, mouseY, optionY)) {
                    guiGraphics.m_280509_(this.m_252754_(), optionY, this.m_252754_() + this.f_93618_, optionY + this.optionHeight, this.bgFillHovered);
                } else {
                    guiGraphics.m_280509_(this.m_252754_(), optionY, this.m_252754_() + this.f_93618_, optionY + this.optionHeight, this.bgFill);
                }
                String text = this.optionTextGetter.apply(option);
                guiGraphics.m_280137_(Minecraft.m_91087_().f_91062_, text, this.m_252754_() + this.f_93618_ / 2, optionY + (this.optionHeight - 8) / 2, this.optionTextColor);
            }
        }
    }

    public void m_5716_(double mouseX, double mouseY) {
    }

    public void onMouseClick(double mouseX, double mouseY) {
        if (this.isOpen) {
            for (int i = 0; i < this.options.size(); ++i) {
                int optionY = this.m_252907_() + this.f_93619_ + i * this.optionHeight;
                if (!this.isMouseOverOption((int)mouseX, (int)mouseY, optionY)) continue;
                this.selectOption(this.options.get(i));
                return;
            }
        }
        this.isOpen = this.isMouseOverDisplay((int)mouseX, (int)mouseY) ? !this.isOpen : false;
    }

    public void onMouseMove(double mouseX, double mouseY) {
        if (this.isOpen) {
            boolean isOverDropdown = this.isMouseOverDropdown((int)mouseX, (int)mouseY);
            boolean isOverDisplay = this.isMouseOverDisplay((int)mouseX, (int)mouseY);
            if (!isOverDropdown && !isOverDisplay) {
                this.isOpen = false;
            }
        }
    }

    public boolean m_5953_(double x, double y) {
        return this.isMouseOverDisplay((int)x, (int)y) || this.isMouseOverDropdown((int)x, (int)y) || super.m_5953_(x, y);
    }

    private boolean isMouseOverDisplay(int mouseX, int mouseY) {
        return mouseX >= this.m_252754_() && mouseX <= this.m_252754_() + this.f_93618_ && mouseY >= this.m_252907_() && mouseY <= this.m_252907_() + this.f_93619_;
    }

    private boolean isMouseOverDropdown(int mouseX, int mouseY) {
        if (!this.isOpen) {
            return false;
        }
        int dropdownStartX = this.m_252754_();
        int dropdownStartY = this.m_252907_() + this.f_93619_;
        int dropdownEndX = dropdownStartX + this.f_93618_;
        int dropdownEndY = dropdownStartY + this.options.size() * this.optionHeight;
        return mouseX >= dropdownStartX && mouseX <= dropdownEndX && mouseY >= dropdownStartY && mouseY <= dropdownEndY;
    }

    private boolean isMouseOverOption(int mouseX, int mouseY, int optionY) {
        return mouseX >= this.m_252754_() && mouseX <= this.m_252754_() + this.f_93618_ && mouseY >= optionY && mouseY <= optionY + this.optionHeight;
    }

    private void selectOption(T option) {
        this.selectedOption = option;
        this.onSelect.accept(option);
        this.isOpen = false;
    }

    private String getSelectedText() {
        return this.selectedOption != null ? this.optionTextGetter.apply(this.selectedOption) : "";
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }

    public void setBgFill(int bgFill) {
        this.bgFill = bgFill;
    }

    public void setBgFillHovered(int bgFillHovered) {
        this.bgFillHovered = bgFillHovered;
    }

    public void setBgFillSelected(int bgFillSelected) {
        this.bgFillSelected = bgFillSelected;
    }

    public void setDisplayColor(int displayColor) {
        this.displayColor = displayColor;
    }

    public void setOptionTextColor(int optionTextColor) {
        this.optionTextColor = optionTextColor;
    }
}

