/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.compat.IWeapon;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.entities.AbstractInventoryEntity;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.IRangedRecruit;
import com.talhanation.recruits.entities.IStrategicFire;
import com.talhanation.recruits.entities.ai.RecruitMoveTowardsTargetGoal;
import com.talhanation.recruits.entities.ai.RecruitRangedCrossbowAttackGoal;
import com.talhanation.recruits.entities.ai.compat.RecruitRangedMusketAttackGoal;
import com.talhanation.recruits.pathfinding.AsyncGroundPathNavigation;
import com.talhanation.recruits.world.RecruitsPatrolSpawn;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CrossBowmanEntity
extends AbstractRecruitEntity
implements CrossbowAttackMob,
IRangedRecruit,
IStrategicFire {
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(CrossBowmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> STRATEGIC_FIRE_POS = SynchedEntityData.m_135353_(CrossBowmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Boolean> SHOULD_STRATEGIC_FIRE = SynchedEntityData.m_135353_(CrossBowmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final Predicate<ItemEntity> ALLOWED_ITEMS = item -> !item.m_32063_() && item.m_6084_() && this.getInventory().m_19183_(item.m_32055_()) && this.m_7243_(item.m_32055_());

    public CrossBowmanEntity(EntityType<? extends AbstractRecruitEntity> entityType, Level world) {
        super((EntityType<? extends AbstractInventoryEntity>)entityType, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_CHARGING_CROSSBOW, (Object)false);
        this.f_19804_.m_135372_(STRATEGIC_FIRE_POS, Optional.empty());
        this.f_19804_.m_135372_(SHOULD_STRATEGIC_FIRE, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("isChargingCrossbow", this.getChargingCrossbow());
        if (this.getStrategicFirePos() != null) {
            nbt.m_128405_("StrategicFirePosX", this.getStrategicFirePos().m_123341_());
            nbt.m_128405_("StrategicFirePosY", this.getStrategicFirePos().m_123342_());
            nbt.m_128405_("StrategicFirePosZ", this.getStrategicFirePos().m_123343_());
            nbt.m_128379_("ShouldStrategicFire", this.getShouldStrategicFire());
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.m_6136_(nbt.m_128471_("isChargingCrossbow"));
        if (nbt.m_128441_("StrategicFirePosX") && nbt.m_128441_("StrategicFirePosY") && nbt.m_128441_("StrategicFirePosZ")) {
            this.setStrategicFirePos(new BlockPos(nbt.m_128451_("StrategicFirePosX"), nbt.m_128451_("StrategicFirePosY"), nbt.m_128451_("StrategicFirePosZ")));
            this.setShouldStrategicFire(nbt.m_128471_("ShouldStrategicFire"));
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        if (Main.isMusketModLoaded) {
            this.f_21345_.m_25352_(0, (Goal)new RecruitRangedMusketAttackGoal(this, this.getMeleeStartRange()));
        }
        this.f_21345_.m_25352_(0, (Goal)new RecruitRangedCrossbowAttackGoal(this, this.getMeleeStartRange()));
        this.f_21345_.m_25352_(8, (Goal)new RecruitMoveTowardsTargetGoal(this, 1.15, (float)this.getMeleeStartRange()));
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.3).m_22268_(Attributes.f_22278_, 0.05).m_22268_(Attributes.f_22281_, 1.5).m_22268_(Attributes.f_22277_, 64.0).m_22268_((Attribute)ForgeMod.ENTITY_REACH.get(), 0.0).m_22266_(Attributes.f_22283_);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        RandomSource randomsource = world.m_213780_();
        SpawnGroupData ilivingentitydata = super.m_6518_(world, difficultyInstance, reason, data, nbt);
        ((AsyncGroundPathNavigation)this.m_21573_()).setCanOpenDoors(true);
        this.m_213946_(randomsource, difficultyInstance);
        this.initSpawn();
        return ilivingentitydata;
    }

    @Override
    public void initSpawn() {
        this.m_6593_((Component)Component.m_237113_((String)"Crossbowman"));
        this.setCost((Integer)RecruitsServerConfig.CrossbowmanCost.get());
        this.setEquipment();
        this.setDropEquipment();
        this.setRandomSpawnBonus();
        this.m_21530_();
        this.setGroup(2);
        if (((Boolean)RecruitsServerConfig.RangedRecruitsNeedArrowsToShoot.get()).booleanValue()) {
            if (Main.isMusketModLoaded && IWeapon.isMusketModWeapon(this.m_21205_())) {
                int i = this.m_217043_().m_188503_(32);
                ItemStack arrows = ((Item)ForgeRegistries.ITEMS.getDelegateOrThrow(ResourceLocation.m_135820_((String)"musketmod:cartridge")).get()).m_7968_();
                arrows.m_41764_(14 + i);
                this.inventory.m_6836_(6, arrows);
            } else {
                RecruitsPatrolSpawn.setRangedArrows(this);
            }
        }
        AbstractRecruitEntity.applySpawnValues(this);
    }

    public boolean m_7252_(ItemStack itemStack) {
        return !(itemStack.m_41720_() instanceof SwordItem) && !(itemStack.m_41720_() instanceof ShieldItem) || itemStack.m_41720_() instanceof CrossbowItem;
    }

    public void m_6504_(@NotNull LivingEntity target, float v) {
    }

    @Override
    public boolean m_7243_(@NotNull ItemStack itemStack) {
        if (Main.isMusketModLoaded && IWeapon.isMusketModWeapon(itemStack)) {
            return true;
        }
        if ((itemStack.m_41720_() instanceof BowItem || itemStack.m_41720_() instanceof ProjectileWeaponItem || itemStack.m_41720_() instanceof SwordItem) && this.m_21205_().m_41619_()) {
            return !this.hasSameTypeOfItem(itemStack);
        }
        if (itemStack.m_204117_(ItemTags.f_13161_) && ((Boolean)RecruitsServerConfig.RangedRecruitsNeedArrowsToShoot.get()).booleanValue()) {
            return true;
        }
        return super.m_7243_(itemStack);
    }

    @Override
    public Predicate<ItemEntity> getAllowedItems() {
        return this.ALLOWED_ITEMS;
    }

    @Override
    public double getMeleeStartRange() {
        return 3.0;
    }

    public void m_5811_(@NotNull LivingEntity target, @NotNull ItemStack stack, @NotNull Projectile projectile, float f) {
        this.m_32322_((LivingEntity)this, target, projectile, f, 1.6f);
    }

    private boolean getChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean is) {
        this.f_19804_.m_135381_(DATA_IS_CHARGING_CROSSBOW, (Object)is);
    }

    public boolean m_5886_(ProjectileWeaponItem weaponItem) {
        return weaponItem.equals(Items.f_42717_);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    @Override
    public void setStrategicFirePos(BlockPos pos) {
        this.f_19804_.m_135381_(STRATEGIC_FIRE_POS, Optional.of(pos));
    }

    public BlockPos getStrategicFirePos() {
        return ((Optional)this.f_19804_.m_135370_(STRATEGIC_FIRE_POS)).orElse(null);
    }

    public void clearArrowsPos() {
        this.f_19804_.m_135381_(STRATEGIC_FIRE_POS, Optional.empty());
    }

    @Override
    public void setShouldStrategicFire(boolean bool) {
        this.f_19804_.m_135381_(SHOULD_STRATEGIC_FIRE, (Object)bool);
    }

    public boolean getShouldStrategicFire() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_STRATEGIC_FIRE);
    }

    @Override
    public List<List<String>> getEquipment() {
        return (List)RecruitsServerConfig.CrossbowmanStartEquipments.get();
    }
}

