/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.entities.AbstractLeaderEntity;
import com.talhanation.recruits.entities.CaptainEntity;
import com.talhanation.recruits.network.MessageToClientUpdateLeaderScreen;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MessagePatrolLeaderAddWayPoint
implements Message<MessagePatrolLeaderAddWayPoint> {
    private UUID worker;
    private int x;
    private int y;
    private int z;

    public MessagePatrolLeaderAddWayPoint() {
    }

    public MessagePatrolLeaderAddWayPoint(UUID recruit, int x, int y, int z) {
        this.worker = recruit;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = Objects.requireNonNull(context.getSender());
        player.m_20193_().m_6443_(AbstractLeaderEntity.class, player.m_20191_().m_82400_(100.0), v -> v.m_20148_().equals(this.worker) && v.m_6084_()).forEach(merchant -> this.addWayPoint(new BlockPos(this.x, this.y, this.z), (Player)player, (AbstractLeaderEntity)merchant));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addWayPoint(BlockPos pos, Player player, AbstractLeaderEntity leaderEntity) {
        BlockState state = leaderEntity.m_20193_().m_8055_(pos);
        while (state.m_60795_()) {
            pos = pos.m_7495_();
            state = leaderEntity.m_20193_().m_8055_(pos);
        }
        if (leaderEntity instanceof CaptainEntity) {
            CaptainEntity captain = (CaptainEntity)leaderEntity;
            if (!state.m_60713_(Blocks.f_49990_)) {
                player.m_213846_((Component)this.TEXT_NOT_WATER_WAYPOINT(captain.m_7755_().getString()));
                return;
            }
        }
        leaderEntity.addWaypoint(pos);
        Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageToClientUpdateLeaderScreen(leaderEntity.WAYPOINTS, leaderEntity.WAYPOINT_ITEMS, leaderEntity.getArmySize()));
    }

    @Override
    public MessagePatrolLeaderAddWayPoint fromBytes(FriendlyByteBuf buf) {
        this.worker = buf.m_130259_();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.worker);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    private MutableComponent TEXT_NOT_WATER_WAYPOINT(String name) {
        return Component.m_237110_((String)"chat.recruits.text.notWaterWaypoint", (Object[])new Object[]{name});
    }
}

