/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.pathfinding;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.pathfinding.AsyncPath;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncPathProcessor {
    private static final int workersCount = (Integer)RecruitsServerConfig.AsyncPathfindingThreadsCount.get();
    private static final Executor pathFindingExecutor = new ThreadPoolExecutor(1, workersCount, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("recruits-path-processor-%d").setPriority(3).build());

    protected static void queue(@NotNull AsyncPath path) {
        CompletableFuture.runAsync(path::process, pathFindingExecutor);
    }

    public static void awaitProcessing(@Nullable Path path, MinecraftServer server, Consumer<@Nullable Path> afterProcessing) {
        AsyncPath asyncPath;
        if (path instanceof AsyncPath && !(asyncPath = (AsyncPath)path).isProcessed()) {
            asyncPath.postProcessing(() -> server.execute(() -> afterProcessing.accept(path)));
        } else {
            afterProcessing.accept(path);
        }
    }
}

