/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.util;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WaterObstacleScanner {
    private final Level world;
    private final Entity ship;
    private double scanDistance = 4.0;
    private final int scanResolution = 10;
    private static final Set<Block> ALLOWED_WATER_BLOCKS = ImmutableSet.of((Object)Blocks.f_49990_, (Object)Blocks.f_50575_, (Object)Blocks.f_50576_, (Object)Blocks.f_50037_, (Object)Blocks.f_50038_);

    public WaterObstacleScanner(Level world, Entity ship) {
        this.world = world;
        this.ship = ship;
    }

    public int getObstaclesLeft() {
        return this.scanLeftSide(this.ship.m_20156_().m_82541_());
    }

    public int getObstaclesRight() {
        return this.scanRightSide(this.ship.m_20156_().m_82541_());
    }

    public int getObstaclesFront(int range) {
        this.scanDistance = range;
        return this.scanForward(this.ship.m_20156_().m_82541_());
    }

    private int scanForward(Vec3 forwardVector) {
        int obstacleCount = 0;
        if (WaterObstacleScanner.hasObstacle(forwardVector, this.ship, this.scanDistance)) {
            ++obstacleCount;
        }
        return obstacleCount;
    }

    private int scanRightSide(Vec3 forwardVector) {
        int obstacleCount = 0;
        forwardVector = this.rotateVector(forwardVector, 30.0);
        for (double angleOffset = 0.0; angleOffset <= 45.0; angleOffset += 15.0) {
            Vec3 scanDir = this.rotateVector(forwardVector, angleOffset);
            if (!WaterObstacleScanner.hasObstacle(scanDir, this.ship, this.scanDistance)) continue;
            ++obstacleCount;
        }
        return obstacleCount;
    }

    private int scanLeftSide(Vec3 forwardVector) {
        int obstacleCount = 0;
        forwardVector = this.rotateVector(forwardVector, -30.0);
        for (double angleOffset = 0.0; angleOffset >= -45.0; angleOffset -= 15.0) {
            Vec3 scanDir = this.rotateVector(forwardVector, angleOffset);
            if (!WaterObstacleScanner.hasObstacle(scanDir, this.ship, this.scanDistance)) continue;
            ++obstacleCount;
        }
        return obstacleCount;
    }

    public static boolean hasObstacle(Vec3 scanDirection, Entity ship, double scanDistance) {
        Vec3 shipPos = ship.m_20182_();
        Vec3 targetPos = shipPos.m_82549_(scanDirection.m_82490_(scanDistance));
        BlockHitResult hitResult = ship.m_9236_().m_45547_(new ClipContext(shipPos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, ship));
        return hitResult.m_6662_() == HitResult.Type.BLOCK;
    }

    private Vec3 rotateVector(Vec3 forward, double angleOffset) {
        double angleRad = Math.toRadians(angleOffset);
        double rotatedX = forward.f_82479_ * Math.cos(angleRad) - forward.f_82481_ * Math.sin(angleRad);
        double rotatedZ = forward.f_82479_ * Math.sin(angleRad) + forward.f_82481_ * Math.cos(angleRad);
        return new Vec3(rotatedX, forward.f_82480_, rotatedZ);
    }

    public static boolean isWaterBlockPos(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return ALLOWED_WATER_BLOCKS.contains(state.m_60734_());
    }

    public boolean isAirBlockPos(BlockPos pos) {
        BlockState state = this.world.m_8055_(pos);
        return state.m_60795_();
    }

    public static enum Direction {
        FORWARD,
        LEFT,
        RIGHT,
        NONE;

    }
}

