/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.config.RecruitsServerConfig;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;

public class PillagerPatrolSpawn {
    private static final Random random = new Random();
    private final ServerLevel world;
    private int timer;
    private final double chance;

    public PillagerPatrolSpawn(ServerLevel level) {
        this.world = level;
        this.timer = this.getSpawnInterval();
        this.chance = (Double)RecruitsServerConfig.PillagerPatrolsSpawnChance.get();
    }

    public void tick() {
        if (this.timer > 0) {
            --this.timer;
        }
        if (this.timer <= 0) {
            double rnd;
            if (!this.world.m_46469_().m_46207_(GameRules.f_46124_) || !((rnd = (double)random.nextInt(100)) <= this.chance) || this.attemptSpawnPatrol()) {
                // empty if block
            }
            this.timer = this.getSpawnInterval();
        }
    }

    private boolean attemptSpawnPatrol() {
        BlockPos blockpos;
        BlockPos blockpos2;
        ServerPlayer player = this.world.m_8890_();
        if (player == null) {
            return true;
        }
        if (!player.m_20193_().m_6042_().m_63963_()) {
            player = this.world.m_8890_();
        }
        if ((blockpos2 = this.func_221244_a(blockpos = player.m_20097_(), 90)) != null && this.func_226559_a_(blockpos2) && blockpos2.m_123331_((Vec3i)blockpos) > 200.0) {
            BlockPos upPos = new BlockPos(blockpos2.m_123341_(), blockpos2.m_123342_() + 2, blockpos2.m_123343_());
            int i = random.nextInt(10);
            switch (i) {
                default: {
                    PillagerPatrolSpawn.spawnPillagerPatrol(upPos, blockpos, this.world);
                    break;
                }
                case 8: 
                case 9: {
                    PillagerPatrolSpawn.spawnSmallPillagerPatrol(upPos, blockpos, this.world);
                    break;
                }
                case 1: 
                case 2: {
                    PillagerPatrolSpawn.spawnMediumPillagerPatrol(upPos, blockpos, this.world);
                    break;
                }
                case 3: 
                case 4: {
                    PillagerPatrolSpawn.spawnLargePillagerPatrol(upPos, blockpos, this.world);
                }
            }
            this.world.m_5594_(null, upPos.m_6630_(2), (SoundEvent)SoundEvents.f_12355_.get(), SoundSource.BLOCKS, 15.0f, 2.0f);
            Main.LOGGER.info("New Pillager Patrol Spawned at " + upPos);
            player.m_213846_((Component)Component.m_237113_((String)"A Pillager Patrol Spawned next to you!").m_130940_(ChatFormatting.GRAY));
            return true;
        }
        return false;
    }

    private int getSpawnInterval() {
        int minutes = (Integer)RecruitsServerConfig.PillagerPatrolSpawnInterval.get();
        return 1200 * minutes;
    }

    public static void spawnPillagerPatrol(BlockPos upPos, BlockPos targetPos, ServerLevel world) {
        Pillager pillagerLeader = PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        pillagerLeader.m_21561_(true);
        pillagerLeader.m_6593_((Component)Component.m_237113_((String)"Pillager Leader"));
        pillagerLeader.m_33075_(true);
        pillagerLeader.m_37897_(true);
        pillagerLeader.m_21553_(true);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createWitch(upPos, targetPos, world);
        PillagerPatrolSpawn.createVindicator(upPos, targetPos, world);
        PillagerPatrolSpawn.createVindicator(upPos, targetPos, world);
        PillagerPatrolSpawn.createVindicator(upPos, targetPos, world);
        PillagerPatrolSpawn.createVindicator(upPos, targetPos, world);
    }

    public static Pillager createPillager(BlockPos upPos, BlockPos targetPos, ServerLevel world) {
        Pillager pillager = (Pillager)EntityType.f_20513_.m_20615_((Level)world);
        pillager.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        pillager.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        pillager.m_21530_();
        pillager.m_33070_(targetPos);
        world.m_7967_((Entity)pillager);
        return pillager;
    }

    public static Witch createWitch(BlockPos upPos, BlockPos targetPos, ServerLevel world) {
        Witch pillager = (Witch)EntityType.f_20495_.m_20615_((Level)world);
        pillager.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        pillager.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        pillager.m_21530_();
        pillager.m_33070_(targetPos);
        world.m_7967_((Entity)pillager);
        return pillager;
    }

    public static Vindicator createVindicator(BlockPos upPos, BlockPos targetPos, ServerLevel world) {
        Vindicator pillager = (Vindicator)EntityType.f_20493_.m_20615_((Level)world);
        pillager.m_7678_((double)upPos.m_123341_() + 0.5, (double)upPos.m_123342_() + 0.5, (double)upPos.m_123343_() + 0.5, random.nextFloat() * 360.0f - 180.0f, 0.0f);
        pillager.m_6518_((ServerLevelAccessor)world, world.m_6436_(upPos), MobSpawnType.PATROL, null, null);
        pillager.m_21530_();
        pillager.m_33070_(targetPos);
        world.m_7967_((Entity)pillager);
        return pillager;
    }

    public static void spawnLargePillagerPatrol(BlockPos upPos, BlockPos targetPos, ServerLevel world) {
        Pillager pillagerLeader = PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        pillagerLeader.m_21561_(true);
        pillagerLeader.m_6593_((Component)Component.m_237113_((String)"Pillager Leader"));
        pillagerLeader.m_33075_(true);
        pillagerLeader.m_37897_(true);
        pillagerLeader.m_21553_(true);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createWitch(upPos, targetPos, world);
        PillagerPatrolSpawn.createWitch(upPos, targetPos, world);
        PillagerPatrolSpawn.createWitch(upPos, targetPos, world);
        PillagerPatrolSpawn.createVindicator(upPos, targetPos, world);
        PillagerPatrolSpawn.createVindicator(upPos, targetPos, world);
        PillagerPatrolSpawn.createVindicator(upPos, targetPos, world);
        PillagerPatrolSpawn.createVindicator(upPos, targetPos, world);
        PillagerPatrolSpawn.createVindicator(upPos, targetPos, world);
        PillagerPatrolSpawn.createVindicator(upPos, targetPos, world);
        PillagerPatrolSpawn.createVindicator(upPos, targetPos, world);
    }

    public static void spawnMediumPillagerPatrol(BlockPos upPos, BlockPos targetPos, ServerLevel world) {
        Pillager pillagerLeader = PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        pillagerLeader.m_21561_(true);
        pillagerLeader.m_6593_((Component)Component.m_237113_((String)"Pillager Leader"));
        pillagerLeader.m_33075_(true);
        pillagerLeader.m_37897_(true);
        pillagerLeader.m_21553_(true);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createVindicator(upPos, targetPos, world);
        PillagerPatrolSpawn.createVindicator(upPos, targetPos, world);
        PillagerPatrolSpawn.createVindicator(upPos, targetPos, world);
    }

    public static void spawnSmallPillagerPatrol(BlockPos upPos, BlockPos targetPos, ServerLevel world) {
        Pillager pillagerLeader = PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        pillagerLeader.m_21561_(true);
        pillagerLeader.m_6593_((Component)Component.m_237113_((String)"Pillager Leader"));
        pillagerLeader.m_33075_(true);
        pillagerLeader.m_37897_(true);
        pillagerLeader.m_21553_(true);
        PillagerPatrolSpawn.createVindicator(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createPillager(upPos, targetPos, world);
        PillagerPatrolSpawn.createWitch(upPos, targetPos, world);
    }

    @Nullable
    private BlockPos func_221244_a(BlockPos p_221244_1_, int p_221244_2_) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int j = p_221244_1_.m_123341_() + random.nextInt(p_221244_2_ * 2) - p_221244_2_;
            int k = p_221244_1_.m_123343_() + random.nextInt(p_221244_2_ * 2) - p_221244_2_;
            int l = this.world.m_6924_(Heightmap.Types.WORLD_SURFACE, j, k);
            BlockPos blockpos1 = new BlockPos(j, l, k);
            if (this.world.m_6018_().m_8736_(blockpos1, 2) || !NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)this.world, (BlockPos)blockpos1, (EntityType)EntityType.f_20494_)) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    private boolean func_226559_a_(BlockPos p_226559_1_) {
        BlockPos blockpos;
        Iterator var2 = BlockPos.m_121940_((BlockPos)p_226559_1_, (BlockPos)p_226559_1_.m_7918_(1, 2, 1)).iterator();
        do {
            if (var2.hasNext()) continue;
            return true;
        } while (this.world.m_8055_(blockpos = (BlockPos)var2.next()).m_60816_((BlockGetter)this.world, blockpos).m_83281_() && this.world.m_6425_(blockpos).m_76178_());
        return false;
    }
}

