/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import com.talhanation.recruits.TeamEvents;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.world.RecruitPlayerUnitSaveData;
import com.talhanation.recruits.world.RecruitsTeam;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;

public class RecruitsPlayerUnitManager {
    private Map<UUID, Integer> recruitCountMap = new HashMap<UUID, Integer>();

    public void load(ServerLevel level) {
        RecruitPlayerUnitSaveData data = RecruitPlayerUnitSaveData.get(level);
        this.recruitCountMap = data.getRecruitCountMap();
    }

    public void save(ServerLevel level) {
        RecruitPlayerUnitSaveData data = RecruitPlayerUnitSaveData.get(level);
        for (Map.Entry<UUID, Integer> entry : this.recruitCountMap.entrySet()) {
            data.setRecruitCount(entry.getKey(), entry.getValue());
        }
        data.m_77762_();
    }

    public int getRecruitCount(UUID playerUUID) {
        return this.recruitCountMap.getOrDefault(playerUUID, 0);
    }

    public void setRecruitCount(UUID playerUUID, int count) {
        this.recruitCountMap.put(playerUUID, count);
    }

    public void addRecruits(UUID playerUUID, int count) {
        this.recruitCountMap.put(playerUUID, this.getRecruitCount(playerUUID) + count);
    }

    public void removeRecruits(UUID playerUUID, int count) {
        this.recruitCountMap.put(playerUUID, Math.max(this.getRecruitCount(playerUUID) - count, 0));
    }

    public boolean canPlayerRecruit(String stringId, UUID playerUUID) {
        RecruitsTeam recruitsTeam = TeamEvents.recruitsTeamManager.getTeamByStringID(stringId);
        int currentRecruitCount = this.getRecruitCount(playerUUID);
        int maxRecruitCount = 0;
        if (recruitsTeam == null) {
            maxRecruitCount = (Integer)RecruitsServerConfig.MaxRecruitsForPlayer.get();
        } else {
            maxRecruitCount = playerUUID.equals(recruitsTeam.getTeamLeaderUUID()) ? recruitsTeam.maxNPCs : recruitsTeam.getMaxNPCsPerPlayer();
            if (recruitsTeam.npcs >= recruitsTeam.maxNPCs) {
                return false;
            }
        }
        return currentRecruitCount < maxRecruitCount;
    }
}

