/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import com.talhanation.recruits.world.RecruitsTeam;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class RecruitsTeamSaveData
extends SavedData {
    public static final String FILE_ID = "recruitsTeamSaveData";
    private Map<String, RecruitsTeam> teams = new HashMap<String, RecruitsTeam>();

    public static RecruitsTeamSaveData get(ServerLevel level) {
        DimensionDataStorage storage = level.m_8895_();
        return (RecruitsTeamSaveData)storage.m_164861_(RecruitsTeamSaveData::load, RecruitsTeamSaveData::new, FILE_ID);
    }

    public static RecruitsTeamSaveData load(CompoundTag nbt) {
        RecruitsTeamSaveData data = new RecruitsTeamSaveData();
        if (nbt.m_128425_("Teams", 9)) {
            data.teams = RecruitsTeamSaveData.loadTeams(nbt.m_128437_("Teams", 10));
        }
        return data;
    }

    private static Map<String, RecruitsTeam> loadTeams(ListTag list) {
        HashMap<String, RecruitsTeam> loadedTeams = new HashMap<String, RecruitsTeam>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag nbt = list.m_128728_(i);
            RecruitsTeam recruitsTeam = new RecruitsTeam();
            recruitsTeam.setStringID(nbt.m_128461_("TeamName"));
            recruitsTeam.setTeamDisplayName(nbt.m_128461_("TeamDisplayName"));
            recruitsTeam.setTeamLeaderID(nbt.m_128342_("TeamLeaderID"));
            recruitsTeam.setTeamLeaderName(nbt.m_128461_("TeamLeaderName"));
            recruitsTeam.setBanner((CompoundTag)nbt.m_128423_("TeamBanner"));
            recruitsTeam.setPlayers(nbt.m_128451_("Players"));
            recruitsTeam.setNPCs(nbt.m_128451_("NPCs"));
            recruitsTeam.setMaxPlayers(nbt.m_128451_("MaxPlayers"));
            recruitsTeam.setMaxNPCs(nbt.m_128451_("MaxNPCs"));
            ListTag joinRequestsList = nbt.m_128437_("JoinRequests", 8);
            for (int j = 0; j < joinRequestsList.size(); ++j) {
                recruitsTeam.getJoinRequests().add(joinRequestsList.m_128778_(j));
            }
            recruitsTeam.setUnitColor(nbt.m_128445_("Color"));
            recruitsTeam.setTeamColor(nbt.m_128451_("TeamColor"));
            recruitsTeam.setMaxNPCsPerPlayer(nbt.m_128451_("maxNpcsPerPlayer"));
            loadedTeams.put(recruitsTeam.getStringID(), recruitsTeam);
        }
        return loadedTeams;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128365_("Teams", (Tag)this.saveTeams());
        return nbt;
    }

    private ListTag saveTeams() {
        ListTag listTag = new ListTag();
        for (RecruitsTeam team : this.teams.values()) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("TeamName", team.getStringID());
            nbt.m_128359_("TeamDisplayName", team.getTeamDisplayName());
            nbt.m_128362_("TeamLeaderID", team.getTeamLeaderUUID());
            nbt.m_128359_("TeamLeaderName", team.getTeamLeaderName());
            nbt.m_128365_("TeamBanner", (Tag)team.getBanner());
            nbt.m_128405_("Players", team.getPlayers());
            nbt.m_128405_("NPCs", team.getNPCs());
            nbt.m_128405_("MaxPlayers", team.getMaxPlayers());
            nbt.m_128405_("MaxNPCs", team.getMaxNPCs());
            ListTag joinRequestsTag = new ListTag();
            for (String request : team.getJoinRequests()) {
                joinRequestsTag.add((Object)StringTag.m_129297_((String)request));
            }
            nbt.m_128365_("JoinRequests", (Tag)joinRequestsTag);
            nbt.m_128344_("Color", team.getUnitColor());
            nbt.m_128405_("TeamColor", team.getTeamColor());
            nbt.m_128405_("maxNpcsPerPlayer", team.getMaxNPCsPerPlayer());
            listTag.add((Object)nbt);
        }
        return listTag;
    }

    public Map<String, RecruitsTeam> getTeams() {
        return this.teams;
    }

    public void setTeams(Map<String, RecruitsTeam> teams) {
        this.teams = teams;
    }
}

