/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.INameable;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageDoorbellNotification;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class DoorbellBlockEntity
extends ElectricityModuleBlockEntity
implements INameable {
    public static final int MAX_NAME_LENGTH = 32;
    protected UUID owner;
    protected String customName = "";
    protected long lastPressedTime;
    protected boolean powered;

    public DoorbellBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.DOORBELL.get(), pos, state);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.m_6596_();
    }

    @Override
    public boolean isNodePowered() {
        return this.powered;
    }

    @Override
    public void setNodePowered(boolean powered) {
        this.powered = powered;
        this.m_6596_();
        if (!this.f_58857_.m_5776_()) {
            CompoundTag compound = new CompoundTag();
            compound.m_128379_("Powered", powered);
            BlockEntityHelper.sendCustomUpdate(this, compound);
        }
    }

    @Override
    public void setName(@Nullable ServerPlayer player, String name) {
        if (this.owner == null || player == null) {
            return;
        }
        if (!this.owner.equals(player.m_20148_())) {
            return;
        }
        if (!name.isBlank()) {
            this.customName = StringUtils.truncate((String)name, (int)32);
            this.m_6596_();
        }
    }

    public void sendNotificationToOwner(@Nullable Player presser) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.owner != null) {
                MinecraftServer server = level2.m_7654_();
                ServerPlayer player = server.m_6846_().m_11259_(this.owner);
                if (player == null || level2.m_46467_() - this.lastPressedTime < 600L) {
                    return;
                }
                if (presser != null && presser.equals((Object)player)) {
                    return;
                }
                Network.getPlay().sendToPlayer(() -> player, (IMessage)new MessageDoorbellNotification(this.customName));
                this.lastPressedTime = level2.m_46467_();
            }
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("Owner", 11)) {
            this.owner = tag.m_128342_("Owner");
        }
        if (tag.m_128425_("CustomName", 8)) {
            this.customName = tag.m_128461_("CustomName");
        }
        if (tag.m_128425_("Powered", 1)) {
            this.powered = tag.m_128471_("Powered");
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.owner != null) {
            tag.m_128362_("Owner", this.owner);
        }
        tag.m_128379_("Powered", this.powered);
        tag.m_128359_("CustomName", this.customName);
    }
}

