/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.searchlight.util;

import java.util.function.Consumer;
import me.lizardofoz.searchlight.SearchlightMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchlightUtil {
    private SearchlightUtil() {
    }

    public static <T extends BlockEntity> boolean castBlockEntity(@Nullable BlockEntity blockEntity, @NotNull BlockPos blockPos, @NotNull Consumer<T> result) {
        if (blockEntity == null) {
            try {
                throw new IllegalStateException();
            }
            catch (Exception e) {
                SearchlightMod.LOGGER.error("Attempted to cast a null blockEntity at " + blockPos, (Throwable)e);
                return false;
            }
        }
        if (!blockEntity.m_58898_()) {
            try {
                throw new IllegalStateException();
            }
            catch (Exception e) {
                SearchlightMod.LOGGER.error(String.format("Attempted to use a blockEntity '%s' (%s) at %s with world==null.", blockEntity, blockEntity.getClass(), blockPos), (Throwable)e);
                return false;
            }
        }
        try {
            result.accept(blockEntity);
            return true;
        }
        catch (ClassCastException ex) {
            SearchlightMod.LOGGER.error(String.format("Attempted to cast '%s' (%s) at %s but failed", blockEntity, blockEntity.getClass(), blockPos), (Throwable)ex);
            return false;
        }
    }

    @NotNull
    public static BlockState getBlockStateForceLoad(@NotNull Level world, @NotNull BlockPos blockPos) {
        return world.m_8055_(blockPos);
    }

    @NotNull
    public static BlockState getBlockStateIfLoaded(Level world, BlockPos blockPos) {
        if (world.m_46739_(blockPos)) {
            return Blocks.f_50626_.m_49966_();
        }
        BlockGetter chunk = world.m_7925_(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4);
        if (chunk == null) {
            return Blocks.f_50626_.m_49966_();
        }
        return chunk.m_8055_(blockPos);
    }

    public static boolean setBlockStateForceLoad(Level world, BlockPos blockPos, BlockState blockState) {
        return world.m_46597_(blockPos, blockState);
    }

    public static Direction getDirection(BlockState state) {
        AttachFace face = (AttachFace)state.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_);
        if (face == AttachFace.CEILING) {
            return Direction.DOWN;
        }
        if (face == AttachFace.FLOOR) {
            return Direction.UP;
        }
        return (Direction)state.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_54117_);
    }

    @NotNull
    public static Vec3 directionToBeamVector(@NotNull Direction direction) {
        Vec3i vector = direction.m_122436_();
        return new Vec3((double)vector.m_123341_(), (double)vector.m_123342_(), (double)vector.m_123343_()).m_82541_();
    }

    public static BlockPos moveAwayFromSurfaces(Level world, BlockPos blockPos) {
        if (blockPos == null) {
            return null;
        }
        BlockPos resultPos = blockPos.m_7949_();
        if (!world.m_8055_(resultPos.m_7918_(-1, 0, 0)).m_60795_() && world.m_8055_(resultPos.m_7918_(1, 0, 0)).m_60795_()) {
            resultPos = resultPos.m_7918_(1, 0, 0);
        } else if (!world.m_8055_(resultPos.m_7918_(1, 0, 0)).m_60795_() && world.m_8055_(resultPos.m_7918_(-1, 0, 0)).m_60795_()) {
            resultPos = resultPos.m_7918_(-1, 0, 0);
        }
        if (!world.m_8055_(resultPos.m_7918_(0, -1, 0)).m_60795_() && world.m_8055_(resultPos.m_7918_(0, 1, 0)).m_60795_()) {
            resultPos = resultPos.m_7918_(0, 1, 0);
        } else if (!world.m_8055_(resultPos.m_7918_(0, 1, 0)).m_60795_() && world.m_8055_(resultPos.m_7918_(0, -1, 0)).m_60795_()) {
            resultPos = resultPos.m_7918_(0, -1, 0);
        }
        if (!world.m_8055_(resultPos.m_7918_(0, 0, -1)).m_60795_() && world.m_8055_(resultPos.m_7918_(0, 0, 1)).m_60795_()) {
            resultPos = resultPos.m_7918_(0, 0, 1);
        } else if (!world.m_8055_(resultPos.m_7918_(0, 0, 1)).m_60795_() && world.m_8055_(resultPos.m_7918_(0, 0, -1)).m_60795_()) {
            resultPos = resultPos.m_7918_(0, 0, -1);
        }
        return resultPos;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean displayBeams() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player != null && player.m_21055_(SearchlightMod.getSearchlightItem());
    }
}

