/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.Projectile.AcidBall;
import com.Harbinger.Spore.Sentities.Projectile.BileProjectile;
import com.Harbinger.Spore.Sentities.Projectile.ThrownTumor;
import com.Harbinger.Spore.Sentities.Projectile.Vomit;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.SpitterVariants;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class Spitter
extends EvolvedInfected
implements RangedAttackMob,
VariantKeeper {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Spitter.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Spitter(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal(this, 1.1, this.getShootingPerVariant(), 16.0f){

            public boolean m_8036_() {
                if (Spitter.this.getTypeVariant() == 0 && !Spitter.this.switchy()) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new RangedAttackGoal(this, 1.1, 5, 5.0f){

            public boolean m_8036_() {
                return super.m_8036_() && Spitter.this.getTypeVariant() == 0;
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_spitter_loot.get();
    }

    private boolean switchy() {
        if (this.m_5448_() != null) {
            double ze = this.m_20280_((Entity)this.m_5448_());
            return !(ze < 32.0);
        }
        return true;
    }

    private int getShootingPerVariant() {
        if (this.getVariant() == SpitterVariants.BILE) {
            return 50;
        }
        if (this.getVariant() == SpitterVariants.EXPLOSIVE) {
            return 60;
        }
        return 40;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.spit_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.spit_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        if (!this.m_9236_().f_46443_) {
            if (this.getTypeVariant() == 1) {
                ThrownTumor tumor = new ThrownTumor(this.m_9236_(), (LivingEntity)this);
                double dx = livingEntity.m_20185_() - this.m_20185_();
                double dy = livingEntity.m_20186_() + (double)livingEntity.m_20192_() - 1.0;
                double dz = livingEntity.m_20189_() - this.m_20189_();
                tumor.setMobEffect((MobEffect)Seffects.CORROSION.get());
                tumor.setExplode(Level.ExplosionInteraction.NONE);
                tumor.m_6027_(this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_());
                tumor.m_6686_(dx, dy - tumor.m_20186_() + Math.hypot(dx, dz) * (double)0.05f, dz, 2.0f, 12.0f);
                this.m_9236_().m_7967_((Entity)tumor);
            } else if (this.getTypeVariant() == 2) {
                BileProjectile bileProjectile = new BileProjectile(this.m_9236_(), (LivingEntity)this, this.TARGET_SELECTOR);
                double dx = livingEntity.m_20185_() - this.m_20185_();
                double dy = livingEntity.m_20186_() + (double)livingEntity.m_20192_() - 1.0;
                double dz = livingEntity.m_20189_() - this.m_20189_();
                bileProjectile.setDamage((float)((Double)SConfig.SERVER.spit_damage_l.get() * 1.0));
                bileProjectile.m_6027_(this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_());
                bileProjectile.m_6686_(dx, dy - bileProjectile.m_20186_() + Math.hypot(dx, dz) * (double)0.05f, dz, 2.0f, 12.0f);
                this.m_9236_().m_7967_((Entity)bileProjectile);
            } else {
                double ze = this.m_20280_((Entity)livingEntity);
                if (ze < 32.0) {
                    Vomit.shoot((LivingEntity)this, livingEntity, (float)((Double)SConfig.SERVER.spit_damage_c.get() * (Double)SConfig.SERVER.global_damage.get()));
                } else {
                    AcidBall.shoot((LivingEntity)this, livingEntity, (float)((Double)SConfig.SERVER.spit_damage_l.get() * (Double)SConfig.SERVER.global_damage.get()));
                    this.m_5496_(SoundEvents.f_12387_, 1.0f, 0.5f);
                }
            }
        }
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.INF_VILLAGER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @Nullable SpawnGroupData p_146749_, @Nullable CompoundTag p_146750_) {
        SpitterVariants variant = (SpitterVariants)((Object)Util.m_214670_((Object[])SpitterVariants.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    public SpitterVariants getVariant() {
        return SpitterVariants.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        if (i > SpitterVariants.values().length || i < 0) {
            this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)0);
        } else {
            this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)i);
        }
    }

    @Override
    public int amountOfMutations() {
        return SpitterVariants.values().length;
    }

    private void setVariant(SpitterVariants variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public String getMutation() {
        if (this.getTypeVariant() != 0) {
            return this.getVariant().getName();
        }
        return super.getMutation();
    }

    @Override
    public boolean m_142582_(Entity entity) {
        if (entity.isInFluidType()) {
            return false;
        }
        return super.m_142582_(entity);
    }
}

