/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.Client.TentacleSegment;
import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Tentacle
extends Organoid {
    private static final int SEGMENTS = 8;
    private final List<TentacleSegment> segments = new ArrayList<TentacleSegment>();
    private Vec3 targetPosition = this.m_20182_();
    private float tentacleTime = 0.0f;

    public Tentacle(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        for (int i = 0; i < 8; ++i) {
            this.segments.add(new TentacleSegment(this.m_20182_(), 1.0f));
        }
    }

    public Vec3 getTargetPosition() {
        return this.targetPosition;
    }

    public List<TentacleSegment> getSegments() {
        return this.segments;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.mound_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.mound_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        this.addTargettingGoals();
        super.m_8099_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.tentacleTime += 0.05f;
        if (this.f_19797_ % 80 == 0) {
            this.targetPosition = Utilities.generatePositionAway(this.m_20182_(), 6.0);
        }
        this.applyIK();
    }

    private void applyIK() {
        Vec3 newPos;
        Vec3 direction;
        Vec3 currentPos;
        int i;
        if (this.segments.isEmpty()) {
            return;
        }
        this.segments.get(7).smoothMove(this.targetPosition, this.tentacleTime, 7);
        for (i = 6; i >= 0; --i) {
            Vec3 nextPos = this.segments.get((int)(i + 1)).position;
            currentPos = this.segments.get((int)i).position;
            direction = nextPos.m_82546_(currentPos).m_82541_();
            newPos = nextPos.m_82546_(direction.m_82490_((double)this.segments.get((int)i).length));
            this.segments.get(i).smoothMove(newPos, this.tentacleTime, i);
        }
        this.segments.get(0).smoothMove(this.m_20182_(), this.tentacleTime, 0);
        for (i = 1; i < 8; ++i) {
            Vec3 prevPos = this.segments.get((int)(i - 1)).position;
            currentPos = this.segments.get((int)i).position;
            direction = currentPos.m_82546_(prevPos).m_82541_();
            newPos = prevPos.m_82549_(direction.m_82490_((double)this.segments.get((int)i).length));
            this.segments.get(i).smoothMove(newPos, this.tentacleTime, i);
        }
    }
}

