/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sparticles;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Recipes.EntityContainer;
import com.Harbinger.Spore.Recipes.WombRecipe;
import com.Harbinger.Spore.Screens.AssimilationMenu;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class Womb
extends Organoid
implements MenuProvider {
    private static final EntityDataAccessor<Integer> COUNTER = SynchedEntityData.m_135353_(Womb.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BIOMASS = SynchedEntityData.m_135353_(Womb.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(Womb.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockPos> LOCATION = SynchedEntityData.m_135353_(Womb.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private int breakCounter;
    private final List<String> attributeIDs = new ArrayList<String>();
    private int eatingTicks = 0;

    public Womb(EntityType<? extends PathfinderMob> type, Level level, TERRAIN terrain, BlockPos pos) {
        super(type, level);
        this.f_19804_.m_135381_(STATE, (Object)terrain.value);
        this.setLocation(pos);
    }

    public Womb(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_19804_.m_135381_(STATE, (Object)0);
        this.setLocation(BlockPos.f_121853_);
    }

    public List<String> getAttributeIDs() {
        return this.attributeIDs;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.womb_loot.get();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COUNTER, (Object)0);
        this.f_19804_.m_135372_(BIOMASS, (Object)0);
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(LOCATION, (Object)BlockPos.f_121853_);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.WOMB_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if ((Integer)this.f_19804_.m_135370_(BIOMASS) >= (Integer)SConfig.SERVER.reconstructor_biomass.get()) {
            this.summon((Entity)this, false);
        }
        if ((Integer)this.f_19804_.m_135370_(COUNTER) < (Integer)SConfig.SERVER.recontructor_clock.get() * 20) {
            this.f_19804_.m_135381_(COUNTER, (Object)((Integer)this.f_19804_.m_135370_(COUNTER) + 1));
        } else {
            this.f_19804_.m_135381_(COUNTER, (Object)0);
            this.f_19804_.m_135381_(BIOMASS, (Object)((Integer)this.f_19804_.m_135370_(BIOMASS) + 1));
        }
        if (this.f_19796_.m_188503_(100) == 0) {
            this.CallNearbyInfected();
        }
        if (this.f_19796_.m_188503_(40) == 0) {
            this.AssimilateNearbyInfected();
        }
        if (this.f_19796_.m_188503_(20) == 0 && this.isEating()) {
            this.m_216990_(SoundEvents.f_11912_);
        }
        if (this.eatingTicks > 0) {
            --this.eatingTicks;
        }
    }

    public void setBiomass(int biomass) {
        this.f_19804_.m_135381_(BIOMASS, (Object)biomass);
    }

    public int getBiomass() {
        return (Integer)this.f_19804_.m_135370_(BIOMASS);
    }

    public void setLocation(BlockPos pos) {
        this.f_19804_.m_135381_(LOCATION, (Object)pos);
    }

    public BlockPos getLocation() {
        return (BlockPos)this.f_19804_.m_135370_(LOCATION);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Counter", ((Integer)this.f_19804_.m_135370_(COUNTER)).intValue());
        tag.m_128405_("Biomass", ((Integer)this.f_19804_.m_135370_(BIOMASS)).intValue());
        tag.m_128405_("State", ((Integer)this.f_19804_.m_135370_(STATE)).intValue());
        tag.m_128405_("LocationX", this.getLocation().m_123341_());
        tag.m_128405_("LocationY", this.getLocation().m_123342_());
        tag.m_128405_("LocationZ", this.getLocation().m_123343_());
        ListTag teamTag = new ListTag();
        for (String member : this.attributeIDs) {
            teamTag.add((Object)StringTag.m_129297_((String)member));
        }
        tag.m_128365_("mutations", (Tag)teamTag);
    }

    public boolean isEating() {
        return this.eatingTicks > 0;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(COUNTER, (Object)tag.m_128451_("Counter"));
        this.f_19804_.m_135381_(BIOMASS, (Object)tag.m_128451_("Biomass"));
        this.f_19804_.m_135381_(STATE, (Object)tag.m_128451_("State"));
        int i = tag.m_128451_("LocationX");
        int j = tag.m_128451_("LocationY");
        int k = tag.m_128451_("LocationZ");
        this.setLocation(new BlockPos(i, j, k));
        this.attributeIDs.clear();
        ListTag teamTag = tag.m_128437_("mutations", 8);
        for (int l = 0; l < teamTag.size(); ++l) {
            this.attributeIDs.add(teamTag.m_128778_(l));
        }
    }

    private void CallNearbyInfected() {
        if (!this.m_9236_().f_46443_) {
            AABB hitbox = this.m_20191_().m_82400_(50.0);
            List entities = this.m_9236_().m_6249_((Entity)this, hitbox, EntitySelector.f_20406_);
            for (Entity en : entities) {
                if (!(en instanceof Infected)) continue;
                Infected infected = (Infected)en;
                infected.setSearchPos(new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()));
            }
        }
    }

    public Optional<WombRecipe> getCurrentRecipe(Entity entity) {
        EntityContainer container = new EntityContainer(entity);
        return this.m_9236_().m_7465_().m_44015_((RecipeType)WombRecipe.WombRecipeType.INSTANCE, (Container)container, this.m_9236_());
    }

    public void addMutation(WombRecipe recipe) {
        this.attributeIDs.add(recipe.getAttribute());
    }

    private void AssimilateNearbyInfected() {
        if (!this.m_9236_().f_46443_) {
            List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(0.1), EntitySelector.f_20406_);
            for (Entity en : entities) {
                if (!(en instanceof Infected)) continue;
                Infected infected = (Infected)en;
                this.setBiomass(this.getBiomass() + this.calculateAssimilation((Entity)infected) + infected.getKills());
                Optional<WombRecipe> recipe = this.getCurrentRecipe((Entity)infected);
                recipe.ifPresent(this::addMutation);
                infected.m_146870_();
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    double x0 = this.m_20185_() - ((double)this.f_19796_.m_188501_() - 0.1) * 0.1;
                    double y0 = this.m_20186_() + ((double)this.f_19796_.m_188501_() - 0.25) * 0.25 * 5.0;
                    double z0 = this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.1) * 0.1;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)Sparticles.BLOOD_PARTICLE.get()), x0, y0, z0, 8, 0.0, 0.0, 0.0, 1.0);
                }
                this.m_216990_(SoundEvents.f_11912_);
                this.eatingTicks += 80;
                break;
            }
        }
    }

    public int calculateAssimilation(Entity entity) {
        int value = (Integer)SConfig.SERVER.reconstructor_assimilation.get();
        if (entity instanceof Hyper) {
            return value * 4;
        }
        if (entity instanceof EvolvedInfected) {
            return value * 2;
        }
        return value;
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (BIOMASS.equals(dataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(dataAccessor);
    }

    public EntityDimensions m_6972_(Pose pose) {
        int age = 1;
        if (this.getBiomass() > (Integer)SConfig.SERVER.reconstructor_biomass.get() / 4 && this.getBiomass() < (Integer)SConfig.SERVER.reconstructor_biomass.get() / 2) {
            age = 2;
        } else if (this.getBiomass() > (Integer)SConfig.SERVER.reconstructor_biomass.get() / 2) {
            age = 3;
        }
        return super.m_6972_(pose).m_20388_((float)age);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.reconstructor_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.reconstructor_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.breakCounter < 40) {
            ++this.breakCounter;
        } else if (this.m_21225_() == this.m_269291_().m_269318_() && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            AABB aabb = this.m_20191_().m_82377_(0.2, 0.0, 0.2);
            boolean flag = false;
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                if (!(blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos) < 10.0f) || !(blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos) > 0.0f)) continue;
                flag = this.m_9236_().m_46953_(blockpos, true, (Entity)this) || flag;
                this.breakCounter = 0;
            }
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.getBiomass() > 1) {
            int age = 1;
            if (this.getBiomass() > (Integer)SConfig.SERVER.reconstructor_biomass.get() / 4 && this.getBiomass() < (Integer)SConfig.SERVER.reconstructor_biomass.get() / 2) {
                age = 2;
            } else if (this.getBiomass() > (Integer)SConfig.SERVER.reconstructor_biomass.get() / 2) {
                age = 3;
            }
            if (age > 1) {
                AttributeInstance health = this.m_21051_(Attributes.f_22276_);
                assert (health != null);
                health.m_22100_((Double)SConfig.SERVER.mound_hp.get() * (double)age * (Double)SConfig.SERVER.global_health.get());
                AttributeInstance armor = this.m_21051_(Attributes.f_22284_);
                assert (armor != null);
                armor.m_22100_((Double)SConfig.SERVER.mound_armor.get() * (double)age * (Double)SConfig.SERVER.global_armor.get());
            }
        }
    }

    private void summon(Entity entity, boolean value) {
        Object object;
        List<? extends String> variantList;
        if (Math.random() <= (double)0.3f) {
            this.f_19804_.m_135381_(STATE, (Object)this.f_19796_.m_188503_(TERRAIN.values().length));
        }
        if ((variantList = this.getVariant().getList()).isEmpty()) {
            return;
        }
        ResourceLocation entityId = new ResourceLocation(variantList.get(this.f_19796_.m_188503_(variantList.size())));
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
        if (entityType == null) {
            return;
        }
        Mob spawnedEntity = (Mob)entityType.m_20615_(this.m_9236_());
        if (spawnedEntity == null) {
            return;
        }
        spawnedEntity.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        if (spawnedEntity instanceof Calamity) {
            Calamity calamity = (Calamity)spawnedEntity;
            calamity.setSearchArea(this.getLocation());
            object = this.attributeIDs.iterator();
            while (object.hasNext()) {
                AttributeInstance instance;
                String attrId = (String)object.next();
                ResourceLocation attrLocation = new ResourceLocation(attrId);
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attrLocation);
                if (attribute == null || (instance = calamity.m_21051_(attribute)) == null) continue;
                double e = instance.m_22135_();
                instance.m_22100_(e + 1.0);
            }
            if (value) {
                calamity.m_20254_(3);
                calamity.m_21153_(calamity.m_21233_() / 2.0f);
            }
        }
        if ((object = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            double x0 = this.m_20185_() - ((double)this.f_19796_.m_188501_() - 0.1) * 0.1;
            double y0 = this.m_20186_() + ((double)this.f_19796_.m_188501_() - 0.25) * 0.15 * 5.0;
            double z0 = this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.1) * 0.1;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, x0, y0, z0, 2, 0.0, 0.0, 0.0, 1.0);
            spawnedEntity.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
        }
        this.m_9236_().m_7967_((Entity)spawnedEntity);
        this.m_146870_();
    }

    public void m_6667_(DamageSource p_21014_) {
        if (this.getBiomass() > (Integer)SConfig.SERVER.reconstructor_biomass.get() / 2) {
            this.summon((Entity)this, true);
        }
        super.m_6667_(p_21014_);
    }

    @Override
    public int getEmerge_tick() {
        return 60;
    }

    public TERRAIN getVariant() {
        return TERRAIN.byId((Integer)this.f_19804_.m_135370_(STATE) & 0xFF);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new AssimilationMenu(i, inventory);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.m_150110_().f_35937_ && !this.m_9236_().f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this, (BlockPos)this.m_20183_());
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public static enum TERRAIN {
        GROUND_LEVEL(0, (List)SConfig.SERVER.reconstructor_terrain.get()),
        WATER_LEVEL(1, (List)SConfig.SERVER.reconstructor_water.get()),
        AIR_LEVEL(2, (List)SConfig.SERVER.reconstructor_air.get()),
        UNDERGROUND(3, (List)SConfig.SERVER.reconstructor_underground.get());

        private final int value;
        private final List<? extends String> list;
        private static final TERRAIN[] BY_ID;

        private TERRAIN(int v, List<? extends String> l) {
            this.value = v;
            this.list = l;
        }

        public int getValue() {
            return this.value;
        }

        public List<? extends String> getList() {
            return this.list;
        }

        public static TERRAIN byId(int id) {
            return BY_ID[id % BY_ID.length];
        }

        static {
            BY_ID = (TERRAIN[])Arrays.stream(TERRAIN.values()).sorted(Comparator.comparingInt(TERRAIN::getValue)).toArray(TERRAIN[]::new);
        }
    }
}

