/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.item;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.util.LuaEntityAccessor;
import com.tacz.guns.api.util.LuaNbtAccessor;
import com.tacz.guns.config.common.AmmoConfig;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunFire;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.custom.AmmoSpeedModifier;
import com.tacz.guns.resource.modifier.custom.InaccuracyModifier;
import com.tacz.guns.resource.modifier.custom.SilenceModifier;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunHeatData;
import com.tacz.guns.resource.pojo.data.gun.InaccuracyType;
import com.tacz.guns.sound.SoundManager;
import com.tacz.guns.util.AttachmentDataUtils;
import com.tacz.guns.util.CycleTaskHelper;
import it.unimi.dsi.fastutil.Pair;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;

public class ModernKineticGunScriptAPI {
    public static String MARKER = "ScriptAPI";
    private LivingEntity shooter;
    private ShooterDataHolder dataHolder;
    private ItemStack itemStack;
    private AbstractGunItem abstractGunItem;
    private CommonGunIndex gunIndex;
    private ResourceLocation gunId;
    private ResourceLocation gunDisplayId;
    private Supplier<Float> pitchSupplier;
    private Supplier<Float> yawSupplier;
    private LuaNbtAccessor nbtUtil;
    private LuaEntityAccessor entityAccessor;

    public void shootOnce(boolean consumeAmmo) {
        GunData gunData = this.gunIndex.getGunData();
        BulletData bulletData = this.gunIndex.getBulletData();
        IGunOperator gunOperator = IGunOperator.fromLivingEntity(this.shooter);
        AttachmentCacheProperty cacheProperty = gunOperator.getCacheProperty();
        if (cacheProperty == null) {
            return;
        }
        float heatInaccuracy = 1.0f;
        if (this.hasHeatData()) {
            GunHeatData heatData = this.gunIndex.getGunData().getHeatData();
            float heatPercentage = this.getHeatAmount() / heatData.getHeatMax();
            heatInaccuracy *= Mth.m_14179_((float)heatPercentage, (float)heatData.getMinInaccuracy(), (float)heatData.getMaxInaccuracy());
        }
        InaccuracyType inaccuracyType = InaccuracyType.getInaccuracyType(this.shooter);
        float inaccuracy = Math.max(0.0f, ((Float)((Map)cacheProperty.getCache(InaccuracyModifier.ID)).get((Object)inaccuracyType)).floatValue() * heatInaccuracy);
        Pair silence = (Pair)cacheProperty.getCache(SilenceModifier.ID);
        int soundDistance = (Integer)silence.first();
        boolean useSilenceSound = (Boolean)silence.right();
        float speed = ((Float)cacheProperty.getCache(AmmoSpeedModifier.ID)).floatValue();
        speed = (float)((double)speed * (Double)AmmoConfig.GLOBAL_BULLET_SPEED_MODIFIER.get());
        float processedSpeed = Mth.m_14036_((float)(speed / 20.0f), (float)0.0f, (float)Float.MAX_VALUE);
        int bulletAmount = Math.max(bulletData.getBulletAmount(), 1);
        FireMode fireMode = this.abstractGunItem.getFireMode(this.itemStack);
        int cycles = fireMode == FireMode.BURST ? gunData.getBurstData().getCount() : 1;
        long period = fireMode == FireMode.BURST ? gunData.getBurstShootInterval() : 1L;
        CycleTaskHelper.addCycleTask(() -> {
            boolean fire;
            if (this.shooter.m_21224_()) {
                return false;
            }
            if (!this.shooter.m_21205_().equals(this.itemStack) || this.shooter.m_21205_().m_41619_()) {
                return false;
            }
            boolean bl = fire = !MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent(this.shooter, this.itemStack, LogicalSide.SERVER));
            if (fire) {
                NetworkHandler.sendToTrackingEntity(new ServerMessageGunFire(this.shooter.m_19879_(), this.itemStack), (Entity)this.shooter);
                if (consumeAmmo && !this.reduceAmmoOnce()) {
                    return false;
                }
                if (this.gunIndex.getGunData().hasHeatData()) {
                    Optional.ofNullable(this.gunIndex.getScript()).map(script -> this.checkFunction(script.get("handle_shoot_heat"))).ifPresentOrElse(func -> func.call(CoerceJavaToLua.coerce((Object)this)), this::handleShootHeat);
                }
                float pitch = this.pitchSupplier != null ? this.pitchSupplier.get().floatValue() : this.shooter.m_146909_();
                float yaw = this.yawSupplier != null ? this.yawSupplier.get().floatValue() : this.shooter.m_146908_();
                Level world = this.shooter.m_9236_();
                ResourceLocation ammoId = gunData.getAmmoId();
                for (int i = 0; i < bulletAmount; ++i) {
                    boolean isTracer = bulletData.hasTracerAmmo() && gunOperator.nextBulletIsTracer(bulletData.getTracerCountInterval());
                    EntityKineticBullet bullet = new EntityKineticBullet(world, this.shooter, this.itemStack, ammoId, this.gunId, this.gunDisplayId, isTracer, gunData, bulletData);
                    this.abstractGunItem.doBulletSpread(this.dataHolder, this.itemStack, this.shooter, bullet, i, processedSpeed, inaccuracy, pitch, yaw);
                    world.m_7967_((Entity)bullet);
                }
                if (soundDistance > 0) {
                    String soundId = useSilenceSound ? SoundManager.SILENCE_3P_SOUND : SoundManager.SHOOT_3P_SOUND;
                    SoundManager.sendSoundToNearby(this.shooter, soundDistance, this.gunId, this.gunDisplayId, soundId, 0.8f, 0.9f + this.shooter.m_217043_().m_188501_() * 0.125f);
                }
            }
            return true;
        }, period, cycles);
    }

    public void handleShootHeat() {
        GunHeatData heatData = this.gunIndex.getGunData().getHeatData();
        if (heatData == null) {
            return;
        }
        float newHeat = Math.min(this.abstractGunItem.getHeatAmount(this.itemStack) + heatData.getHeatPerShot(), heatData.getHeatMax());
        this.abstractGunItem.setHeatAmount(this.itemStack, newHeat);
        if (newHeat >= heatData.getHeatMax()) {
            this.abstractGunItem.setOverheatLocked(this.itemStack, true);
        }
    }

    public boolean reduceAmmoOnce() {
        boolean noAmmo;
        Bolt boltType = TimelessAPI.getCommonGunIndex(this.abstractGunItem.getGunId(this.itemStack)).map(index -> index.getGunData().getBolt()).orElse(null);
        boolean hasAmmoInBarrel = this.abstractGunItem.hasBulletInBarrel(this.itemStack) && boltType != Bolt.OPEN_BOLT;
        boolean hasInventoryAmmo = this.abstractGunItem.hasInventoryAmmo(this.shooter, this.itemStack, this.isReloadingNeedConsumeAmmo());
        boolean bl = noAmmo = this.useInventoryAmmo() && !hasInventoryAmmo || !this.useInventoryAmmo() && this.abstractGunItem.getCurrentAmmoCount(this.itemStack) < 1;
        if (boltType == null) {
            return false;
        }
        if (boltType == Bolt.MANUAL_ACTION) {
            if (!hasAmmoInBarrel) {
                return false;
            }
            this.abstractGunItem.setBulletInBarrel(this.itemStack, false);
            return true;
        }
        if (boltType == Bolt.CLOSED_BOLT) {
            if (!noAmmo) {
                if (this.useInventoryAmmo()) {
                    return this.consumeAmmoFromPlayer(1) == 1;
                }
                this.abstractGunItem.reduceCurrentAmmoCount(this.itemStack);
                return true;
            }
            if (!hasAmmoInBarrel) {
                return false;
            }
            this.abstractGunItem.setBulletInBarrel(this.itemStack, false);
            return true;
        }
        if (boltType == Bolt.OPEN_BOLT) {
            if (noAmmo) {
                return false;
            }
            if (this.useInventoryAmmo()) {
                return this.consumeAmmoFromPlayer(1) == 1;
            }
            this.abstractGunItem.reduceCurrentAmmoCount(this.itemStack);
            return true;
        }
        return false;
    }

    public long getReloadTime() {
        if (this.dataHolder.reloadTimestamp == -1L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.dataHolder.reloadTimestamp;
    }

    public long getBoltTime() {
        if (!this.dataHolder.isBolting) {
            return 0L;
        }
        return System.currentTimeMillis() - this.dataHolder.boltTimestamp;
    }

    public long getShootInterval() {
        FireMode fireMode = this.abstractGunItem.getFireMode(this.itemStack);
        if (fireMode == FireMode.BURST) {
            long coolDown = (long)(this.gunIndex.getGunData().getBurstData().getMinInterval() * 1000.0);
            return Math.max(coolDown -= 5L, 0L);
        }
        long coolDown = this.gunIndex.getGunData().getShootInterval(this.shooter, fireMode, this.itemStack);
        return Math.max(coolDown -= 5L, 0L);
    }

    public long getLastShootTimestamp() {
        return this.dataHolder.lastShootTimestamp + this.dataHolder.baseTimestamp;
    }

    public void adjustShootInterval(long alpha) {
        this.dataHolder.shootTimestamp += alpha;
    }

    public void adjustReloadTime(long alpha) {
        this.dataHolder.reloadTimestamp -= alpha;
    }

    public void adjustBoltTime(long alpha) {
        this.dataHolder.boltTimestamp -= alpha;
    }

    public float getAimingProgress() {
        return this.dataHolder.aimingProgress;
    }

    public int getReloadStateType() {
        return this.dataHolder.reloadStateType.ordinal();
    }

    public int getFireMode() {
        return this.abstractGunItem.getFireMode(this.itemStack).ordinal();
    }

    public boolean isShootingNeedConsumeAmmo() {
        return IGunOperator.fromLivingEntity(this.shooter).consumesAmmoOrNot();
    }

    public boolean isReloadingNeedConsumeAmmo() {
        return IGunOperator.fromLivingEntity(this.shooter).needCheckAmmo();
    }

    public int getNeededAmmoAmount() {
        int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(this.itemStack, this.gunIndex.getGunData());
        int currentAmmoCount = this.abstractGunItem.getCurrentAmmoCount(this.itemStack);
        return maxAmmoCount - currentAmmoCount;
    }

    public int getAmmoAmount() {
        return this.abstractGunItem.getCurrentAmmoCount(this.itemStack);
    }

    public int getMaxAmmoCount() {
        return AttachmentDataUtils.getAmmoCountWithAttachment(this.itemStack, this.gunIndex.getGunData());
    }

    public int getMagExtentLevel() {
        return AttachmentDataUtils.getMagExtendLevel(this.itemStack, this.gunIndex.getGunData());
    }

    public int consumeAmmoFromPlayer(int neededAmount) {
        if (this.useInventoryAmmo() && !this.isReloadingNeedConsumeAmmo()) {
            return neededAmount;
        }
        if (this.abstractGunItem.useDummyAmmo(this.itemStack)) {
            return this.abstractGunItem.findAndExtractDummyAmmo(this.itemStack, neededAmount);
        }
        return this.shooter.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(cap -> this.abstractGunItem.findAndExtractInventoryAmmo((IItemHandler)cap, this.itemStack, neededAmount)).orElse(0);
    }

    public boolean hasAmmoToConsume() {
        if (!this.isReloadingNeedConsumeAmmo()) {
            return true;
        }
        if (this.abstractGunItem.useDummyAmmo(this.itemStack)) {
            return this.abstractGunItem.getDummyAmmoAmount(this.itemStack) > 0;
        }
        return this.shooter.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(cap -> {
            for (int i = 0; i < cap.getSlots(); ++i) {
                IAmmoBox iAmmoBox;
                IAmmo iAmmo;
                ItemStack checkAmmoStack = cap.getStackInSlot(i);
                Item patt16112$temp = checkAmmoStack.m_41720_();
                if (patt16112$temp instanceof IAmmo && (iAmmo = (IAmmo)patt16112$temp).isAmmoOfGun(this.itemStack, checkAmmoStack)) {
                    return true;
                }
                Item patt16285$temp = checkAmmoStack.m_41720_();
                if (!(patt16285$temp instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)patt16285$temp).isAmmoBoxOfGun(this.itemStack, checkAmmoStack)) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    public int putAmmoInMagazine(int amount) {
        int currentAmmoCount;
        int newAmmoCount;
        if (amount < 0) {
            return 0;
        }
        int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(this.itemStack, this.gunIndex.getGunData());
        if (maxAmmoCount < (newAmmoCount = (currentAmmoCount = this.abstractGunItem.getCurrentAmmoCount(this.itemStack)) + amount)) {
            this.abstractGunItem.setCurrentAmmoCount(this.itemStack, maxAmmoCount);
            return newAmmoCount - maxAmmoCount;
        }
        this.abstractGunItem.setCurrentAmmoCount(this.itemStack, newAmmoCount);
        return 0;
    }

    public int removeAmmoFromMagazine(int amount) {
        if (amount < 0) {
            return 0;
        }
        int currentAmmoCount = this.abstractGunItem.getCurrentAmmoCount(this.itemStack);
        if (currentAmmoCount < amount) {
            this.abstractGunItem.setCurrentAmmoCount(this.itemStack, 0);
            return currentAmmoCount;
        }
        this.abstractGunItem.setCurrentAmmoCount(this.itemStack, currentAmmoCount - amount);
        return amount;
    }

    public int getAmmoCountInMagazine() {
        return this.abstractGunItem.getCurrentAmmoCount(this.itemStack);
    }

    public boolean hasAmmoInBarrel() {
        Bolt boltType = this.gunIndex.getGunData().getBolt();
        return boltType != Bolt.OPEN_BOLT && this.abstractGunItem.hasBulletInBarrel(this.itemStack);
    }

    public void setAmmoInBarrel(boolean ammoInBarrel) {
        this.abstractGunItem.setBulletInBarrel(this.itemStack, ammoInBarrel);
    }

    public void cacheScriptData(LuaValue luaValue) {
        this.dataHolder.scriptData = luaValue;
    }

    public LuaValue getCachedScriptData() {
        return this.dataHolder.scriptData;
    }

    public LuaTable getScriptParams() {
        LuaTable param = this.gunIndex.getScriptParam();
        return param == null ? new LuaTable() : param;
    }

    public void safeAsyncTask(LuaValue value, long delayMs, long periodMs, int cycles) {
        LuaFunction func = value.checkfunction();
        CycleTaskHelper.addCycleTask(() -> func.call().checkboolean(), delayMs, periodMs, cycles);
    }

    public long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }

    public String getAttachment(String type) {
        try {
            AttachmentType t = AttachmentType.valueOf(type);
            return this.abstractGunItem.getAttachmentId(this.itemStack, t).toString();
        }
        catch (IllegalArgumentException e) {
            return DefaultAssets.EMPTY_ATTACHMENT_ID.toString();
        }
    }

    public LuaNbtAccessor getNbt() {
        return this.nbtUtil;
    }

    public LuaEntityAccessor getEntityUtil() {
        if (this.entityAccessor == null) {
            this.entityAccessor = new LuaEntityAccessor(this.shooter);
        }
        return this.entityAccessor;
    }

    public void setShooter(LivingEntity shooter) {
        this.shooter = shooter;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.initGunItem();
    }

    public void setPitchSupplier(Supplier<Float> pitchSupplier) {
        this.pitchSupplier = pitchSupplier;
    }

    public void setYawSupplier(Supplier<Float> yawSupplier) {
        this.yawSupplier = yawSupplier;
    }

    public LivingEntity getShooter() {
        return this.shooter;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public AbstractGunItem getAbstractGunItem() {
        return this.abstractGunItem;
    }

    public CommonGunIndex getGunIndex() {
        return this.gunIndex;
    }

    public void setHeatAmount(float amount) {
        this.abstractGunItem.setHeatAmount(this.itemStack, amount);
    }

    public float getHeatAmount() {
        return this.abstractGunItem.getHeatAmount(this.itemStack);
    }

    public boolean hasHeatData() {
        return this.gunIndex.getGunData().getHeatData() != null;
    }

    public float getHeatMinRpm() {
        if (this.hasHeatData()) {
            return this.gunIndex.getGunData().getHeatData().getMinRpmMod();
        }
        return 0.0f;
    }

    public float getHeatMaxRpm() {
        if (this.hasHeatData()) {
            return this.gunIndex.getGunData().getHeatData().getMaxRpmMod();
        }
        return 0.0f;
    }

    public float getHeatMinInaccuracy() {
        if (this.hasHeatData()) {
            return this.gunIndex.getGunData().getHeatData().getMinInaccuracy();
        }
        return 0.0f;
    }

    public float getHeatMaxInaccuracy() {
        if (this.hasHeatData()) {
            return this.gunIndex.getGunData().getHeatData().getMaxInaccuracy();
        }
        return 0.0f;
    }

    public float getHeatMax() {
        if (this.hasHeatData()) {
            return this.gunIndex.getGunData().getHeatData().getHeatMax();
        }
        return 0.0f;
    }

    public float getHeatPerShot() {
        if (this.hasHeatData()) {
            return this.gunIndex.getGunData().getHeatData().getHeatPerShot();
        }
        return 0.0f;
    }

    public boolean isOverheatLocked() {
        return this.abstractGunItem.isOverheatLocked(this.itemStack);
    }

    public void setOverheatLocked(boolean locked) {
        this.abstractGunItem.setOverheatLocked(this.itemStack, locked);
    }

    public long getOverheatTime() {
        if (this.hasHeatData()) {
            return this.gunIndex.getGunData().getHeatData().getOverHeatTime();
        }
        return 0L;
    }

    public long getCoolingDelay() {
        if (this.hasHeatData()) {
            return this.gunIndex.getGunData().getHeatData().getCoolingDelay();
        }
        return 0L;
    }

    public float calcHeatReduction(long heatTimestamp) {
        GunHeatData heatData = this.gunIndex.getGunData().getHeatData();
        if (heatData != null) {
            return (float)(System.currentTimeMillis() - heatTimestamp) / 10000.0f * heatData.getCoolingMultiplier();
        }
        return 0.0f;
    }

    public int getBoltByInt() {
        Bolt bolt = this.gunIndex.getGunData().getBolt();
        if (bolt == Bolt.MANUAL_ACTION) {
            return 1;
        }
        if (bolt == Bolt.CLOSED_BOLT) {
            return 2;
        }
        if (bolt == Bolt.OPEN_BOLT) {
            return 3;
        }
        return 0;
    }

    public Bolt getBolt() {
        return this.gunIndex.getGunData().getBolt();
    }

    public void setDataHolder(ShooterDataHolder dataHolder) {
        this.dataHolder = dataHolder;
    }

    public boolean useInventoryAmmo() {
        return this.abstractGunItem.useInventoryAmmo(this.itemStack);
    }

    ShooterDataHolder getDataHolder() {
        return this.dataHolder;
    }

    private void initGunItem() {
        Item item;
        if (this.itemStack == null || !((item = this.itemStack.m_41720_()) instanceof AbstractGunItem)) {
            this.gunIndex = null;
            this.abstractGunItem = null;
            return;
        }
        AbstractGunItem gunItem = (AbstractGunItem)item;
        this.gunId = gunItem.getGunId(this.itemStack);
        this.gunDisplayId = gunItem.getGunDisplayId(this.itemStack);
        Optional<CommonGunIndex> gunIndexOptional = TimelessAPI.getCommonGunIndex(this.gunId);
        this.gunIndex = gunIndexOptional.orElse(null);
        this.abstractGunItem = gunItem;
        if (this.itemStack.m_41782_()) {
            this.nbtUtil = new LuaNbtAccessor(this.itemStack.m_41783_());
        }
    }

    private LuaFunction checkFunction(LuaValue luaValue) {
        if (luaValue.isfunction()) {
            return (LuaFunction)luaValue;
        }
        if (luaValue.isnil()) {
            return null;
        }
        throw new LuaError("bad argument: function or nil expected, got " + luaValue.typename());
    }
}

