/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.base;

import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.base.VoltageAlteringBlockEntity;
import com.drmangotea.tfmg.content.electricity.utilities.diode.ElectricDiodeBlockEntity;
import com.drmangotea.tfmg.content.electricity.utilities.electric_motor.ElectricMotorBlockEntity;
import com.drmangotea.tfmg.content.electricity.utilities.transformer.TransformerBlockEntity;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;

public class ElectricalNetwork {
    public List<IElectric> members = new ArrayList<IElectric>();
    public long id;

    public ElectricalNetwork(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void add(IElectric be) {
        ArrayList posList = new ArrayList();
        this.members.forEach(member -> posList.add(member.getData().getId()));
        if (posList.contains(be.getData().getId())) {
            return;
        }
        this.members.add(be);
    }

    public void updateNetwork() {
        int maxVoltage = 0;
        int power = 0;
        int resistance = 0;
        int powerGeneration = 0;
        HashMap<Integer, Float> groups = new HashMap<Integer, Float>();
        for (IElectric member : this.members) {
            member.getData().notEnoughtPower = false;
            int groupId = member.getData().group.id;
            maxVoltage = Math.max(member.voltageGeneration(), maxVoltage);
            power += member.powerGeneration();
            resistance += (int)member.resistance();
            powerGeneration += member.powerGeneration();
            if (!member.canBeInGroups()) continue;
            groups.put(groupId, Float.valueOf(groups.containsKey(groupId) ? ((Float)groups.get(groupId)).floatValue() + member.resistance() : member.resistance()));
        }
        int powerPercentage = resistance > 0 ? (int)Math.min((float)power / (float)resistance * 100.0f, 100.0f) : 100;
        ArrayList<IElectric> list = new ArrayList<IElectric>(this.members);
        if (!this.members.isEmpty()) {
            float powerUsage = this.members.get(0).getNetworkPowerUsage();
            for (IElectric member : list) {
                int oldVoltage = member.getData().getVoltage();
                int oldPower = member.getPowerUsage();
                member.getData().voltageSupply = maxVoltage;
                member.setVoltage(maxVoltage);
                member.getData().setVoltageNextTick = true;
                member.getData().networkPowerGeneration = powerGeneration;
                member.setNetworkResistance(resistance);
                member.onNetworkChanged(oldVoltage, oldPower);
                if (!groups.containsKey(member.getData().group.id)) continue;
                member.getData().group.resistance = ((Float)groups.get(member.getData().group.id)).floatValue();
            }
        }
        for (IElectric member : this.members) {
            VoltageAlteringBlockEntity be;
            member.getData().highestCurrent = ElectricalNetwork.getCableCurrent(member);
            member.updateNearbyNetworks(member);
            if (member instanceof ElectricDiodeBlockEntity) {
                be = (ElectricDiodeBlockEntity)member;
                ((ElectricDiodeBlockEntity)be).updateInFront();
            }
            if (!(member instanceof TransformerBlockEntity)) continue;
            be = (TransformerBlockEntity)member;
            ((TransformerBlockEntity)be).updateInFront();
        }
        this.handleInsufficientPower();
    }

    public void handleInsufficientPower() {
        if (!this.members.isEmpty() && this.members.get(0).getNetworkPowerUsage() > this.members.get(0).getNetworkPowerGeneration()) {
            for (IElectric member : this.members) {
                IHaveHoveringInformation be;
                member.getData().notEnoughtPower = true;
                if (member instanceof ElectricMotorBlockEntity) {
                    be = (ElectricMotorBlockEntity)member;
                    be.updateGeneratedRotation();
                }
                if (member instanceof ElectricDiodeBlockEntity) {
                    be = (ElectricDiodeBlockEntity)member;
                    be.updateInFront = true;
                }
                if (!(member instanceof TransformerBlockEntity)) continue;
                be = (TransformerBlockEntity)member;
                be.updateInFront();
            }
        }
    }

    public static float getCableCurrent(IElectric be) {
        float current = 0.0f;
        ArrayList<Integer> groups = new ArrayList<Integer>();
        for (IElectric member : be.getOrCreateElectricNetwork().members) {
            if (!member.canBeInGroups() || groups.contains(member.getData().group.id)) continue;
            groups.add(member.getData().group.id);
            if (member.resistance() == 0.0f) continue;
            current += (float)member.getData().voltage / member.resistance();
        }
        return current;
    }

    public void checkForLoops(BlockPos pos) {
        this.members.forEach(member -> {
            VoltageAlteringBlockEntity be;
            if (member instanceof VoltageAlteringBlockEntity && (be = (VoltageAlteringBlockEntity)member).getControlledBlock() != null) {
                ArrayList<ElectricalNetwork> list = new ArrayList<ElectricalNetwork>();
                list.add(this);
                be.getControlledBlock().getOrCreateElectricNetwork().checkForLoops(list, pos);
            }
        });
    }

    public void checkForLoops(List<ElectricalNetwork> network, BlockPos pos) {
        if (network.contains(this)) {
            if (!this.members.isEmpty()) {
                this.members.get(0).getLevelAccessor().m_46961_(pos, false);
            }
            return;
        }
        network.add(this);
        this.members.forEach(member -> {
            VoltageAlteringBlockEntity be;
            if (member instanceof VoltageAlteringBlockEntity && (be = (VoltageAlteringBlockEntity)member).getControlledBlock() != null) {
                be.getControlledBlock().getOrCreateElectricNetwork().checkForLoops(network, pos);
            }
        });
    }

    public List<IElectric> getMembers() {
        return this.members;
    }
}

