/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.connection.cables;

import com.drmangotea.tfmg.base.blocks.WallMountBlock;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.content.electricity.connection.cables.CableConnection;
import com.drmangotea.tfmg.content.electricity.connection.cables.CableConnectorBlock;
import com.drmangotea.tfmg.content.electricity.connection.cables.CablePos;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class CableConnectorBlockEntity
extends ElectricBlockEntity
implements IHaveHoveringInformation {
    public Player player;
    public int color = 0;
    public LerpedFloat wireMovementX = LerpedFloat.linear();
    public LerpedFloat wireMovementY = LerpedFloat.linear();
    public LerpedFloat wireMovementZ = LerpedFloat.linear();
    public List<CableConnection> connections = new ArrayList<CableConnection>();
    public long id;
    public boolean removeWiresNextTick = false;

    public CableConnectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.wireMovementX.setValue((double)pos.m_123341_());
        this.wireMovementY.setValue((double)pos.m_123342_());
        this.wireMovementZ.setValue((double)pos.m_123343_());
        this.id = this.m_58899_().m_121878_();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    public void remove() {
        super.remove();
        this.notifyRemoval();
        this.dropWires();
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        if (((Boolean)this.m_58900_().m_61143_((Property)CableConnectorBlock.EXTENSION)).booleanValue()) {
            return direction.m_122434_() == ((Direction)this.m_58900_().m_61143_((Property)WallMountBlock.FACING)).m_122434_();
        }
        return direction == ((Direction)this.m_58900_().m_61143_((Property)WallMountBlock.FACING)).m_122424_();
    }

    public void dropWires() {
        for (CableConnection connection : this.connections) {
            ItemEntity itemToDrop = new ItemEntity(this.f_58857_, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 0.5f), (double)((float)this.m_58899_().m_123343_() + 0.5f), new ItemStack((ItemLike)connection.type.getSpool().get(), (int)(connection.getLength() / 8.0f)));
            if (itemToDrop.m_32055_().m_41613_() <= 0) continue;
            this.f_58857_.m_7967_((Entity)itemToDrop);
        }
    }

    public void notifyRemoval() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        for (CableConnection connection : this.connections) {
            CableConnectorBlockEntity be;
            BlockPos pos = connection.blockPos1;
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof CableConnectorBlockEntity) || (be = (CableConnectorBlockEntity)blockEntity).m_58899_() == this.m_58899_()) continue;
            be.onPlaced();
            be.removeWiresNextTick = true;
        }
    }

    public void removeConnection() {
        this.connections.removeIf(c -> {
            BlockPos pos = c.blockPos1;
            return !(this.f_58857_.m_7702_(pos) instanceof CableConnectorBlockEntity);
        });
        this.sendStuff();
    }

    @Override
    public void onConnected() {
        super.onConnected();
        for (CableConnectorBlockEntity be : this.getConnectedWires()) {
            if (be.getData().getId() != this.getData().getId()) {
                be.setNetwork(this.getData().getId());
                be.onConnected();
            }
            be.sendStuff();
        }
        this.sendStuff();
    }

    public List<CableConnectorBlockEntity> getConnectedWires() {
        return this.getConnectedWires(new ArrayList<CableConnectorBlockEntity>());
    }

    public List<CableConnectorBlockEntity> getConnectedWires(List<CableConnectorBlockEntity> foundList) {
        if (!foundList.contains(this)) {
            foundList.add(this);
        }
        for (CableConnection connection : this.connections) {
            CableConnectorBlockEntity be;
            BlockEntity blockEntity;
            BlockPos pos = connection.blockPos1;
            if (pos == this.m_58899_() || !((blockEntity = this.f_58857_.m_7702_(pos)) instanceof CableConnectorBlockEntity) || foundList.contains(be = (CableConnectorBlockEntity)blockEntity)) continue;
            be.getConnectedWires(foundList);
            this.sendStuff();
            be.sendStuff();
        }
        this.sendStuff();
        return foundList;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.removeWiresNextTick) {
            this.removeConnection();
            this.removeWiresNextTick = false;
        }
        if (this.player != null) {
            this.managePlayerWire();
        }
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("ConnectionCount", this.connections.size());
        for (int i = 0; i < this.connections.size(); ++i) {
            CableConnection connection = this.connections.get(i);
            compound.m_128365_("Connection" + i, (Tag)connection.saveConnection());
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.connections = new ArrayList<CableConnection>();
        for (int i = 0; i < compound.m_128451_("ConnectionCount"); ++i) {
            this.connections.add(CableConnection.loadConnection(compound.m_128469_("Connection" + i)));
        }
    }

    public void managePlayerWire() {
        this.wireMovementX.chase(this.player.m_20185_() - 0.5, 0.7, LerpedFloat.Chaser.EXP);
        this.wireMovementY.chase(this.player.m_20186_() + (this.player.m_6047_() ? 0.6 : 0.9), 0.3, LerpedFloat.Chaser.EXP);
        this.wireMovementZ.chase(this.player.m_20189_() - 0.5, 0.7, LerpedFloat.Chaser.EXP);
        this.wireMovementX.tickChaser();
        this.wireMovementY.tickChaser();
        this.wireMovementZ.tickChaser();
    }

    public CablePos getCablePosition() {
        return new CablePos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_());
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(32.0);
    }
}

