/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.storage;

import net.minecraftforge.energy.EnergyStorage;

public abstract class TFMGForgeEnergyStorage
extends EnergyStorage {
    public TFMGForgeEnergyStorage(int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int oldAmount = this.energy;
        int extractedEnergy = super.extractEnergy(maxExtract, simulate);
        if (extractedEnergy != 0) {
            this.onEnergyChanged(maxExtract * -1, oldAmount);
        }
        return extractedEnergy;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int oldAmount = this.energy;
        int receiveEnergy = super.receiveEnergy(maxReceive, simulate);
        if (receiveEnergy != 0) {
            this.onEnergyChanged(receiveEnergy, oldAmount);
        }
        return receiveEnergy;
    }

    public int setEnergy(int energy) {
        this.energy = energy;
        if (energy > 0) {
            this.onEnergyChanged(energy, this.energy);
        }
        return 0;
    }

    public abstract void onEnergyChanged(int var1, int var2);
}

