/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.registry;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.content.electricity.base.ConnectNeightborsPacket;
import com.drmangotea.tfmg.content.electricity.base.ElectricPlacementPacket;
import com.drmangotea.tfmg.content.electricity.base.NetworkUpdatePacket;
import com.drmangotea.tfmg.content.electricity.base.UpdateInFrontPacket;
import com.drmangotea.tfmg.content.electricity.configuration_wrench.ElectriciansWrenchPacket;
import com.drmangotea.tfmg.content.electricity.connection.cables.CablePlacePacket;
import com.drmangotea.tfmg.content.engines.engine_controller.TransmissionRemovePacket;
import com.drmangotea.tfmg.content.engines.engine_controller.packets.EngineControllerBindPacket;
import com.drmangotea.tfmg.content.engines.engine_controller.packets.EngineControllerInputPacket;
import com.drmangotea.tfmg.content.engines.engine_controller.packets.EngineControllerStopControllerPacket;
import com.drmangotea.tfmg.content.engines.engine_controller.packets.EngineStartPacket;
import com.drmangotea.tfmg.content.engines.engine_controller.packets.TransmissionShiftPacket;
import com.drmangotea.tfmg.content.items.weapons.advanced_potato_cannon.AdvancedPotatoCannonPacket;
import com.drmangotea.tfmg.content.items.weapons.quad_potato_cannon.QuadPotatoCannonPacket;
import com.drmangotea.tfmg.content.machinery.metallurgy.coke_oven.CokeOvenPacket;
import com.drmangotea.tfmg.content.machinery.vat.base.VatEvaluationPacket;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public enum TFMGPackets {
    ADVANCED_POTATO_CANNON(AdvancedPotatoCannonPacket.class, AdvancedPotatoCannonPacket::new, NetworkDirection.PLAY_TO_CLIENT),
    QUAD_POTATO_CANNON(QuadPotatoCannonPacket.class, QuadPotatoCannonPacket::new, NetworkDirection.PLAY_TO_CLIENT),
    CONNECT_NEIGHBORS(ConnectNeightborsPacket.class, ConnectNeightborsPacket::new, NetworkDirection.PLAY_TO_CLIENT),
    NETWORK_UPDATE(NetworkUpdatePacket.class, NetworkUpdatePacket::new, NetworkDirection.PLAY_TO_CLIENT),
    CONNECTION_PACKET(ElectricPlacementPacket.class, ElectricPlacementPacket::new, NetworkDirection.PLAY_TO_CLIENT),
    VAT_EVALUATION(VatEvaluationPacket.class, VatEvaluationPacket::new, NetworkDirection.PLAY_TO_CLIENT),
    COKE_OVEN_PACKET(CokeOvenPacket.class, CokeOvenPacket::new, NetworkDirection.PLAY_TO_CLIENT),
    UPDATE_IN_FRONT_PACKET(UpdateInFrontPacket.class, UpdateInFrontPacket::new, NetworkDirection.PLAY_TO_CLIENT),
    TRANSMISSION_REMOVE(TransmissionRemovePacket.class, TransmissionRemovePacket::new, NetworkDirection.PLAY_TO_CLIENT),
    CABLE_PLACE_PACKET(CablePlacePacket.class, CablePlacePacket::new, NetworkDirection.PLAY_TO_CLIENT),
    ELECTRICIANS_WRENCH_PACKET(ElectriciansWrenchPacket.class, ElectriciansWrenchPacket::new, NetworkDirection.PLAY_TO_SERVER),
    ENGINE_CONTROLLER_INPUT(EngineControllerInputPacket.class, EngineControllerInputPacket::new, NetworkDirection.PLAY_TO_SERVER),
    ENGINE_CONTROLLER_BIND(EngineControllerBindPacket.class, EngineControllerBindPacket::new, NetworkDirection.PLAY_TO_SERVER),
    ENGINE_TRANSMISSION_PACKET(TransmissionShiftPacket.class, TransmissionShiftPacket::new, NetworkDirection.PLAY_TO_SERVER),
    ENGINE_CONTROLLER_STOP_CONTROL(EngineControllerStopControllerPacket.class, EngineControllerStopControllerPacket::new, NetworkDirection.PLAY_TO_SERVER),
    ENGINE_START(EngineStartPacket.class, EngineStartPacket::new, NetworkDirection.PLAY_TO_SERVER);

    public static final ResourceLocation CHANNEL_NAME;
    public static final int NETWORK_VERSION = 3;
    public static final String NETWORK_VERSION_STR;
    private static SimpleChannel channel;
    private PacketType<?> packetType;

    private <T extends SimplePacketBase> TFMGPackets(Class<T> type, Function<FriendlyByteBuf, T> factory, NetworkDirection direction) {
        this.packetType = new PacketType<T>(type, factory, direction);
    }

    public static void registerPackets() {
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)CHANNEL_NAME).serverAcceptedVersions(NETWORK_VERSION_STR::equals).clientAcceptedVersions(NETWORK_VERSION_STR::equals).networkProtocolVersion(() -> NETWORK_VERSION_STR).simpleChannel();
        for (TFMGPackets packet : TFMGPackets.values()) {
            packet.packetType.register();
        }
    }

    public static SimpleChannel getChannel() {
        return channel;
    }

    public static void sendToNear(Level world, BlockPos pos, int range, Object message) {
        TFMGPackets.getChannel().send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)range, (ResourceKey)world.m_46472_())), message);
    }

    static {
        CHANNEL_NAME = TFMG.asResource("main");
        NETWORK_VERSION_STR = String.valueOf(3);
    }

    private static class PacketType<T extends SimplePacketBase> {
        private static int index = 0;
        private BiConsumer<T, FriendlyByteBuf> encoder = SimplePacketBase::write;
        private Function<FriendlyByteBuf, T> decoder;
        private BiConsumer<T, Supplier<NetworkEvent.Context>> handler;
        private Class<T> type;
        private NetworkDirection direction;

        private PacketType(Class<T> type, Function<FriendlyByteBuf, T> factory, NetworkDirection direction) {
            this.decoder = factory;
            this.handler = (packet, contextSupplier) -> {
                NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
                if (packet.handle(context)) {
                    context.setPacketHandled(true);
                }
            };
            this.type = type;
            this.direction = direction;
        }

        private void register() {
            TFMGPackets.getChannel().messageBuilder(this.type, index++, this.direction).encoder(this.encoder).decoder(this.decoder).consumerNetworkThread(this.handler).add();
        }
    }
}

