/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;

public class ItemReadableScroll
extends ItemGeneric {
    protected static final String CONTENT_ID_NBT_STRING = "content_id";
    protected static final String CONTENT_PART_NBT_INT = "content_part";

    public ItemReadableScroll() {
        super("readable_scroll", ItemReadableScroll.getBuilder().m_41487_(1).m_41486_());
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        MutableComponent author = Component.m_237115_((String)("readable_scroll." + this.getContentId(stack) + ".author"));
        if (!author.getString().isEmpty()) {
            tooltip.add((Component)Component.m_237110_((String)"readable_scroll.by_author", (Object[])new Object[]{author}).m_6270_(StyleType.INFO));
        }
        tooltip.add((Component)Component.m_237115_((String)"readable_scroll.read_info").m_6270_(StyleType.TOOLTIP_USE));
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.m_5776_() && stack.m_150930_((Item)this) && TimeHelper.atInterval(level, 100) && this.getContentId(stack).isEmpty()) {
            stack.m_41774_(1);
        }
    }

    public Component m_7626_(ItemStack stack) {
        return Component.m_237110_((String)"readable_scroll.title", (Object[])new Object[]{Component.m_237115_((String)("readable_scroll." + this.getContentId(stack) + ".title")), this.getContentPart(stack)}).m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack;
        if (level.f_46443_ && (stack = player.m_21120_(hand)).m_150930_((Item)this)) {
            ModTombstone.PROXY.openReadableScrollScreen(this.getContentId(stack), this.getContentPart(stack));
        }
        return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.m_5776_());
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public ItemStack createScroll(String title, int part) {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.setContent(stack, title, part);
        return stack;
    }

    public void setContent(ItemStack stack, String title, int part) {
        NBTStackHelper.setString(stack, CONTENT_ID_NBT_STRING, title);
        NBTStackHelper.setInteger(stack, CONTENT_PART_NBT_INT, part);
    }

    public String getContentId(ItemStack stack) {
        return NBTStackHelper.getString(stack, CONTENT_ID_NBT_STRING);
    }

    public int getContentPart(ItemStack stack) {
        return NBTStackHelper.getInteger(stack, CONTENT_PART_NBT_INT);
    }
}

